/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellEditor;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;

public abstract class SimpleNodeCellEditor<T>
extends AbstractCellEditor
implements NodeCellEditor {
    private final AbstractColoredNodeCellRenderer myRenderer;
    private final JTextField myField;
    private final T myValue;
    private final Project myProject;

    public SimpleNodeCellEditor(T value, Project project) {
        this.myValue = value;
        this.myProject = project;
        this.myField = new JTextField();
        this.myField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 9: 
                    case 10: {
                        SimpleNodeCellEditor.this.stopCellEditing();
                        break;
                    }
                    case 27: {
                        SimpleNodeCellEditor.this.cancelCellEditing();
                    }
                }
            }
        });
        this.myRenderer = new AbstractColoredNodeCellRenderer(null){

            @Override
            public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
                wrapper.add(SimpleNodeCellEditor.this.myField);
            }
        };
    }

    @Override
    public Object getCellEditorValue() {
        return this.myField.getText();
    }

    @Override
    public JComponent getNodeCellEditorComponent(Graph2DView view, NodeRealizer context, Object value, boolean isSelected) {
        this.myField.setText(this.getEditorValue(this.myValue));
        JComponent rendererComponent = this.myRenderer.getNodeCellRendererComponent(view, context, value, isSelected);
        this.myField.selectAll();
        IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myField, true);
        return rendererComponent;
    }

    protected abstract String getEditorValue(T var1);

    protected abstract void setEditorValue(T var1, String var2);

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        super.addCellEditorListener(l);
    }

    @Override
    public boolean stopCellEditing() {
        this.setEditorValue(this.myValue, this.myField.getText());
        this.cancelCellEditing();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }
}

