/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.api;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.api.TestDiscoveryProtocolReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;

public abstract class SimpleDecodingTestDiscoveryProtocolReader
implements TestDiscoveryProtocolReader,
TestDiscoveryProtocolReader.NameEnumeratorReader,
TestDiscoveryProtocolReader.MetadataReader {
    private final TIntObjectHashMap<String> enumerator = new TIntObjectHashMap();

    protected abstract void processData(String var1, String var2, String var3, String var4);

    protected void processAffectedFile(String testClassName, String testMethodName, String filePath) {
    }

    protected abstract void processClassMetadataData(ClassMetadata var1);

    @Override
    public void debug(String message) {
    }

    @Override
    public void error(String message) {
    }

    @Override
    public void error(Exception error) {
    }

    @Override
    public void testDiscoveryDataProcessingStarted(int version) {
    }

    @Override
    public void testDiscoveryDataProcessingFinished() {
    }

    @Override
    public TestDiscoveryProtocolReader.MetadataReader createMetadataReader() {
        return this;
    }

    @Override
    public TestDiscoveryProtocolReader.ClassMetadataReader createClassMetadataReader() {
        return new TestDiscoveryProtocolReader.ClassMetadataReader(){
            private Map<String, byte[]> methods;
            private List<String> files;
            private String fqn;
            {
                this.reset();
            }

            @Override
            public void classStarted(int classId) {
                this.fqn = (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(classId);
            }

            @Override
            public void file(int fileId) {
                this.files.add((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(fileId));
            }

            @Override
            public void method(int methodId, byte[] hash) {
                this.methods.put((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(methodId), hash);
            }

            @Override
            public void classFinished(int classId) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processClassMetadataData(new ClassMetadata(this.fqn, this.files, this.methods));
                this.reset();
            }

            private void reset() {
                this.fqn = null;
                this.files = new ArrayList<String>(1);
                this.methods = new HashMap<String, byte[]>(16);
            }

            @Override
            public void finished() {
            }
        };
    }

    @Override
    public TestDiscoveryProtocolReader.NameEnumeratorReader createNameEnumeratorReader() {
        return this;
    }

    @Override
    public void enumerate(String name, int id) {
        this.enumerator.put(id, name);
    }

    @Override
    public TestDiscoveryProtocolReader.TestDataReader createTestDataReader(final int testClassId, final int testMethodId) {
        return new TestDiscoveryProtocolReader.TestDataReader(){
            private String currentClassName;

            @Override
            public void classProcessingStarted(int classId) {
                this.currentClassName = (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(classId);
            }

            @Override
            public void processUsedMethod(int methodId) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processData((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testClassId), (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testMethodId), this.currentClassName, (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(methodId));
            }

            @Override
            public void classProcessingFinished(int classId) {
            }

            @Override
            public void testDataProcessed() {
            }

            @Override
            public void processAffectedFile(int[] chunks) {
                SimpleDecodingTestDiscoveryProtocolReader.this.processAffectedFile((String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testClassId), (String)SimpleDecodingTestDiscoveryProtocolReader.this.enumerator.get(testMethodId), SimpleDecodingTestDiscoveryProtocolReader.this.decodeFile(chunks));
            }
        };
    }

    private String decodeFile(int[] chunks) {
        if (chunks.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int chunk : chunks) {
            sb.append(this.enumerator.get(chunk)).append("/");
        }
        sb.setLength(sb.length() - "/".length());
        return sb.toString();
    }
}

