/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra;

import com.intellij.lexer.Lexer;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.cassandra.CassandraDialect;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer._CassandraLexer;
import org.jetbrains.annotations.Nullable;

public class CassandraLexer
extends SqlLexer {
    public CassandraLexer() {
        super(CassandraDialect.LazyData.ourClasses, new _CassandraLexer());
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = CassandraLexer.getDollarQuotingIdent(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    @Nullable
    private static String getDollarQuotingIdent(Lexer baseLexer) {
        if (baseLexer.getTokenType() != SqlTokens.SQL_IDENT_DELIMITED) {
            return null;
        }
        String identText = baseLexer.getTokenText();
        return "$$".equals(identText) ? identText : null;
    }
}

