/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextRangeUtil {
    public static final Comparator<TextRange> RANGE_COMPARATOR = new Comparator<TextRange>(){

        @Override
        public int compare(TextRange range1, TextRange range2) {
            int startOffsetDiff = range1.getStartOffset() - range2.getStartOffset();
            return startOffsetDiff != 0 ? startOffsetDiff : range1.getEndOffset() - range2.getEndOffset();
        }
    };

    private TextRangeUtil() {
    }

    public static Iterable<TextRange> excludeRanges(@NotNull TextRange original, @NotNull List<? extends TextRange> excludedRanges) {
        if (original == null) {
            TextRangeUtil.$$$reportNull$$$0(0);
        }
        if (excludedRanges == null) {
            TextRangeUtil.$$$reportNull$$$0(1);
        }
        if (!excludedRanges.isEmpty()) {
            if (excludedRanges.size() > 1) {
                Collections.sort(excludedRanges, RANGE_COMPARATOR);
            }
            int enabledRangeStart = original.getStartOffset();
            ArrayList<TextRange> enabledRanges = new ArrayList<TextRange>();
            for (TextRange textRange : excludedRanges) {
                if (textRange.getEndOffset() < enabledRangeStart) continue;
                int excludedRangeStart = textRange.getStartOffset();
                if (excludedRangeStart > original.getEndOffset()) break;
                if (excludedRangeStart > enabledRangeStart) {
                    enabledRanges.add(new TextRange(enabledRangeStart, excludedRangeStart));
                }
                enabledRangeStart = textRange.getEndOffset();
            }
            if (enabledRangeStart < original.getEndOffset()) {
                enabledRanges.add(new TextRange(enabledRangeStart, original.getEndOffset()));
            }
            return enabledRanges;
        }
        return Collections.singletonList(original);
    }

    @NotNull
    public static TextRange getEnclosingTextRange(@NotNull List<? extends TextRange> textRanges) {
        if (textRanges == null) {
            TextRangeUtil.$$$reportNull$$$0(2);
        }
        if (textRanges.isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                TextRangeUtil.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int lowerBound = textRanges.get(0).getStartOffset();
        int upperBound = textRanges.get(0).getEndOffset();
        for (int i = 1; i < textRanges.size(); ++i) {
            TextRange textRange = textRanges.get(i);
            lowerBound = Math.min(lowerBound, textRange.getStartOffset());
            upperBound = Math.max(upperBound, textRange.getEndOffset());
        }
        TextRange textRange = new TextRange(lowerBound, upperBound);
        if (textRange == null) {
            TextRangeUtil.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public static int getDistance(@NotNull Segment r2, @NotNull Segment r1) {
        if (r2 == null) {
            TextRangeUtil.$$$reportNull$$$0(5);
        }
        if (r1 == null) {
            TextRangeUtil.$$$reportNull$$$0(6);
        }
        int s1 = r1.getStartOffset();
        int e1 = r1.getEndOffset();
        int s2 = r2.getStartOffset();
        int e2 = r2.getEndOffset();
        return Math.max(s1, s2) <= Math.min(e1, e2) ? 0 : Math.min(Math.abs(s1 - e2), Math.abs(s2 - e1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedRanges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRanges";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/TextRangeUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/TextRangeUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "excludeRanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingTextRange";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDistance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

