/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

class ReflectUtil {
    public static Class typeToClass(String name, ClassLoader classLoader) {
        char c = name.charAt(0);
        switch (c) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
            case 'L': {
                if (name.charAt(name.length() - 1) != ';') {
                    throw new InternalError("Invalid class name format");
                }
                String formalName = name.substring(1, name.length() - 1);
                formalName = formalName.replace('/', '.');
                try {
                    return Class.forName(formalName, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new InternalError(e.toString());
                }
            }
            case '[': {
                String formalName = name.replace('/', '.');
                try {
                    return Class.forName(formalName, true, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new InternalError(e.toString());
                }
            }
        }
        throw new InternalError("Unknown type:" + name);
    }

    public static Class[] namesToClasses(String[] names, ClassLoader classLoader) {
        Class[] classes = new Class[names.length];
        int i = 0;
        while (i < names.length) {
            classes[i] = ReflectUtil.typeToClass(names[i], classLoader);
            ++i;
        }
        return classes;
    }

    public static Class getReturnType(String descriptor, ClassLoader classLoader) {
        return ReflectUtil.typeToClass(descriptor.substring(descriptor.indexOf(41) + 1), classLoader);
    }

    public static Class[] getParameterTypes(String desc, ClassLoader classLoader) {
        int count = 0;
        int i = 0;
        String descriptor = desc.substring(desc.indexOf(40) + 1, desc.indexOf(41));
        while (i < descriptor.length()) {
            if (descriptor.charAt(i) == '[') {
                ++i;
                continue;
            }
            if (descriptor.charAt(i) == 'L') {
                while (descriptor.charAt(++i) != ';') {
                }
            }
            ++count;
            ++i;
        }
        String[] names = new String[count];
        i = 0;
        while (i < count) {
            names[i] = "";
            ++i;
        }
        int index = 0;
        i = 0;
        while (i < descriptor.length()) {
            if (descriptor.charAt(i) == '[') {
                int n = index;
                names[n] = names[n] + '[';
                ++i;
                continue;
            }
            if (descriptor.charAt(i) == 'L') {
                String s = descriptor.substring(i, descriptor.indexOf(59, i) + 1);
                int n = index;
                names[n] = names[n] + s;
                i += s.length();
            } else {
                int n = index;
                names[n] = names[n] + descriptor.charAt(i);
                ++i;
            }
            ++index;
        }
        return ReflectUtil.namesToClasses(names, classLoader);
    }

    ReflectUtil() {
    }
}

