/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public final class CellRenderer
extends DefaultTableCellRenderer
implements SquirrelTableCellRenderer {
    private final transient IDataTypeComponent _dataTypeObject;

    CellRenderer(IDataTypeComponent dataTypeObject) {
        this._dataTypeObject = dataTypeObject;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (this._dataTypeObject != null && !this._dataTypeObject.isEditableInCell(value) && this._dataTypeObject.isEditableInPopup(value)) {
            this.setBackground(SquirrelConstants.MULTI_LINE_CELL_COLOR);
        } else if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        label.putClientProperty("html.disable", Boolean.TRUE);
        return label;
    }

    @Override
    public void setValue(Object value) {
        if (this._dataTypeObject != null) {
            super.setValue(this._dataTypeObject.renderObject(value));
        } else {
            super.setValue(DefaultColumnRenderer.getInstance().renderObject(value));
        }
    }

    @Override
    public Object renderValue(Object value) {
        if (this._dataTypeObject != null) {
            return this._dataTypeObject.renderObject(value);
        }
        return DefaultColumnRenderer.getInstance().renderObject(value);
    }
}

