/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.shapes.DrawnScribbleGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnShapeHolder;

public class DrawnScribbleHolder
extends DrawnShapeHolder {
    private Rectangle size;
    private Insets insets;
    private int orientation;
    private int shown;
    private boolean backwards;
    private static final float LINE_WIDTH = 3.0f;

    public DrawnScribbleHolder() {
        super(new DrawnScribbleGenerator(3.0f), 3.0f);
    }

    public boolean shapeUpToDate(Component c, Rectangle sz, int orient, int shn, boolean bwrds) {
        Insets in = c instanceof Container ? ((Container)c).getInsets() : NapkinBoxBorder.getDefaultInsets(c.getBounds());
        boolean updated = false;
        if (this.size == null || bwrds != this.backwards || !this.insets.equals(in) || this.orientation != orient || this.shown != shn || this.size.width != sz.width || this.size.height != sz.height) {
            this.size = (Rectangle)sz.clone();
            this.insets = (Insets)in.clone();
            this.orientation = orient;
            this.shown = shn;
            this.backwards = bwrds;
            int cornerX = in.top;
            int cornerY = in.left;
            double innerWidth = sz.getWidth() - (double)(in.left + in.right);
            double innerHeight = sz.getHeight() - (double)(in.top + in.bottom);
            DrawnScribbleGenerator dsg = (DrawnScribbleGenerator)this.gen;
            dsg.setShown(this.shown);
            dsg.setOrientation(this.orientation);
            dsg.setRange(this.orientation == 0 ? innerHeight : innerWidth);
            dsg.setMax(this.orientation == 0 ? innerWidth : innerHeight);
            AffineTransform matrix = new AffineTransform();
            matrix.translate(cornerY, cornerX);
            if (this.backwards) {
                matrix.translate(innerWidth, innerHeight);
                matrix.scale(-1.0, -1.0);
            }
            this.shape = dsg.generate(matrix);
            updated = true;
        }
        return updated;
    }
}

