# $Id: iface.tcl 1441 2008-05-21 10:22:11Z sergei $

set user_status_list [list \
    available	[::msgcat::mc "Available"] \
    chat	[::msgcat::mc "Free to chat"] \
    away	[::msgcat::mc "Away"] \
    xa		[::msgcat::mc "Extended away"] \
    dnd		[::msgcat::mc "Do not disturb"] \
    invisible	[::msgcat::mc "Invisible"] \
    unavailable	[::msgcat::mc "Not logged in"]]

array set ssl_certificate_fields [list \
    subject   [::msgcat::mc "Subject"] \
    issuer    [::msgcat::mc "Issuer"] \
    notBefore [::msgcat::mc "Begin date"] \
    notAfter  [::msgcat::mc "Expiry date"] \
    serial    [::msgcat::mc "Serial number"] \
    cipher    [::msgcat::mc "Cipher"] \
    sbits     [::msgcat::mc "Session key bits"] \
    sha1_hash [::msgcat::mc "SHA1 hash"]]

proc ssl_info {} {
    global ssl_certificate_fields

    if {![llength [set conns [jlib::connections]]]} {
	return {}
    }

    set server_list {}
    set msg_list {}
    foreach connid $conns {
	if {[info exists ::jlib::lib($connid,sck)]} {
	    if {![catch { tls::status $::jlib::lib($connid,sck) } status]} {
		set server [server_from_jid [jlib::connection_jid $connid]]
		if {[lcontain $server_list $server]} {
		    continue
		} else {
		    lappend server_list $server
		    lappend msg_list $server
		}
		set info {}
		foreach {k v} $status {
		    switch -- $k {
			subject - issuer {
			    set v [regsub -all {\s*[/,]\s*(\w+=)} $v \n\t\\1]
			}
		    }
		    if {![cequal $v ""]} {
			if {[info exists ssl_certificate_fields($k)]} {
			    append info \
				   [format "%s: %s\n" \
					   $ssl_certificate_fields($k) $v]
			} else {
			    append info [format "%s: %s\n" $k $v]
			}
		    }
		}
		lappend msg_list [string trim $info]
	    }
	}
    }
    return $msg_list
}

proc update_ssl_info {} {
    global tls_warning_info

    set state disabled
    set len [llength [set conns [jlib::connections]]]
    set fg normal
    if {$len} {
	set balloon ""
	foreach connid $conns {
	    if {$len > 1} {
		append balloon "[jlib::connection_jid $connid]: "
	    }
	    if {[info exists ::jlib::lib($connid,sck)]} {
		if {![catch { tls::status $::jlib::lib($connid,sck) } status]} {
		    if {![info exists tls_warning_info($connid)] ||
			    [cequal $tls_warning_info($connid) ""]} {
			append balloon [::msgcat::mc "Enabled\n"]
		    } else {
			append balloon $tls_warning_info($connid)
			set fg warning
		    }
		    set state normal
		} else {
		    append balloon [::msgcat::mc "Disabled\n"]
		}
	    } else {
		append balloon [::msgcat::mc "Disconnected"] "\n"
	    }
	}
    } else {
	set balloon [::msgcat::mc "Disconnected"]
    }
    return [list $state $fg [string trim $balloon]]
}

###############################################################################

set status_afterid ""

proc client:status {text} {
    set_status $text
}

proc set_status {text} {
    global status
    global status_afterid

    after cancel $status_afterid
    set status $text

    hook::run set_status_hook $text
    
    set status_afterid [after 5000 clear_status]
}

proc clear_status {} {
    global status

    set status ""
    
    hook::run clear_status_hook
}

# vim:ts=8:sw=4:sts=4:noet
