/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Functions, data structures, and global variables used by the ubs-sched daemon.
****/

#include "ubs.h"

// Playlist types
#define LIST_RANDOM 0
#define LIST_M3U 1
#define LIST_ITUNES 2

// Data Structures 

/*+ Days of the week +*/
typedef enum
{ sun, mon, tues, wed, thurs, fri, sat }
wday;
/*+ Used for how often a show should repeat +*/
typedef enum
{ once, weekly, daily }
freq;

/*+ This structure holds all of the information about an individual show, which is used in the allshows array. +*/
struct show
{
 int show_id; /*+ The ID of the show, which is how the UBS internally references the shows.  This value is 0 indexed, and thus, should also reflect the show's position in the allshows array +*/
 char show_name[STRBUF]; /*+ The name of the show.  Used for display purposes only +*/
 char dir[FILEBUF]; /*+ The directory that the show should read out of.  This is recursive, so it will also include any music in a subdirectories found +*/
 int start; /*+ What time the show starts, from 0-47 (the number of half hours in a 24 hour period +*/
 int end; /*+ The time the show ends, from 0-47 alsa +*/
 int type; /*+ Type of playlist to read from +*/
 freq repeat; /*+ How often the show should repeat.  See the enumerated type for this. +*/
 union occur /*+ When the show should occur, should it not occur every day. +*/
 {
  char day[SMALLBUF];
  wday weekday;
 }
 when;
 char banner[FILEBUF]; /*+ Special file to play at the start of every show, if defined +*/
};

// Global Variables 

int WEEK[7][48]; /*+ An array that holds all of the half-hour slots for an entire week, which is the period of time that the ubs runs off of.  This array contains integers which correspond to show ID's +*/
struct show *ALLSHOWS; /*+ All the known shows +*/

ubs_table SCHED;

// Functions 

// read_config.c
int read_sched(char *config_fname);

// schedule.c
int add_show(int show_num, int day, int timeslot);
int init_week(void);
int find_show(int wday, int timeslot);
int dump_sched(int format);

// enqueue.c
int enqueue(int cur_show);
int parse_m3u_playlist(char *playlist);
int parse_itunes_playlist(char *playlist);
