/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.converter;

import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssVisitor;
import java.util.HashSet;
import java.util.List;

public class AlternateAnnotationCreatorVisitor
extends CssVisitor {
    @Override
    public boolean visit(CssRule x, Context ctx) {
        this.annotateDuplicateProperties(x.getProperties());
        return false;
    }

    @Override
    public boolean visit(CssSprite x, Context ctx) {
        this.annotateDuplicateProperties(x.getProperties());
        return false;
    }

    private void annotateDuplicateProperties(List<CssProperty> properties) {
        HashSet<String> duplicatePropertyNames = new HashSet<String>();
        HashSet<String> seenPropertyNames = new HashSet<String>();
        for (CssProperty cssProperty : properties) {
            String name = cssProperty.getName();
            if (!seenPropertyNames.contains(name)) {
                seenPropertyNames.add(name);
                continue;
            }
            duplicatePropertyNames.add(name);
        }
        HashSet<String> seenDuplicatePropertyNames = new HashSet<String>();
        for (CssProperty cssProperty : properties) {
            String name = cssProperty.getName();
            if (!duplicatePropertyNames.contains(name)) continue;
            if (!seenDuplicatePropertyNames.contains(name)) {
                seenDuplicatePropertyNames.add(name);
                continue;
            }
            cssProperty.setName("/* @alternate */ " + name);
        }
    }
}

