/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts.compound;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import org.campagnelab.goby.counts.compound.CompoundFileWriter;

public class CompoundDataOutput
implements Closeable,
DataOutput {
    private RandomAccessFile dataOutput;
    private CompoundFileWriter compoundFileWriter;

    CompoundDataOutput(RandomAccessFile stream, CompoundFileWriter writer) {
        this.dataOutput = stream;
        this.compoundFileWriter = writer;
    }

    @Override
    public void write(int b) throws IOException {
        this.dataOutput.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataOutput.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataOutput.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataOutput.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataOutput.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dataOutput.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dataOutput.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dataOutput.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dataOutput.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataOutput.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataOutput.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataOutput.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.dataOutput.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.dataOutput.writeUTF(s);
    }

    public void writeObject(Object objToWrite) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(objToWrite);
        out.close();
        byte[] buf = bos.toByteArray();
        this.dataOutput.writeInt(buf.length);
        this.dataOutput.write(buf);
    }

    @Override
    public void close() throws IOException {
        this.compoundFileWriter.finishAddFile();
        this.dataOutput = null;
        this.compoundFileWriter = null;
    }
}

