/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.utils.ValidationUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class HuffmanParams<T> {
    private final List<T> symbols;
    private final List<Integer> codeWordLengths;

    public HuffmanParams(List<T> symbols, List<Integer> codeWordLengths) {
        ValidationUtils.nonNull(symbols, "requires non-null symbols");
        ValidationUtils.nonNull(Boolean.valueOf(symbols.size() > 0), "requires symbols");
        ValidationUtils.nonNull(codeWordLengths, "requires non-null codeWordLengths");
        ValidationUtils.nonNull(codeWordLengths, "requires codeWordLengths");
        ValidationUtils.nonNull(Boolean.valueOf(symbols.size() == codeWordLengths.size()), "symbols and codeWordLengths out of sync");
        this.symbols = Collections.unmodifiableList(symbols);
        this.codeWordLengths = Collections.unmodifiableList(codeWordLengths);
    }

    public List<T> getSymbols() {
        return this.symbols;
    }

    public List<Integer> getCodeWordLengths() {
        return this.codeWordLengths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HuffmanParams that = (HuffmanParams)o;
        if (!this.getSymbols().equals(that.getSymbols())) {
            return false;
        }
        return this.getCodeWordLengths().equals(that.getCodeWordLengths());
    }

    public int hashCode() {
        int result = this.getSymbols().hashCode();
        result = 31 * result + this.getCodeWordLengths().hashCode();
        return result;
    }

    public String toString() {
        return String.format("Symbols: %s BitLengths %s", this.symbols.stream().map(Object::toString).collect(Collectors.joining(";")), this.codeWordLengths.stream().map(Object::toString).collect(Collectors.joining(";")));
    }
}

