require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SPARC_PTE_H_)) {
    eval 'sub _SPARC_PTE_H_ () {1;}' unless defined(&_SPARC_PTE_H_);
    if(defined(&_KERNEL_OPT)) {
	require './sparc/opt_sparc_arch.ph';
    }
    unless(defined(&_LOCORE)) {
    }
    if(defined(&SUN4_MMU3L)  && !defined(&SUN4)) {
	die("configuration error");
    }
    eval 'sub NBPRG () {(1<< 24);}' unless defined(&NBPRG);
    eval 'sub RGSHIFT () {24;}' unless defined(&RGSHIFT);
    eval 'sub RGOFSET () {( &NBPRG - 1);}' unless defined(&RGOFSET);
    eval 'sub NSEGRG () {( &NBPRG /  &NBPSG);}' unless defined(&NSEGRG);
    eval 'sub NBPSG () {(1<< 18);}' unless defined(&NBPSG);
    eval 'sub SGSHIFT () {18;}' unless defined(&SGSHIFT);
    eval 'sub SGOFSET () {( &NBPSG - 1);}' unless defined(&SGOFSET);
    if(defined(&SUN4)  && (defined(&SUN4C) || defined(&SUN4M) || defined(&SUN4D))) {
	eval 'sub NPTESG () { &nptesg;}' unless defined(&NPTESG);
    } else {
	eval 'sub NPTESG () {( &NBPSG /  &NBPG);}' unless defined(&NPTESG);
    }
    eval 'sub VA_VREG {
        my($va) = @_;
	    eval q(((($va) >>  &RGSHIFT) & 255));
    }' unless defined(&VA_VREG);
    eval 'sub VA_VSEG {
        my($va) = @_;
	    eval q(((($va) >>  &SGSHIFT) & 63));
    }' unless defined(&VA_VSEG);
    eval 'sub VA_SUN4_VPG {
        my($va) = @_;
	    eval q(((($va) >> 13) & 31));
    }' unless defined(&VA_SUN4_VPG);
    eval 'sub VA_SUN4C_VPG {
        my($va) = @_;
	    eval q(((($va) >> 12) & 63));
    }' unless defined(&VA_SUN4C_VPG);
    eval 'sub VA_SUN4M_VPG {
        my($va) = @_;
	    eval q(((($va) >> 12) & 63));
    }' unless defined(&VA_SUN4M_VPG);
    eval 'sub VA_VPG {
        my($va) = @_;
	    eval q(( &PGSHIFT== &SUN4_PGSHIFT ?  &VA_SUN4_VPG($va) :  &VA_SUN4C_VPG($va)));
    }' unless defined(&VA_VPG);
    eval 'sub VA_SUN4_OFF {
        my($va) = @_;
	    eval q(((($va)) & 0x1fff));
    }' unless defined(&VA_SUN4_OFF);
    eval 'sub VA_SUN4C_OFF {
        my($va) = @_;
	    eval q(((($va)) & 0xfff));
    }' unless defined(&VA_SUN4C_OFF);
    eval 'sub VA_SUN4M_OFF {
        my($va) = @_;
	    eval q(((($va)) & 0xfff));
    }' unless defined(&VA_SUN4M_OFF);
    eval 'sub VA_OFF {
        my($va) = @_;
	    eval q(( &PGSHIFT== &SUN4_PGSHIFT ?  &VA_SUN4_OFF($va) :  &VA_SUN4C_OFF($va)));
    }' unless defined(&VA_OFF);
    eval 'sub VA_ROUNDDOWNTOREG {
        my($va) = @_;
	    eval q((($va) & ~ &RGOFSET));
    }' unless defined(&VA_ROUNDDOWNTOREG);
    eval 'sub VA_ROUNDDOWNTOSEG {
        my($va) = @_;
	    eval q((($va) & ~ &SGOFSET));
    }' unless defined(&VA_ROUNDDOWNTOSEG);
    eval 'sub VRTOVA {
        my($vr) = @_;
	    eval q((( &CPU_HAS_SRMMU ||  &HASSUN4_MMU3L) ? ( <<  &RGSHIFT) : ((($vr) << ( &RGSHIFT+2)) >> 2)));
    }' unless defined(&VRTOVA);
    eval 'sub VSTOVA {
        my($vr,$vs) = @_;
	    eval q((( &CPU_HAS_SRMMU ||  &HASSUN4_MMU3L) ? (( <<  &RGSHIFT) + ( <<  &SGSHIFT)) : ((( << ( &RGSHIFT+2)) >> 2) + (($vs) <<  &SGSHIFT))));
    }' unless defined(&VSTOVA);
    eval 'sub VA_INHOLE {
        my($va) = @_;
	    eval q(( &mmu_has_hole ? ( ((($va) >>  &PG_VSHIFT) + 1) > 1) : 0));
    }' unless defined(&VA_INHOLE);
    eval 'sub MMU_HOLE_START () {0x20000000;}' unless defined(&MMU_HOLE_START);
    eval 'sub MMU_HOLE_END () {0xe0000000;}' unless defined(&MMU_HOLE_END);
    eval 'sub PG_V () {0x80000000;}' unless defined(&PG_V);
    eval 'sub PG_PROT () {0x60000000;}' unless defined(&PG_PROT);
    eval 'sub PG_W () {0x40000000;}' unless defined(&PG_W);
    eval 'sub PG_S () {0x20000000;}' unless defined(&PG_S);
    eval 'sub PG_NC () {0x10000000;}' unless defined(&PG_NC);
    eval 'sub PG_TYPE () {0xc000000;}' unless defined(&PG_TYPE);
    eval 'sub PG_OBMEM () {0x;}' unless defined(&PG_OBMEM);
    eval 'sub PG_OBIO () {0x4000000;}' unless defined(&PG_OBIO);
    eval 'sub PG_VME16 () {0x8000000;}' unless defined(&PG_VME16);
    eval 'sub PG_VME32 () {0xc000000;}' unless defined(&PG_VME32);
    if(defined(&SUN4M) || defined(&SUN4D)) {
	eval 'sub PG_SUN4M_OBMEM () {0x;}' unless defined(&PG_SUN4M_OBMEM);
	eval 'sub PG_SUN4M_OBIO () {0xf;}' unless defined(&PG_SUN4M_OBIO);
	eval 'sub SRMMU_PGTYPE () {0xf0000000;}' unless defined(&SRMMU_PGTYPE);
    }
    eval 'sub PG_U () {0x2000000;}' unless defined(&PG_U);
    eval 'sub PG_M () {0x1000000;}' unless defined(&PG_M);
    eval 'sub PG_MBZ () {0x780000;}' unless defined(&PG_MBZ);
    eval 'sub PG_IOC () {0x800000;}' unless defined(&PG_IOC);
    eval 'sub PG_WIRED () {0x400000;}' unless defined(&PG_WIRED);
    eval 'sub PG_PFNUM () {0x7ffff;}' unless defined(&PG_PFNUM);
    eval 'sub PG_TNC_SHIFT () {26;}' unless defined(&PG_TNC_SHIFT);
    eval 'sub PG_M_SHIFT () {24;}' unless defined(&PG_M_SHIFT);
    eval 'sub PG_M_SHIFT4M () {5;}' unless defined(&PG_M_SHIFT4M);
    eval 'sub PG_KR () {0x20000000;}' unless defined(&PG_KR);
    eval 'sub PG_KW () {0x60000000;}' unless defined(&PG_KW);
    eval 'sub PG_URKR () {0;}' unless defined(&PG_URKR);
    eval 'sub PG_UW () {0x40000000;}' unless defined(&PG_UW);
    if(defined(&KGDB)) {
	if(defined(&SUN4M) || defined(&SUN4D)) {
	}
    }
    eval 'sub PG_VSHIFT () {29;}' unless defined(&PG_VSHIFT);
    eval 'sub PG_PROTSHIFT () {29;}' unless defined(&PG_PROTSHIFT);
    eval 'sub PG_PROTUWRITE () {6;}' unless defined(&PG_PROTUWRITE);
    eval 'sub PG_PROTUREAD () {4;}' unless defined(&PG_PROTUREAD);
    eval 'sub SRMMU_TEINVALID () {0x;}' unless defined(&SRMMU_TEINVALID);
    eval 'sub SRMMU_TEPTD () {0x1;}' unless defined(&SRMMU_TEPTD);
    eval 'sub SRMMU_TEPTE () {0x2;}' unless defined(&SRMMU_TEPTE);
    eval 'sub SRMMU_TEPTERBO () {0x3;}' unless defined(&SRMMU_TEPTERBO);
    eval 'sub SRMMU_TETYPE () {0x3;}' unless defined(&SRMMU_TETYPE);
    eval 'sub SRMMU_PPNMASK () {0xffffff00;}' unless defined(&SRMMU_PPNMASK);
    eval 'sub SRMMU_PPNSHIFT () {0x8;}' unless defined(&SRMMU_PPNSHIFT);
    eval 'sub SRMMU_PPNPASHIFT () {0x4;}' unless defined(&SRMMU_PPNPASHIFT);
    eval 'sub SRMMU_L1PPNSHFT () {0x14;}' unless defined(&SRMMU_L1PPNSHFT);
    eval 'sub SRMMU_L1PPNMASK () {0xfff00000;}' unless defined(&SRMMU_L1PPNMASK);
    eval 'sub SRMMU_L2PPNSHFT () {0xe;}' unless defined(&SRMMU_L2PPNSHFT);
    eval 'sub SRMMU_L2PPNMASK () {0xfc000;}' unless defined(&SRMMU_L2PPNMASK);
    eval 'sub SRMMU_L3PPNSHFT () {0x8;}' unless defined(&SRMMU_L3PPNSHFT);
    eval 'sub SRMMU_L3PPNMASK () {0x3f00;}' unless defined(&SRMMU_L3PPNMASK);
    eval 'sub SRMMU_PG_C () {0x80;}' unless defined(&SRMMU_PG_C);
    eval 'sub SRMMU_PG_M () {0x40;}' unless defined(&SRMMU_PG_M);
    eval 'sub SRMMU_PG_R () {0x20;}' unless defined(&SRMMU_PG_R);
    eval 'sub SRMMU_PGBITSMSK () {0xe0;}' unless defined(&SRMMU_PGBITSMSK);
    eval 'sub SRMMU_PROT_MASK () {0x1c;}' unless defined(&SRMMU_PROT_MASK);
    eval 'sub SRMMU_PROT_SHFT () {0x2;}' unless defined(&SRMMU_PROT_SHFT);
    eval 'sub PPROT_R_R () {0x;}' unless defined(&PPROT_R_R);
    eval 'sub PPROT_RW_RW () {0x4;}' unless defined(&PPROT_RW_RW);
    eval 'sub PPROT_RX_RX () {0x8;}' unless defined(&PPROT_RX_RX);
    eval 'sub PPROT_RWX_RWX () {0xc;}' unless defined(&PPROT_RWX_RWX);
    eval 'sub PPROT_X_X () {0x10;}' unless defined(&PPROT_X_X);
    eval 'sub PPROT_R_RW () {0x14;}' unless defined(&PPROT_R_RW);
    eval 'sub PPROT_N_RX () {0x18;}' unless defined(&PPROT_N_RX);
    eval 'sub PPROT_N_RWX () {0x1c;}' unless defined(&PPROT_N_RWX);
    eval 'sub PPROT_WRITE () {0x4;}' unless defined(&PPROT_WRITE);
    eval 'sub PPROT_S () {0x18;}' unless defined(&PPROT_S);
    eval 'sub PPROT_U2S_OMASK () {0x18;}' unless defined(&PPROT_U2S_OMASK);
    eval 'sub SRMMU_L1SIZE () {0x100;}' unless defined(&SRMMU_L1SIZE);
    eval 'sub SRMMU_L2SIZE () {0x40;}' unless defined(&SRMMU_L2SIZE);
    eval 'sub SRMMU_L3SIZE () {0x40;}' unless defined(&SRMMU_L3SIZE);
    eval 'sub SRMMU_PTE_BITS () {"\\177\\020" "f\\0\\2TYPE\\0=\\1PTD\\0=\\2PTE\\0f\\2\\3PROT\\0" "=\\0R_R\\0=\\4RW_RW\\0=\\10RX_RX\\0=\\14RWX_RWX\\0=\\20X_X\\0=\\24R_RW\\0" "=\\30N_RX\\0=\\34N_RWX\\0" "b\\5R\\0b\\6M\\0b\\7C\\0f\\10\\30PFN\\0";}' unless defined(&SRMMU_PTE_BITS);
    eval 'sub IOPTE_PPN_MASK () {0x7ffff00;}' unless defined(&IOPTE_PPN_MASK);
    eval 'sub IOPTE_PPN_SHIFT () {8;}' unless defined(&IOPTE_PPN_SHIFT);
    eval 'sub IOPTE_RSVD () {0xf1;}' unless defined(&IOPTE_RSVD);
    eval 'sub IOPTE_WRITE () {0x4;}' unless defined(&IOPTE_WRITE);
    eval 'sub IOPTE_VALID () {0x2;}' unless defined(&IOPTE_VALID);
    eval 'sub IOMMU_PTE_BITS () {"\\177\\020" "f\\10\\23PPN\\0b\\2W\\0b\\1V\\0";}' unless defined(&IOMMU_PTE_BITS);
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	eval 'sub getcontext4 () {
	    eval q( &lduba( &AC_CONTEXT,  &ASI_CONTROL));
	}' unless defined(&getcontext4);
	eval 'sub getcontext4m () {
	    eval q( &lda( &SRMMU_CXR,  &ASI_SRMMU));
	}' unless defined(&getcontext4m);
	eval 'sub getcontext () {
	    eval q(( &CPU_HAS_SRMMU ?  &getcontext4m() :  &getcontext4()));
	}' unless defined(&getcontext);
	eval 'sub setcontext4 {
	    my($c) = @_;
    	    eval q( &stba( &AC_CONTEXT,  &ASI_CONTROL, $c));
	}' unless defined(&setcontext4);
	eval 'sub setcontext4m {
	    my($c) = @_;
    	    eval q( &sta( &SRMMU_CXR,  &ASI_SRMMU, $c));
	}' unless defined(&setcontext4m);
	eval 'sub setcontext {
	    my($c) = @_;
    	    eval q(( &CPU_HAS_SRMMU ?  &setcontext4m($c) :  &setcontext4($c)));
	}' unless defined(&setcontext);
	eval 'sub getpte4 {
	    my($va) = @_;
    	    eval q( &lda($va,  &ASI_PTE));
	}' unless defined(&getpte4);
	eval 'sub setpte4 {
	    my($va, $pte) = @_;
    	    eval q( &sta($va,  &ASI_PTE, $pte));
	}' unless defined(&setpte4);
	eval 'sub getpte4m {
	    my($va) = @_;
    	    eval q( &lda(($va & 0xfffff000) |  &ASI_SRMMUFP_L3,  &ASI_SRMMUFP));
	}' unless defined(&getpte4m);
    }
}
1;
