require '_h2ph_pre.ph';

no warnings qw(redefine misc);

require 'sparc/asm.ph';
if(defined(&_LP64)) {
    eval 'sub BASEREG () {% &g4;}' unless defined(&BASEREG);
    eval 'sub LNGSZ () {8;}' unless defined(&LNGSZ);
    eval 'sub LNGSHFT () {3;}' unless defined(&LNGSHFT);
    eval 'sub PTRSZ () {8;}' unless defined(&PTRSZ);
    eval 'sub PTRSHFT () {3;}' unless defined(&PTRSHFT);
    eval 'sub POINTER () {. &xword;}' unless defined(&POINTER);
    eval 'sub ULONG () {. &xword;}' unless defined(&ULONG);
    eval 'sub LDLNG () { &ldx;}' unless defined(&LDLNG);
    eval 'sub LDULNG () { &ldx;}' unless defined(&LDULNG);
    eval 'sub STLNG () { &stx;}' unless defined(&STLNG);
    eval 'sub STULNG () { &stx;}' unless defined(&STULNG);
    eval 'sub LDPTR () { &ldx;}' unless defined(&LDPTR);
    eval 'sub LDPTRA () { &ldxa;}' unless defined(&LDPTRA);
    eval 'sub STPTR () { &stx;}' unless defined(&STPTR);
    eval 'sub STPTRA () { &stxa;}' unless defined(&STPTRA);
    eval 'sub CASPTR () { &casx;}' unless defined(&CASPTR);
    eval 'sub CASPTRA () { &casxa;}' unless defined(&CASPTRA);
    eval 'sub STKB () { &BIAS;}' unless defined(&STKB);
    eval 'sub CCCR () {% &xcc;}' unless defined(&CCCR);
} else {
    eval 'sub BASEREG () {% &g0;}' unless defined(&BASEREG);
    eval 'sub LNGSZ () {4;}' unless defined(&LNGSZ);
    eval 'sub LNGSHFT () {2;}' unless defined(&LNGSHFT);
    eval 'sub PTRSZ () {4;}' unless defined(&PTRSZ);
    eval 'sub PTRSHFT () {2;}' unless defined(&PTRSHFT);
    eval 'sub POINTER () {. &word;}' unless defined(&POINTER);
    eval 'sub ULONG () {. &word;}' unless defined(&ULONG);
    eval 'sub LDLNG () { &ldsw;}' unless defined(&LDLNG);
    eval 'sub LDULNG () { &lduw;}' unless defined(&LDULNG);
    eval 'sub STLNG () { &stw;}' unless defined(&STLNG);
    eval 'sub STULNG () { &stw;}' unless defined(&STULNG);
    eval 'sub LDPTR () { &lduw;}' unless defined(&LDPTR);
    eval 'sub LDPTRA () { &lduwa;}' unless defined(&LDPTRA);
    eval 'sub STPTR () { &stw;}' unless defined(&STPTR);
    eval 'sub STPTRA () { &stwa;}' unless defined(&STPTRA);
    eval 'sub CASPTR () { &cas;}' unless defined(&CASPTR);
    eval 'sub CASPTRA () { &casa;}' unless defined(&CASPTRA);
    eval 'sub STKB () {0;}' unless defined(&STKB);
    eval 'sub CCCR () {% &icc;}' unless defined(&CCCR);
}
if(defined(&_KERNEL) || defined(&_RUMPKERNEL)) {
    eval 'sub NOTREACHED () { &sir;}' unless defined(&NOTREACHED);
} else {
    eval 'sub NOTREACHED () {1;}' unless defined(&NOTREACHED);
}
eval 'sub BCOPY_SMALL () {32;}' unless defined(&BCOPY_SMALL);
eval 'sub _ALIGN () {. &align 8;}' unless defined(&_ALIGN);
eval 'sub ICACHE_ALIGN () {. &align 32;}' unless defined(&ICACHE_ALIGN);
eval 'sub COMBINE {
    my($r1, $r2, $d) = @_;
	eval q( &clruw $r2;  &sllx $r1, 32, $d;  &or $d, $r2, $d);
}' unless defined(&COMBINE);
eval 'sub SPLIT {
    my($s, $r0, $r1) = @_;
	eval q( &srl $s, 0, $r1;  &srlx $s, 32, $r0);
}' unless defined(&SPLIT);
eval 'sub SPLIT_RETL {
    my($s, $r0, $r1) = @_;
	eval q( &srl $s, 0, $r1;  &retl;  &srlx $s, 32, $r0);
}' unless defined(&SPLIT_RETL);
1;
