/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import net.infonode.gui.ComponentUtil;
import net.infonode.util.ColorUtil;

public abstract class AbstractButtonIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = 1L;
    private int size = 10;
    private Color defaultColor = null;
    private boolean shadowEnabled = true;
    private float shadowStrength = 0.3f;
    private boolean enabled = true;

    public AbstractButtonIcon() {
    }

    public AbstractButtonIcon(Color color) {
        this.defaultColor = color;
    }

    public AbstractButtonIcon(Color color, int n) {
        this(color);
        this.size = n;
    }

    public AbstractButtonIcon(int n) {
        this(n, true);
    }

    public AbstractButtonIcon(int n, boolean bl) {
        this();
        this.size = n;
        this.enabled = bl;
    }

    public int getIconWidth() {
        return this.size;
    }

    public int getIconHeight() {
        return this.size;
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public void setShadowEnabled(boolean bl) {
        this.shadowEnabled = bl;
    }

    public float getShadowStrength() {
        return this.shadowStrength;
    }

    public void setShadowStrength(float f) {
        this.shadowStrength = f;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color;
        Color color2 = graphics.getColor();
        Color color3 = this.defaultColor == null ? (this.enabled ? component.getForeground() : UIManager.getColor("Button.disabledForeground")) : (color = this.defaultColor);
        if (color == null) {
            color = ColorUtil.blend(ComponentUtil.getBackgroundColor(component), component.getForeground(), 0.5);
        }
        if (this.shadowEnabled) {
            Color color4 = ComponentUtil.getBackgroundColor(component);
            graphics.setColor(ColorUtil.blend(color4 == null ? Color.BLACK : color4, Color.BLACK, this.shadowStrength));
            this.paintIcon(component, graphics, n + 2, n2 + 2, n + this.size - 1, n2 + this.size - 1, true);
            graphics.setColor(color);
            this.paintIcon(component, graphics, n + 1, n2 + 1, n + this.size - 2, n2 + this.size - 2, false);
        } else {
            graphics.setColor(color);
            this.paintIcon(component, graphics, n, n2, n + this.size - 1, n2 + this.size - 1, false);
        }
        graphics.setColor(color2);
    }

    protected void paintIcon(Component component, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        this.paintIcon(component, graphics, n, n2, n3, n4);
    }

    protected void paintIcon(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }
}

