package TDS::Tdf::Command::Classes;
# $Id: Classes.pm,v 1.40.4.1 2001/02/28 17:35:18 tom Exp $
################################################################

##BEGIN { warn times, " Classes Start"; }

use TDS::Tdf::Command::DIARY;

# dummy class

package TDS::Tdf::Command::Tdf;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $MustHaveContent);

#@ISA = qw(TDS::Tdf::Command::Element);
@ISA = qw(TDS::Tdf::Command);
$MustHaveContent = 0;
$OmittableEnd = 1;
$EndTemplate = "%footnote" unless defined $EndTemplate;
#@AllowCommands = ('DIARY', @{$TDS::Tdf::Command::Entities{'Block'}});
@AllowCommands = (%Block);

sub SetParams($$)
{
    my ($self, $params) = @_;
    # 
    if ($self->{footnotes}){
	$self->SetFootnotes($params);
    }
}

sub AsHTML ($$$)
{
    my ($self, $params) = @_;

    my $html = $self->SUPER::AsHTML($params);
    my $bottom_html;
    for (reverse 1..6){
	if ($params->{"hd_$_"}){
	    $bottom_html .= Template::Expand($TDS::Tdf::Command::HD::BottomTemplate, {'1'=>$_});
	}
    }
    return "$html$bottom_html";
}
################################################################
# Special command
package TDS::Tdf::Command::TITLE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command);
$OmittableEnd = 1;
$IsOneline = 1;
$HasArgContent = 1;

sub AsHTML($$)
{
    my ($self, $params) = @_;

#    $params->{title} = $self->arg_content;
    $params->{title} = $self->SUPER::AsHTML($params);
#    print "in com title:$params->{title}\n";
    return undef;
}

package TDS::Tdf::Command::HD;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent
	    $TopTemplate $BottomTemplate);

@ISA = qw(TDS::Tdf::Command::_Block);
$OmittableEnd = 1;
$IsOneline = 1;
$NumAttr = 1;
$Template = qq(<h%1><span class="heading-number"><a name="%hd_counter">%hd_counter</a></span>) unless defined $Template;
$EndTemplate = qq(</h%1>\n) unless defined $EndTemplate;
$TopTemplate = qq(<div class="hd-%1">\n) unless defined $TopTemplate;
#$TopTemplate = qq(<div class="hd-%1">TOP[%1]);
$BottomTemplate = qq(</div>\n) unless defined $BottomTemplate;
#$BottomTemplate = qq(BOTTOM[%1]</div>);
$HasArgContent = 1;
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Inline'}});
@AllowCommands = ('%Inline');

sub AsHTML($$)
{
    my ($self, $params) = @_;
    my $num = $self->{attr}->[1];

    my $inc;
    my $dec;
    unless ($params->{"hd_$num"}){    # deeper
	$inc++;
    }
	
    my $bottom_html;
    for (reverse $num..6){
	if ($params->{"hd_$_"} >= 1){
	    $bottom_html .= Template::Expand($BottomTemplate, {'1'=>$_});
	    $dec++;
	}

    }
    $params->{"hd_$num"}++;           # inc
    # reset
    my $i;
    for ($i = $num+1; $i<=6; $i++){
	$params->{"hd_$i"} = 0;
    }
    # format
    my $format; # = qq(<span class="heading-number">);
    my @parameters;
    for ($i=1; $i<=$num; $i++){
	if ($params->{"hd_$i"}){
	    $format .= "%d.";
	    push(@parameters, $params->{"hd_$i"});
	}
    }
#    $format .= " </span>";
    $params->{hd_counter} = sprintf($format, @parameters);

    require TableOfContents;
    $params->{_toc} = new TableOfContents
	unless ref $params->{_toc};
    
    $params->{_toc}->Add({counter=>$params->{hd_counter},
			  inc=>$inc,
			  dec=>$dec-1,
			  level=>$num,
			  content=>join('', @{$self->{content}})});
    
#    $params->{_toc} = $toc;
#    push(@{$params->{_toc}}, $toc);
#	 sprintf(qq(%s <a href="\#%s">%s</a>\n),
#		 $params->{hd_counter},
#		 $params->{hd_counter},		 
#		 join('', @{$self->{content}})));

    my $html = $self->SUPER::AsHTML($params);
    my $top_html = Template::Expand($TopTemplate, {'1'=>$num});
    return "$bottom_html$html$top_html";
}

package TDS::Tdf::Command::INCLUDE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd);

use JConv;

use TDS::DirInfo;

@ISA = qw(TDS::Tdf::Command);
$OmittableEnd = 1;
$IsOneline = 1;
$NumAttr = 1;

sub AsHTML($$)
{
    my ($self, $params) = @_;

    my $filename = $self->{attr}->[1];
    if ($filename =~ m!^:/(.*)$!){
	$filename = GetDiaryDir()  . "/$1";
    }
    open(F, $filename) ||
	return qq(<strong>Warning: INCLUDE $filename not found</strong>);
    if ($filename =~ /\.tdf$/){    # .tdf λΤ parse
	my $parser = new TDS::Tdf::Parser;
	while (<F>){
	    jconv(\$_, $TDS::System::InternalJcode);
	    if (/^INCLUDE /){ # ƵŪ󥯥롼ɤǧʤ
		$parser->text("<strong>recursive INCLUDE is not allowed: $_</strong>");
	    } else {
		$parser->Parse($_);
	    }
	}
	close F;
#	$params->{in_include} = 1;
	my $html =  $parser->top->AsHTML($params);
#	$params->{in_include} = 0;
	return $html;
    } else {
	my $html;
	while (<F>){
	    jconv(*_, $TDS::System::InternalJcode);
	    $html .= $_;
	}
	close F;
	return $html;
    }
}
################################################################
# Dictionary
package TDS::Tdf::Command::WORD;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);
use CGI::Tools;

@ISA = qw(TDS::Tdf::Command::_Block);
$Template = qq(<h3><a href="#%encoded_term" name="%encoded_term">%term</a>%pronounce</h3><div style="margin-left: 2em">\n) unless defined $Template;
$EndTemplate = qq(</div>\n) unless defined $EndTemplate;
$OmittableEnd = 1;
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}},
@AllowCommands = ('%Flow',
		  'PRONOUNCE', 'ANCHORNAME');

sub SetParams($$)
{
    my ($self, $params) = @_;

    $params->{term} = $self->{ext_attrs};
    $params->{encoded_term} = UrlEncode($self->{anchor_name}) ||
	UrlEncode($self->{ext_attrs});
    $self->{pronounce} ||= $params->{term};
    $self->SUPER::SetParams($params);
}

package TDS::Tdf::Command::PRONOUNCE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command);
$Template = " [" unless defined $Template;
$EndTemplate = "]" unless defined $EndTemplate;
$IsOneline = 1;
$HasArgContent = 1;
$NumAttr = 0;

sub AsHTML($$)
{
    my ($self, $params) = @_;

#    print "pro: ", $self->{attr}->[1], "<br>";
    $self->{parent}->{pronounce} = join('', @{$self->{content}});
    $params->{pronounce} = $self->SUPER::AsHTML($params);
#    print $self->{parent}->{pronounce};
    return undef;
}

package TDS::Tdf::Command::ANCHORNAME;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command);
$Template = "" unless defined $Template;
$EndTemplate = "" unless defined $EndTemplate;
$IsOneline = 1;
$HasArgContent = 1;
$NumAttr = 0;


sub AsHTML($$)
{
    my ($self, $params) = @_;

    $self->{parent}->{anchor_name} = $self->SUPER::AsHTML($params);
    return undef;
}
################################################################
# body commands:
# (*) if you want to add new command, you must account it in
#     $TDS::Tdf::[A-Z][a-z]+::entity

# static variable:
# $Template            [str]  begin template
# $EndTemplate        [str]  end templte
# $NumAttr              [int]  number of attributes
# $IsOneline             [bool] no need end command
# @AllowCommands      [array]commands which can be element of self class
# $CountName          [str] if countable, set name for use of counter variable
# $OmittableEnd            [bool] ]is end-command omittable

################################################################
package TDS::Tdf::Command::TIMEDIV;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $MustHaveContent $Mark
	    $TitleTemplate $TitleEndTemplate
	    $HrefTemplateStatic $HrefTemplateDynamic $Anchor);

@ISA = qw(TDS::Tdf::Command);
$Template = qq(<h3><a href="%href" name="%anchor">%mark</a>%ext_attrs</h3>\n) unless defined $Template;
$EndTemplate = qq() unless defined $EndTemplate;
$TitleTemplate = qq(<dl><dt>%ext_attrs<dd>) unless defined $TitleTemplate;
$TitleEndTemplate = qq(</dl>) unless defined $TitleEndTemplate;
$HrefTemplateDynamic = qq(./?%y%0m%0d\#%anchor) unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = qq(d%year%0m%part.%suffix\#%anchor) unless defined $HrefTemplateStatic;
$Anchor = "%day-T%timediv" unless defined $Anchor;
$CountName = "timediv";
$OmittableEnd = 1;
$MustHaveContent = 1;
@AllowCommands = ('%New');
$Mark = "";

sub SetParams($$)
{
    my ($self, $params) = @_;

    $params->{mark} = $Mark;
}
sub IncrementCounter($$)
{
    my ($self, $params) = @_;
    
    $params->{timediv}++;
}

package TDS::Tdf::Command::CAT;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd);
#use vars qw(%DB);

$Template = "[%ext_attrs]" unless defined $Template;
@ISA = qw(TDS::Tdf::Command);

$IsOneline = 1;
$NumAttr = 0;

sub AsHTML($$)
{
    my ($self, $params) = @_;

    $self->{parent}->{cat} .= $self->SUPER::AsHTML($params);
#    print "CAT:", $self->{parent}, "<br>";
    return undef;
}

################################################################
# New Entities
package TDS::Tdf::Command::_New;;
use CGI::QueryString;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $TitleTemplate $TitleEndTemplate
	    $Type  $CountName $OmittableEnd $MustHaveContent
	    $ResetFootnoteCounter);


@ISA = qw(TDS::Tdf::Command);
$OmittableEnd = 1;
$CountName = 'new';
$MustHaveContent = 1;
$Type = "section";
@AllowCommands = ('CAT',
#		  @{$TDS::Tdf::Command::Entities{'Sub'}},
		  '%Sub',
#		  'SUB',
#		  @{$TDS::Tdf::Command::Entities{'Flow'}});
#		  @{$TDS::Tdf::Command::Entities{'Block'}}
		  '%Block'
		  );
$ResetFootnoteCounter = 1;

sub IncrementCounter($$)
{
    my ($self, $params) = @_;
    
    # 
    $params->{new}++;
    $params->{n} = $params->{new};
    $TDS::Status->num_topic($params->{new});
}
sub ResetChildCounter($$)
{
    my ($self, $params) = @_;

    $params->{'sub'} = 0;
#    if ($TDS::Tdf::Command::_New::ResetFootnoteCounter){
    if ($ResetFootnoteCounter){
	$params->{fn} = 0;
    }
}    
sub ShouldBeShown($$)
{
    my ($self, $params) = @_;
    
    # ȥԥåֹ
#    die $TDS::Status->topic;
    my $topic = $TDS::Status->topic;
#    die $params->{topic};
#    print "$topic, ", $params->{new}, "<br>";
#    if ($params->{topic}){
    if ($topic){
#	if ($params->{new} != $params->{topic}){
	if ($params->{new} != $topic){
	    return 0;
	}
    }
    # ƥ긡
    require TDS::Category;
    my $category = $TDS::Category::SpecifiedCategory || param('cat');
    $category = ""                # ALL äåʤ
	if ($category eq 'ALL');

    if ($category){
	if ($self->{cat} !~ /$category/){
#	if (join(' ', @{$self->{cat}}) !~ /$category/){
	    return 0;
	}
    }
    return 1;
}
package TDS::Tdf::Command::NEW;
use Template;
use TDS::System;
use CGI::QueryString;
use JConv;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $Mark $MustHaveContent
	    $TitleTemplate $TitleEndTemplate
	    $HrefTemplateDynamic $HrefTemplateStatic $Anchor);

@ISA = qw(TDS::Tdf::Command::_New);
$Template = qq(<dt><span class="tds-title"><a name="%anchor" href="%href" title="%anchor">%mark</a>%cat %ext_attrs</span></dt>\n<dd>\n) unless defined $Template;
#$Template = qq(<h3><span class="tds-title"><a name="%anchor" href="%href">%mark</a>%cat %ext_attrs</span></h3>\n);
$EndTemplate = "%footnote</dd>\n" unless defined $EndTemplate;
#$EndTemplate = "%footnote";
$TitleTemplate = qq(<li><a href="%href">%new</a>:%ext_attrs</li>\n) unless defined $TitleTemplate;
$TitleEndTemplate = undef unless defined $TitleEndTemplate;
$HrefTemplateDynamic = qq(./?%date_href\#%anchor) unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = qq(d%year%0m%part.%suffix\#%anchor) unless defined $HrefTemplateStatic;
$Anchor = "%0d-%new" unless defined $Anchor;
$Mark = "" unless defined $Mark;

sub AsHTML($$)
{
    my ($self, $params) = @_;

    # HTML 
    my $html;

    # 
    my $keyword = param('keyword');
    my $match_num;
    if ($keyword){
	my $s_prefix = (param('search_ignorecase')) ? '(?i)' : '';
	if (param('search_titleonly')){
	    if ($self->{ext_attrs} =~ s!$s_prefix($keyword)!<strong>$1</strong>!){
		$match_num++;
		$html = $self->SUPER::AsHTML($params);
#		push(@c_html, $cmd->AsHTML($params));
	    }
	} else {
	    $html = $self->SUPER::AsHTML($params);
	    # hrefޤstrongΤϷʤ...
	    my $num = 
		$html =~ s!$s_prefix($keyword)!<strong>$1</strong>!g;
#	    my $num = 
#		$html =~ s!$keyword!<strong>$&</strong>!gi;
	    $html =~ s!(href=".*?)<strong>$s_prefix($keyword)</strong>(.*?")!$1$2$3!g;
	    $match_num += $num;
	    unless ($num){
		$html = undef;
	    }
	}
	$params->{match}->{num} += $match_num;
    } else {
	$html = $self->SUPER::AsHTML($params);
    }
    $params->{cat} = undef;
    $params->{footnote} = undef;
    return $html;
}

sub SetParams($$)
{
    my ($self, $params) = @_;
    #    print $params->{ext_attrs}, ", ";
    
    # ޡ
    $params->{cat} = $self->{cat};
    $params->{mark} = Expand($Mark, $params) || '*';
    $params->{mark_cat} = $params->{cat} || $params->{mark};
#    $params->{mark_cat} = $params->{mark};

#    if ($params->{footnotes}){
    if ($self->{footnotes}){
	$self->SetFootnotes($params);
    }

    $self->SUPER::SetParams($params);
}
package TDS::Tdf::Command::SNEW;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd $Mark $Anchor
	    $HrefTemplateDynamic $HrefTemplateStatic);


@ISA = qw(TDS::Tdf::Command::NEW);
#	  TDS::Tdf::Command::SECRET);
$Template = $TDS::Tdf::Command::NEW::Template unless defined $Template;
$EndTemplate = $TDS::Tdf::Command::NEW::EndTemplate unless defined $EndTemplate;
#$EndTemplate = "[/SNEW]";
$HrefTemplateDynamic = $TDS::Tdf::Command::NEW::HrefTemplateDynamic unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = $TDS::Tdf::Command::NEW::HrefTemplateStatic unless defined $HrefTemplateStatic;
$Anchor = $TDS::Tdf::Command::NEW::Anchor unless defined $Anchor;
$Mark = $TDS::Tdf::Command::NEW::Mark unless defined $Mark;

sub initialize($)
{
    my $self = shift;

#    $self->{secret} = 1;
#    $self->SUPER::initialize;
    $self->TDS::Tdf::Command::NEW::initialize;
#    $self->TDS::Tdf::Command::SECRET::initialize;
}

sub AsHTML
{
    my ($self, $params) = @_;

#    return $self->TDS::Tdf::Command::SECRET::AsHTML($params);
    $params->{has_secret} = 1;
    $TDS::Status->has_secret(1);

    my $html = $self->SUPER::AsHTML($params);
#    my $html = $self->TDS::Tdf::Command::NEW::AsHTML($params);
    return ($params->{is_author}) ? $html : undef;
}
################################################################
# Sub Entities
package TDS::Tdf::Command::_Sub;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $Type  $CountName $OmittableEnd $MustHaveContent $Mark);

@ISA = qw(TDS::Tdf::Command);
$Type = "section";
$CountName = 'sub';
$OmittableEnd = 1;
$MustHaveContent = 1;
#@AllowCommands = ('CAT', @{$TDS::Tdf::Command::Entities{'Block'}});
@AllowCommands = ('CAT', '%Block');
$Mark = "_";

sub IncrementCounter($$)
{
    my ($self, $params) = @_;

    $params->{'sub'}++;
}

package TDS::Tdf::Command::SUB;
use TDS::System;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $Mark $Anchor
	    $HrefTemplateDynamic $HrefTemplateStatic);

@ISA = qw(TDS::Tdf::Command::_Sub);
$Template = q(<div class="tds-subtitle"><a name="%anchor" href="%href" title="%anchor">%mark</a> %ext_attrs</div>) unless defined $Template;
$EndTemplate = "" unless defined $EndTemplate;
$HrefTemplateDynamic = qq(./?%date_href\#%anchor) unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = qq(d%year%0m%part.%suffix\#%anchor) unless defined $HrefTemplateStatic;
$Anchor = "%0d-%new-%sub" unless defined $Anchor;
$NumAttr = 0;
$Mark = "@" unless defined $Mark;

sub SetParams($$)
{
    my ($self, $params) = @_;

    $params->{mark} = $Mark;

    # ƥ: 1.00-pl3  SUB  CAT б
    $params->{cat} = $self->{cat};
#    print "SUB:", $self, "<br>";
#    print $params->{cat};
#    $self->SUPER::SetParams($params);
}

package TDS::Tdf::Command::SSUB;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd $Mark
	    $HrefTemplateDynamic $HrefTemplateStatic);

@ISA = qw(TDS::Tdf::Command::SUB);
$Template = $TDS::Tdf::Command::SUB::Template unless defined $Template;
$HrefTemplateDynamic = $TDS::Tdf::Command::SUB::HrefTemplateDynamic unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = $TDS::Tdf::Command::SUB::HrefTemplateStatic unless defined $HrefTemplateStatic;
$EndTemplate = $TDS::Tdf::Command::SUB::EndTemplate unless defined $EndTemplate;
$Mark = $TDS::Tdf::Command::SUB::Mark unless defined $Mark;

sub initialize($)
{
    my $self = shift;

    $self->{secret} = 1;
    $self->SUPER::initialize;
}

sub AsHTML
{
    my ($self, $params) = @_;

    $params->{has_secret} = 1;
    $TDS::Status->has_secret(1);
    
    my $html = $self->SUPER::AsHTML($params);
    return ($params->{is_author}) ? $html : undef;
}

################################################################
# Inline Elements
# these element has no content commands,
# so $EndTemplate, @AllowCommands has no means.

package TDS::Tdf::Command::_Inline;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $Type  $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command);
$IsOneline = 1;
$Type = "inline";
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Inline'}});
@AllowCommands = ('%Inline');
$HasArgContent = 1;

################
# Link Entity
package TDS::Tdf::Command::_Link;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Inline);

# LINK
package TDS::Tdf::Command::LINK;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Link);
$Template = qq(<a href="%1">) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 1;

package TDS::Tdf::Command::LINKTITLE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Link);
$Template = qq(<a href="%1">%linktitle) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 1;

sub SetParams($$)
{
    my ($self, $params) = @_;

    my $filename = $self->{attr}->[1];
    open(F, $filename) || warn $filename;
    while (<F>){
	chomp;
	if (m!<TITLE>(.*)</TITLE>!i){
	    $params->{linktitle} = $1;
	    last;
	}
    }
    close F;
}

package TDS::Tdf::Command::SELFLINK;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

use DateTime::Date;
use Template;

@ISA = qw(TDS::Tdf::Command::_Link);
$Template = qq(<a href="%url">) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 1;

sub SetParams($$)
{
    my ($self, $params) = @_;
    # 20000912-1-1
    #  d: ?20000912#12-1-1
    #  s: d200009b.html#12-1-1
    $spec = $self->{attr}->[1];
    
    my ($year, $month, $day, $opt) = $spec =~ /(\d{4})(\d{2})(\d{2})(.*)/;
    my $anchor = "$day$opt";
    my $dt = new DateTime::Date;
    $dt->Set($year, $month, $day);
    $tmp_params = $dt->GetParams;
    
    my $href;
    my $template;
    if (TDS::Mode->IsDynamic){
	$template = "?%year%0m%d#%anchor";
    } else {
	$template = "d%year%0m%part.%suffix#%anchor";
	require TDS::Static;
	$tmp_params->{suffix} = $TDS::Static::HtmlSuffix;
    }
    $tmp_params->{anchor} = $anchor;
    $params->{url} = Expand($template, $tmp_params);
    $self->SUPER::SetParams($params);
}
# ANCHOR
package TDS::Tdf::Command::ANCHOR;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Link);
$Template = qq(<a name="%1">) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 1;


# URL
package TDS::Tdf::Command::URL;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Link);

$Template = qq(<a href="%1">) unless defined $Template;
$EndTemplate = qq((%1)</a>) unless defined $EndTemplate;
$NumAttr = 1;

sub AsHTML($$)
{
    my ($self, $params) = @_;
    my $old_template = $Template;
    unless (join('', @{$self->{content}})){
	$Template = qq(<a href="%1">%1);
	$EndTemplate = qq(</a>);
    }
    my $html = $self->SUPER::AsHTML($params);
    $Template = $old_template;
    return $html;
}
	
# MAILTO
package TDS::Tdf::Command::MAILTO;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Link);

$Template = qq(<a href="mailto:%1">) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 1;

# BANNER
package TDS::Tdf::Command::BANNER;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_Link);
#$Template = q(<a href="%1"><img src="%2" alt="%ext_attrs" width="%width" height="%height" border=0>);
$Template = q(<a href="%1">%img) unless defined $Template;
$EndTemplate = qq(</a>) unless defined $EndTemplate;
$NumAttr = 5;
$HasArgContent = 0;

sub AsHTML($$)
{
    my ($self, $params) = shift;

    # Ū IMG AsHTML 
    my @tmp_attr = @{$self->{attr}};
    my $href = shift @tmp_attr;
    my $img = new TDS::Tdf::Command::IMG;
    @{$img->{attr}} = @tmp_attr;
    $img->{ext_attrs} = $self->{ext_attrs};
    $params->{img} = $img->AsHTML($params);
    
    return $self->SUPER::AsHTML($params);
}
    

################
# Decoration Commands
package TDS::Tdf::Command::_Decoration; 
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Inline);

# STRIKE
package TDS::Tdf::Command::STRIKE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<span style="text-decoration: line-through"><del><strike>) unless defined $Template;
$EndTemplate = q(</strike></del></span>) unless defined $EndTemplate;

# STRONG
package TDS::Tdf::Command::STRONG;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<strong>) unless defined $Template;
$EndTemplate = q(</strong>) unless defined $EndTemplate;

# EM
package TDS::Tdf::Command::EM;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<em>) unless defined $Template;
$EndTemplate = q(</em>) unless defined $EndTemplate;

# BIG
package TDS::Tdf::Command::BIG;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<big>) unless defined $Template;
$EndTemplate = q(</big>) unless defined $EndTemplate;

# SMALL
package TDS::Tdf::Command::SMALL;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<small>) unless defined $Template;
$EndTemplate = q(</small>) unless defined $EndTemplate;

# COLOR
package TDS::Tdf::Command::COLOR;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<span style="color: %1">) unless defined $Template;
$EndTemplate = q(</span>) unless defined $EndTemplate;
$NumAttr = 1;

# ITALIC
package TDS::Tdf::Command::ITALIC;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<i>) unless defined $Template;
$EndTemplate = q(</i>) unless defined $EndTemplate;

# BOLD
package TDS::Tdf::Command::BOLD;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<b>) unless defined $Template;
$EndTemplate = q(</b>) unless defined $EndTemplate;

# SUBSCRIPT
package TDS::Tdf::Command::SUBSCRIPT;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<sub>) unless defined $Template;
$EndTemplate = q(</sub>) unless defined $EndTemplate;

# SUPERSCRIPT
package TDS::Tdf::Command::SUPERSCRIPT;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<sup>) unless defined $Template;
$EndTemplate = q(</sup>) unless defined $EndTemplate;

# UNDERLINE
package TDS::Tdf::Command::UNDERLINE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<span style="text-decoration: underline"><u>) unless defined $Template;
$EndTemplate = q(</u></span>) unless defined $EndTemplate;

# ASC
package TDS::Tdf::Command::ASC;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Decoration);
$Template = q(<br><br><span style="font-size: large; text-align: center; color: red"><strong><big>) unless defined $Template;
#$Template = q(<div style="text-align: center; color: red; font-size: 150%"><strong>);
#$EndTemplate = q(</strong></div><br>);
$EndTemplate = q(</big></strong></span><br>) unless defined $EndTemplate;


################
# Image Commands
package TDS::Tdf::Command::_Image;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Inline);

# IMG 
package TDS::Tdf::Command::IMG;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent
	    $BaseUrl $BaseDir);


#use TCPIP;
use Url;
use TDS::IdentInfo;
use TDS::DirInfo;
use Template;
use FileSpec;

@ISA = qw(TDS::Tdf::Command::_Image);
$Template = q(<img %align src="%src" alt="%ext_attrs" %size>) unless defined $Template;
$NumAttr = 4;
$HasArgContent = 0;

$BaseDir = "";
$BaseUrl = "";
#$BaseDir = "d:/tom/www/tawagoto";
#$BaseUrl = "/~tom/tawagoto/";

sub GetImageUrl($)
{
    my $src = shift;

    if ($BaseUrl){
	if ($BaseUrl !~ m!/$!){
	    $BaseUrl .= "/";
	}
	if ($src !~ m!^/! && $src =~ /^http:/){
	    $src = "$BaseUrl$src";
	}
    }
    return $src;
}
    
sub GetImageFilename($)
{
    my $src = shift;

    return FileSpec->rel2abs($src, $BaseDir || GetWebDiaryDir());
}
sub GetImageSize ($)
{
    my $src = shift;
    my ($width, $height);
    my ($w, $h);
    my $warning;

    require Image::Size;
    
    if ($src =~ /^http:/){      # let it disable
	if (0){
	    my $url = new Url(uri=>$src);
	    my $fd = "image";
	    
	    # GET request
	    tcp_client($fd, $url->host, $url->port);
	    my $path = $url->path;
	    print $fd "GET $path HTTP/1.0\n\n";
	    # skip HTTP Header
	    # check HTTP status
	    my $first_line = <$fd>; # 
	    unless ($first_line =~ /200 OK/){    # must be 200 OK
		return (undef, undef, $first_line);
	    }
	    while (1){
		$_ = <$fd>;
		last if $_ =~ /^[\r\n]*$/;
	    }
	    ($width, $height) = Image::Size::imgsize($src, $fd);
	}
    } else {
	$src = FileSpec->rel2abs($src, $BaseDir)
	    if $BaseDir;
	($width, $height) = Image::Size::imgsize($src);
    }
    # %width, %height
    if (($width <= 0) || ($height <= 0)){    # can NOT get size
	$warning = "[can't get size: $src]";
	$w = $h = 0;
    } else {
	if ($w > 0){                             # only width
	    $h = $height * ($w/$width);
	} elsif ($h > 0){                        # only height
	    $w = int($width * ($h/$height));
	} else {                                 # nothing
	    $w = $width;
	    $h = $height;
	}
	$warning = "[set width, height to the tdf: ($w $h)]";
    }
    return ($w, $h, $warning);
}

sub AsHTML ($$$)
{
    my ($self, $params) = @_;
    my $src = $self->{attr}->[1];
    my ($w, $h) = ($self->{attr}->[3], $self->{attr}->[4]);   # arguments
    my $warning_str;

    # src
#    if ($src =~ m!^/~!){                 # convert to http
#	my $server_uri = new Url(uri=>$TDS::IdentInfo::DiaryURL);
#	my $host = $server_uri->host;
#	$src = "http://$host$src";
#    }
    # align
    if ($self->{attr}->[2] =~ /^(left|right|top|middle|bottom)$/i){
	$params->{align} = qq(align="$1");
    }

    # size
    if (($w > 0) && ($h > 0)){         # both width and height are specified
	$params->{width} = $w;
	$params->{height} = $h;
    } else {                           # lack width or height
	# get size
	unless ($src =~ m!^http://!){
	    ($params->{width}, $params->{height}, $warning_str) =
		GetImageSize(GetImageFilename($src));
	}
    }
    my $warning_html;
    if ($warning_str){
	unless ($w eq 'auto' || $h eq 'auto'){
	    my $w_cmd = new TDS::Tdf::Command::WARNING;
	    $w_cmd->PushContent($warning_str);
	    $warning_html = $w_cmd->AsHTML({});
	}
    }
    # reset size
    if ($params->{width} && $params->{height}){
	my $size_template = qq(width="%width" height="%height");
	$params->{src} = GetImageUrl($src);
	$params->{size} = Expand($size_template, $params);
    } else {
	$params->{src} = $src;
    }
    if ($self->{no_warning}){
	$warning_html = undef;
    }
    return  $warning_html . $self->SUPER::AsHTML($params);
}

package TDS::Tdf::Command::DAILYIMAGE;
use vars qw(@ISA
	    $Template $SrcTemplate $DefaultSrcTemplate
	    $NumAttr
	    $ImageSuffix
	    $ConstantImageSize $Width $Height);
use Template;
@ISA = qw(TDS::Tdf::Command::IMG);

$Template = qq(<img %align src="%src" width=%width height=%height alt="%ext_attrs"><br clear="all">) unless defined $Template;
$SrcTemplate = qq(image/%year/%0m/%0d.%image_suffix) unless defined $SrcTemplate;
$DefaultSrcTemplate = qq(image/default.%image_suffix) unless defined $DefaultSrcTemplate;
$NumAttr = 4;
$Width = 240 unless defined $Width;
$Height = 160 unless defined $Height;
$ConstantImageSize = 1 unless defined $ConstantImageSize;
$ImageSuffix = "jpg" unless defined $ImageSuffix;

sub AsHTML($$)
{
    my ($self, $params) = @_;

    $params->{image_suffix} = $ImageSuffix;
    my $src;

    if ($self->{attr}->[1]){
	$src = $self->{attr}->[1];
    } else {
	$src = Expand($SrcTemplate, $params);
	my $file = TDS::Tdf::Command::IMG::GetImageFilename($src);
	$file =~ s!/$!!;
	unless (-f $file){
	    unless ($DefaultSrcTemplate){ # if not defined, show no image.
		return undef;
	    } else {
		$src = Expand($DefaultSrcTemplate, $params);
	    }
	}
    }
    my $align = $self->{attr}->[2] || "left";
    
    $self->{attr} = ['IMG', $src, "left"];
    if ($ConstantImageSize){
	$self->{attr}->[3] = $Width;
	$self->{attr}->[4] = $Height;
    } else {
	$self->{no_warning} = 1;
    }
    $self->{ext_attrs} = $src;
#    $self->SUPER::AsHTML($params);
    $params->{daily_image} = $self->SUPER::AsHTML($params);
    return undef;
}


################
# container Commands
package TDS::Tdf::Command::SPAN;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Inline);
$Template = qq(<span class="%1">) unless defined $Template;
$EndTemplate = qq(</span>) unless defined $EndTemplate;
$OmittableEnd = 1;
$NumAttr = 1;
#$IsOneline = 0;

################
package TDS::Tdf::Command::BR;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_Inline);
$Template = qq(<br %ext_attrs>) unless defined $Template;
$HasArgContent = 0;

################
package TDS::Tdf::Command::VERB;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse);

@ISA = qw(TDS::Tdf::Command::_Inline);
$Template = "" unless defined $Template;
$EndTemplate ="" unless defined $EndTemplate;
#$NoParse = 1;

sub EscapeEntity($\$)
{
    my ($self, $line) = @_;
    return $$line;  # do nothing
}

use TDS::Tdf::Command::WARNING;
# split to file

# functional command

package TDS::Tdf::Command::ISBN;
use TDS::Tdf::Command;
use Template;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse
	    $ContentTemplate $Separator @BookStores
	    $ShowOnlyAuthor);

@ISA = qw(TDS::Tdf::Command::_Inline);
@AllowCommands = (@{$TDS::Tdf::Command::Entities{'inline'}});
$NumAttr = 1;
$Template = qq([ISBN%isbn: %bookstores]) unless defined $Template;
$EndTemplate = qq(<br>\n) unless defined $EndTemplate;
$ContentTemplate = qq(<a href="%url">%name</a>) unless defined $ContentTemplate;
$Separator = "/" unless defined $Separator;

@BookStores = ({'name'=>'bk',
		'url'=> qq(http://www.bk1.co.jp/cgi-bin/srch/srch_result_book.cgi?idx=3&amp;isbn=%isbn)},
	       {'name'=>'IS',
		'url'=> qq(http://www.isize.com/book/cgi-bin/isbn.cgi?isbn=%isbn)},
	       {'name'=>'',
		'url'=> qq(http://www.netdirect.co.jp/search/ISSSchDetail.asp?ISBN=%isbn_no_bar)},
	       {'name'=>'JB',
		'url'=> qq(http://www.jbook.co.jp/product.asp?isbn=%isbn_no_bar)},
	       {'name'=>'BO',
		'url' => qq(http://www.jp.bol.com/cec/cstage?ecaction=bcssearch&amp;query_type=BS_ISBN&amp;isbn=%isbn_no_bar)},
	       {'name'=>'',
		'url'=> qq(http://bookweb.kinokuniya.co.jp/guest/cgi-bin/wshosea.cgi?W-ISBN=%isbn_no_bar)},
	       {'name'=>'AM',
		'url'=> qq(http://www.amazon.co.jp/exec/obidos/ASIN/%isbn_no_bar)},
	       {'name'=>'eS',
		'url'=> qq(http://www.eshopping.ne.jp/bks.svl?CID=BKS504&amp;access_method=isbn_cd&amp;input_data=%isbn)},
	       {'name'=>'',
		'url'=> qq(http://www.fujisan.com/online/Jsearch?key=productcode&amp;value=%isbn_no_bar)},
	       {'name'=>'',
		'url'=> qq(http://www1.honyasan.co.jp/washo/book.cfm?PRODUCT_CD=%isbn)}) unless defined @BookStores;

sub SetParams($$)
{
    my ($self, $params) = @_;

    my $isbn = $self->{attr}->[1];
    my $isbn_no_bar = $isbn;
    $isbn_no_bar =~ s/\-//g;
    
    my @contents;
    for (@BookStores){
	my $name = $_->{'name'};
	my $url = $_->{'url'};

	my $tmp_params;
	$tmp_params->{url} = Expand($url, {'isbn'=>$isbn,
					   'isbn_no_bar'=>$isbn_no_bar
					   });
	$tmp_params->{name} = $name;

	push(@contents, Expand($ContentTemplate, $tmp_params));
    }
    $params->{bookstores} = join($Separator, @contents);
    $params->{isbn} = $isbn;
    return $params;
}


################################################################
# Block Commands
package TDS::Tdf::Command::_Block;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $Type  $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command);
$Type = "block";

# P
package TDS::Tdf::Command::P;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Inline'}});
@AllowCommands = ('%Inline');
$OmittableEnd = 1;
$Template = "<p %ext_attrs>\n" unless defined $Template;
$EndTemplate = "</p>\n" unless defined $EndTemplate;


# SECRET
package TDS::Tdf::Command::SECRET;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'DiaryContent'}},
#		  @{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%DiaryContent', '%Flow');
$Template = qq(<div class="secret">) unless defined $Template;
$EndTemplate = "</div>" unless defined $EndTemplate;

sub initialize($)
{
    my $self = shift;

    $self->{secret} = 1;
    $self->SUPER::initialize;
}

sub AsHTML
{
    my ($self, $params) = @_;

    $params->{has_secret} = 1;
    $TDS::Status->has_secret(1);
    
    my $html = $self->SUPER::AsHTML($params);
    return ($params->{is_author}) ? $html : undef;
}

# VERBATIM
package TDS::Tdf::Command::VERBATIM;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse);

@ISA = qw(TDS::Tdf::Command::_Block);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%Flow');
$Template = qq(\n) unless defined $Template;
$EndTemplate = qq(\n) unless defined $EndTemplate;
$NoParse = 1;

sub EscapeEntity($\$)
{
    my ($self, $line) = @_;
    return $$line;  # do nothing
}
    
# HIDE
package TDS::Tdf::Command::HIDE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse);

@ISA = qw(TDS::Tdf::Command::_Block);
@AllowCommands = ('%Flow');
$NoParse = 1;

sub AsHTML($$)
{
    my ($self, $params) = @_;
    undef;
}

# NOPARSE
package TDS::Tdf::Command::NOPARSE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse);

@ISA = qw(TDS::Tdf::Command::_Block);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%Flow');
$Template = qq(<pre>) unless defined $Template;
$EndTemplate = qq(</pre>) unless defined $EndTemplate;
$NoParse = 1;

# Cite Commands
package TDS::Tdf::Command::_Cite;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%Flow');

# PRE
package TDS::Tdf::Command::PRE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Cite);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Inline'}});
@AllowCommands = ('%Flow');
$Template = "<pre>" unless defined $Template;
$EndTemplate = "</pre>" unless defined $EndTemplate;

# CITE
package TDS::Tdf::Command::CITE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Cite);
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Block'}});
@AllowCommands = ('%Block');
$Template = "<blockquote %ext_attrs>" unless defined $Template;
$EndTemplate = "</blockquote>" unless defined $EndTemplate;

# CODE
package TDS::Tdf::Command::CODE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $NoParse);

@ISA = qw(TDS::Tdf::Command::_Cite);
$Template = "<blockquote %ext_attrs><pre>" unless defined $Template;
$EndTemplate = "</pre></blockquote>" unless defined $EndTemplate;
$NoParse = 1;

# List Commands
package TDS::Tdf::Command::_List;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);

# List Content
package TDS::Tdf::Command::_ListContent;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_Block);
$HasArgContent = 1;
$OmittableEnd = 1;

# UL
package TDS::Tdf::Command::UL;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_List);
$Template = "<ul %ext_attrs>" unless defined $Template;
$EndTemplate = "</ul>" unless defined $EndTemplate;
@AllowCommands = ('LI');

# OL
package TDS::Tdf::Command::OL;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_List);
$Template = "<ol %ext_attrs>" unless defined $Template;
$EndTemplate = "</ol>" unless defined $EndTemplate;
@AllowCommands = ('LI');

# LI
package TDS::Tdf::Command::LI;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_ListContent);
$Template = q(<li %ext_attrs>) unless defined $Template;
$EndTemplate = "</li>" unless defined $EndTemplate;
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%Flow');

# DL
package TDS::Tdf::Command::DL;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_List);
@AllowCommands = ('DT', 'DD');
$Template = "<dl %ext_attrs>" unless defined $Template;
$EndTemplate = "</dl>" unless defined $EndTemplate;

# DT
package TDS::Tdf::Command::DT;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_ListContent);
$Template = q(<dt %ext_attrs>) unless defined $Template;
$EndTemplate = "</dt>\n" unless defined $EndTemplate;
@AllowCommands = ('%Inline');

# DD
package TDS::Tdf::Command::DD;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    @NotAllowCommands $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_ListContent);
$Template = q(<dd %ext_attrs>) unless defined $Template;
$EndTemplate = "</dd>\n" unless defined $EndTemplate;
#@AllowCommands = (@{$TDS::Tdf::Command::Entities{'Flow'}});
@AllowCommands = ('%Flow');
@NotAllowCommands = ('DT', 'DD');

# TABLE
package TDS::Tdf::Command::TABLE;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
$Template = q(<table %ext_attrs>) unless defined $Template;
$EndTemplate = "</table>\n" unless defined $EndTemplate;
@AllowCommands = ('TR');

# TR
package TDS::Tdf::Command::TR;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
$Template = q(<tr %ext_attrs>) unless defined $Template;
$EndTemplate = "</tr>\n" unless defined $EndTemplate;
$OmittableEnd = 1;
@AllowCommands = ('TD', 'TH');

# TableContent
package TDS::Tdf::Command::_TableContent;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $HasArgContent);

@ISA = qw(TDS::Tdf::Command::_Block);
$HasArgContent = 1;
$OmittableEnd = 1;

# TH
package TDS::Tdf::Command::TH;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_TableContent);
$Template = q(<th %ext_attrs>) unless defined $Template;
$EndTemplate = "</th>\n" unless defined $EndTemplate;
@AllowCommands = ('%Flow');

# TD
package TDS::Tdf::Command::TD;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_TableContent);
$Template = q(<td %ext_attrs>) unless defined $Template;
$EndTemplate = "</td>\n" unless defined $EndTemplate;
@AllowCommands = ('%Flow');

# container Commands
package TDS::Tdf::Command::DIV;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
$Template = qq(<div %ext_attrs>\n) unless defined $Template;
$EndTemplate = qq(</div>\n) unless defined $EndTemplate;

# HR
package TDS::Tdf::Command::HR;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Block);
$IsOneline = 1;
$Template = qq(<hr %ext_attrs>\n) unless defined $Template;

# Comment Commands
package TDS::Tdf::Command::_Comment;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Inline);
$IsOneline = 0;

# COMMENT
package TDS::Tdf::Command::COMMENT;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);

@ISA = qw(TDS::Tdf::Command::_Comment);
$Template = qq(<!-- ) unless defined $Template;
$EndTemplate = qq( -->\n) unless defined $EndTemplate;
@AllowCommands = ('%Flow');

# FN
package TDS::Tdf::Command::FN;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd $Anchor);
use vars qw($HeaderTemplate $FooterTemplate
	    $HrefTemplateDynamic $HrefTemplateStatic);

@ISA = qw(TDS::Tdf::Command::_Comment);

$Template = qq(<a href="\#%anchor" title="%anchor"><small>*%fn</small></a>) unless defined $Template;
$Anchor = "%0d-%new-F%fn" unless defined $Anchor;
			 
@AllowCommands = ('%Inline');

sub SetParams($$)
{
    my ($self, $params) = @_;

    my $fn_content = new TDS::Tdf::Command::FN_Content;
    $fn_content->{content} = $self->{content};
    my $parent = $self->FindParent('NEW', 'SNEW', 'DIARY', 'Tdf');
    if ($parent){
	push(@{$parent->{footnotes}}, $fn_content);
    }
}    
sub AsHTML($$)
{
    my ($self, $params) = @_;

    $params->{fn}++;
    my ($template) = $self->GetTemplate;
    my $html = Template::Expand($template, $params);
    
    $self->SUPER::AsHTML($params);
    return $html;
}

# FN_Content
package TDS::Tdf::Command::FN_Content;
use TDS::System;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	    $CountName $OmittableEnd $Anchor);
use vars qw($HeaderTemplate $FooterTemplate $ContentTemplate
	    $HrefTemplateDynamic $HrefTemplateStatic);

@ISA = qw(TDS::Tdf::Command::_Comment);

$Template = qq(<small><a name="%anchor" href="%href" title="%anchor">*%fn</a>:) unless defined $Template;
#$Template = qq(\n<span style="font-size: 80%"><a name="%0d-%new-F%fn" href="%href">*%fn</a>:);
$EndTemplate = qq(</small><br>) unless defined $EndTemplate;
#$EndTemplate = qq(</span><br>);

#$HrefTemplateDynamic = qq(?%year%month%part\#%day-%new-F%fn);
$HrefTemplateDynamic = qq(./?%date_href\#%0d-%new-F%fn) unless defined $HrefTemplateDynamic;
$HrefTemplateStatic = qq(d%y%0m%part.%suffix\#%0d-%new-F%fn) unless defined $HrefTemplateStatic;
$Anchor = "%0d-%new-F%fn" unless defined $Anchor;

sub IncrementCounter($$)
{
    my ($self, $params) = @_;

    $params->{fn}++;
}
    

# FN_Formatter
package TDS::Tdf::Command::FN_Formatter;
use vars qw(@ISA $Template $EndTemplate $NumAttr $IsOneline @AllowCommands
	     $CountName $OmittableEnd);
use vars qw($HeaderTemplate $FooterTemplate $ContentTemplate
	    $HrefTemplateDynamic $HrefTemplateStatic);

@ISA = qw(TDS::Tdf::Command::_Comment);

$Template = qq(<hr style="width: 40%; text-align: left;"><div>\n) unless defined $Template;
#$Template = qq(<div>-------<br>);
$EndTemplate = qq(<br></div>\n) unless defined $EndTemplate;

sub AsHTML($$)
{
    my ($self, $params) = @_;

#    return "FN_Format";
#    return undef if $params->{in_include};  # INCLUDE Ǥϵɽʤ
    return undef if $self->FindParent('INCLUDE');
    
#    $params->{fn}++;
    $self->SUPER::AsHTML($params);
}
##BEGIN { warn times, " Classes End"; }

1;
