require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_VAX_BUS_H_)) {
    eval 'sub _VAX_BUS_H_ () {1;}' unless defined(&_VAX_BUS_H_);
    if(defined(&BUS_SPACE_DEBUG)) {
	require 'sys/systm.ph';
	eval 'sub __BUS_SPACE_ALIGNED_ADDRESS {
	    my($p, $t) = @_;
    	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
	}' unless defined(&__BUS_SPACE_ALIGNED_ADDRESS);
	eval 'sub __BUS_SPACE_ADDRESS_SANITY {
	    my($p, $t, $d) = @_;
    	    eval q(({  &if ( &__BUS_SPACE_ALIGNED_ADDRESS(, $t) == 0) {  &printf(\\"%s 0x%lx not aligned to %d bytes %s:%d\\\\n\\", $d, ($p), $sizeof{$t},  &__FILE__,  &__LINE__); } ( &void) 0; }));
	}' unless defined(&__BUS_SPACE_ADDRESS_SANITY);
	eval 'sub BUS_SPACE_ALIGNED_POINTER {
	    my($p, $t) = @_;
    	    eval q( &__BUS_SPACE_ALIGNED_ADDRESS($p, $t));
	}' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    } else {
	eval 'sub __BUS_SPACE_ADDRESS_SANITY {
	    my($p,$t,$d) = @_;
    	    eval q(( &void) 0);
	}' unless defined(&__BUS_SPACE_ADDRESS_SANITY);
	eval 'sub BUS_SPACE_ALIGNED_POINTER {
	    my($p, $t) = @_;
    	    eval q( &ALIGNED_POINTER($p, $t));
	}' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    }
    eval 'sub PRIxBUSADDR () { &PRIxPADDR;}' unless defined(&PRIxBUSADDR);
    eval 'sub PRIxBUSSIZE () { &PRIxPSIZE;}' unless defined(&PRIxBUSSIZE);
    eval 'sub PRIuBUSSIZE () { &PRIuPSIZE;}' unless defined(&PRIuBUSSIZE);
    eval 'sub PRIxBSH () { &PRIxVADDR;}' unless defined(&PRIxBSH);
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x1;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x2;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x4;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub bus_space_map {
        my($t, $a, $s, $f, $hp) = @_;
	    eval q((*($t)-> &vbs_map)(($t)-> &vbs_cookie, ($a), ($s), ($f), ($hp), 1));
    }' unless defined(&bus_space_map);
    eval 'sub vax_bus_space_map_noacct {
        my($t, $a, $s, $f, $hp) = @_;
	    eval q((*($t)-> &vbs_map)(($t)-> &vbs_cookie, ($a), ($s), ($f), ($hp), 0));
    }' unless defined(&vax_bus_space_map_noacct);
    eval 'sub bus_space_unmap {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &vbs_unmap)(($t)-> &vbs_cookie, ($h), ($s), 1));
    }' unless defined(&bus_space_unmap);
    eval 'sub vax_bus_space_unmap_noacct {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &vbs_unmap)(($t)-> &vbs_cookie, ($h), ($s), 0));
    }' unless defined(&vax_bus_space_unmap_noacct);
    eval 'sub bus_space_subregion {
        my($t, $h, $o, $s, $nhp) = @_;
	    eval q((*($t)-> &vbs_subregion)(($t)-> &vbs_cookie, ($h), ($o), ($s), ($nhp)));
    }' unless defined(&bus_space_subregion);
    eval 'sub bus_space_alloc {
        my($t, $rs, $re, $s, $a, $b, $f, $ap, $hp) = @_;
	    eval q((*($t)-> &vbs_alloc)(($t)-> &vbs_cookie, ($rs), ($re), ($s), ($a), ($b), ($f), ($ap), ($hp)));
    }' unless defined(&bus_space_alloc);
    eval 'sub bus_space_free {
        my($t, $h, $s) = @_;
	    eval q((*($t)-> &vbs_free)(($t)-> &vbs_cookie, ($h), ($s)));
    }' unless defined(&bus_space_free);
    eval 'sub bus_space_vaddr {
        my($t, $h) = @_;
	    eval q((( &void *) ($h)));
    }' unless defined(&bus_space_vaddr);
    eval 'sub bus_space_mmap {
        my($t, $a, $o, $p, $f) = @_;
	    eval q((*($t)-> &vbs_mmap)(($t)-> &vbs_cookie, ($a), ($o), ($p), ($f)));
    }' unless defined(&bus_space_mmap);
    eval 'sub bus_space_read_1 {
        my($t, $h, $o) = @_;
	    eval q(( &__USE($t), (*( &volatile  &uint8_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_1);
    eval 'sub bus_space_read_2 {
        my($t, $h, $o) = @_;
	    eval q(( &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\"),  &__USE($t), (*( &volatile  &uint16_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_2);
    eval 'sub bus_space_read_4 {
        my($t, $h, $o) = @_;
	    eval q(( &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\"),  &__USE($t), (*( &volatile  &uint32_t *)(($h) + ($o)))));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_read_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_read_multi_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint16_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_read_multi_2(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint32_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_read_multi_4(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_read_multi_4);
    eval 'sub vax_mem_read_multi_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &uint8_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_1);
    eval 'sub vax_mem_read_multi_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &uint16_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_2);
    eval 'sub vax_mem_read_multi_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *$a = *( &volatile  &uint32_t *)( &addr); });
    }' unless defined(&vax_mem_read_multi_4);
    eval 'sub bus_space_read_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &vax_mem_read_region_1(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_read_region_1);
    eval 'sub bus_space_read_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint16_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_read_region_2(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_read_region_2);
    eval 'sub bus_space_read_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint32_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_read_region_4(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_read_region_4);
    eval 'sub vax_mem_read_region_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *$a = *( &volatile  &uint8_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_1);
    eval 'sub vax_mem_read_region_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 2, $a++) *$a = *( &volatile  &uint16_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_2);
    eval 'sub vax_mem_read_region_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 4, $a++) *$a = *( &volatile  &uint32_t *)( &addr); });
    }' unless defined(&vax_mem_read_region_4);
    eval 'sub bus_space_write_1 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &__USE($t); (( &void)(*( &volatile  &uint8_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_1);
    eval 'sub bus_space_write_2 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &__USE($t); (( &void)(*( &volatile  &uint16_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_2);
    eval 'sub bus_space_write_4 {
        my($t, $h, $o, $v) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &__USE($t); (( &void)(*( &volatile  &uint32_t *)(($h) + ($o)) = ($v))); }  &while (0));
    }' unless defined(&bus_space_write_4);
    eval 'sub bus_space_write_multi_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &vax_mem_write_multi_1(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint16_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_write_multi_2(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint32_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_write_multi_4(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_write_multi_4);
    eval 'sub vax_mem_write_multi_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &uint8_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_1);
    eval 'sub vax_mem_write_multi_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &uint16_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_2);
    eval 'sub vax_mem_write_multi_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &const  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--, $a++) *( &volatile  &uint32_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_multi_4);
    eval 'sub bus_space_write_region_1 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &vax_mem_write_region_1(($t), ($h), ($o), ($a), ($c)));
    }' unless defined(&bus_space_write_region_1);
    eval 'sub bus_space_write_region_2 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint16_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_write_region_2(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_write_region_2);
    eval 'sub bus_space_write_region_4 {
        my($t, $h, $o, $a, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($a),  &uint32_t, \\"buffer\\");  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_write_region_4(($t), ($h), ($o), ($a), ($c)); }  &while (0));
    }' unless defined(&bus_space_write_region_4);
    eval 'sub vax_mem_write_region_1 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &uint8_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_1);
    eval 'sub vax_mem_write_region_2 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &uint16_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_2);
    eval 'sub vax_mem_write_region_4 {
        my($t,$h,$o,$a,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++, $a++) *( &volatile  &uint32_t *)( &addr) = *$a; });
    }' unless defined(&vax_mem_write_region_4);
    eval 'sub bus_space_set_multi_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_multi_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_set_multi_2(($t), ($h), ($o), ($v), ($c)); }  &while (0));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_set_multi_4(($t), ($h), ($o), ($v), ($c)); }  &while (0));
    }' unless defined(&bus_space_set_multi_4);
    eval 'sub vax_mem_set_multi_1 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &uint8_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_1);
    eval 'sub vax_mem_set_multi_2 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &uint16_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_2);
    eval 'sub vax_mem_set_multi_4 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &while ($c--) *( &volatile  &uint32_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_multi_4);
    eval 'sub bus_space_set_region_1 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &vax_mem_set_region_1(($t), ($h), ($o), ($v), ($c)));
    }' unless defined(&bus_space_set_region_1);
    eval 'sub bus_space_set_region_2 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint16_t, \\"bus addr\\");  &vax_mem_set_region_2(($t), ($h), ($o), ($v), ($c)); }  &while (0));
    }' unless defined(&bus_space_set_region_2);
    eval 'sub bus_space_set_region_4 {
        my($t, $h, $o, $v, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h) + ($o),  &uint32_t, \\"bus addr\\");  &vax_mem_set_region_4(($t), ($h), ($o), ($v), ($c)); }  &while (0));
    }' unless defined(&bus_space_set_region_4);
    eval 'sub vax_mem_set_region_1 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr++) *( &volatile  &uint8_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_1);
    eval 'sub vax_mem_set_region_2 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 2) *( &volatile  &uint16_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_2);
    eval 'sub vax_mem_set_region_4 {
        my($t,$h,$o,$v,$c) = @_;
	    eval q({  &bus_addr_t  &addr = $h + $o;  &for (; $c != 0; $c--,  &addr += 4) *( &volatile  &uint32_t *)( &addr) = $v; });
    }' unless defined(&vax_mem_set_region_4);
    eval 'sub bus_space_copy_region_1 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &vax_mem_copy_region_1(($t), ($h1), ($o1), ($h2), ($o2), ($c)));
    }' unless defined(&bus_space_copy_region_1);
    eval 'sub bus_space_copy_region_2 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h1) + ($o1),  &uint16_t, \\"bus addr 1\\");  &__BUS_SPACE_ADDRESS_SANITY(($h2) + ($o2),  &uint16_t, \\"bus addr 2\\");  &vax_mem_copy_region_2(($t), ($h1), ($o1), ($h2), ($o2), ($c)); }  &while (0));
    }' unless defined(&bus_space_copy_region_2);
    eval 'sub bus_space_copy_region_4 {
        my($t, $h1, $o1, $h2, $o2, $c) = @_;
	    eval q( &do {  &__BUS_SPACE_ADDRESS_SANITY(($h1) + ($o1),  &uint32_t, \\"bus addr 1\\");  &__BUS_SPACE_ADDRESS_SANITY(($h2) + ($o2),  &uint32_t, \\"bus addr 2\\");  &vax_mem_copy_region_4(($t), ($h1), ($o1), ($h2), ($o2), ($c)); }  &while (0));
    }' unless defined(&bus_space_copy_region_4);
    eval 'sub vax_mem_copy_region_1 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q({  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1++,  &addr2++) *( &volatile  &uint8_t *)( &addr2) = *( &volatile  &uint8_t *)( &addr1); }  &else {  &for ( &addr1 += ($c - 1),  &addr2 += ($c - 1); $c != 0; $c--,  &addr1--,  &addr2--) *( &volatile  &uint8_t *)( &addr2) = *( &volatile  &uint8_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_region_1);
    eval 'sub vax_mem_copy_region_2 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q({  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1 += 2,  &addr2 += 2) *( &volatile  &uint16_t *)( &addr2) = *( &volatile  &uint16_t *)( &addr1); }  &else {  &for ( &addr1 += 2* ($c - 1),  &addr2 += 2* ($c - 1); $c != 0; $c--,  &addr1 -= 2,  &addr2 -= 2) *( &volatile  &uint16_t *)( &addr2) = *( &volatile  &uint16_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_region_2);
    eval 'sub vax_mem_copy_region_4 {
        my($t,$h1,$o1,$h2,$o2,$c) = @_;
	    eval q({  &bus_addr_t  &addr1 = $h1 + $o1;  &bus_addr_t  &addr2 = $h2 + $o2;  &if ( &addr1 >=  &addr2) {  &for (; $c != 0; $c--,  &addr1 += 4,  &addr2 += 4) *( &volatile  &uint32_t *)( &addr2) = *( &volatile  &uint32_t *)( &addr1); }  &else {  &for ( &addr1 += 4* ($c - 1),  &addr2 += 4* ($c - 1); $c != 0; $c--,  &addr1 -= 4,  &addr2 -= 4) *( &volatile  &uint32_t *)( &addr2) = *( &volatile  &uint32_t *)( &addr1); } });
    }' unless defined(&vax_mem_copy_region_4);
    eval 'sub bus_space_barrier {
        my($t, $h, $o, $l, $f) = @_;
	    eval q((( &void)(( &void)($t), ( &void)($h), ( &void)($o), ( &void)($l), ( &void)($f))));
    }' unless defined(&bus_space_barrier);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x1;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x2;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    eval 'sub BUS_DMA_WAITOK () {0x;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x1;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x2;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x4;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_STREAMING () {0x8;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_BUS1 () {0x10;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x20;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x40;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x80;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_READ () {0x100;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x200;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_NOCACHE () {0x400;}' unless defined(&BUS_DMA_NOCACHE);
    eval 'sub VAX_BUS_DMA_SPILLPAGE () { &BUS_DMA_BUS1;}' unless defined(&VAX_BUS_DMA_SPILLPAGE);
    eval 'sub DMAMAP_HAS_SGMAP () {0x80000000;}' unless defined(&DMAMAP_HAS_SGMAP);
    eval 'sub BUS_DMASYNC_PREREAD () {0x1;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x2;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x4;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x8;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval("sub VAX_BUS_MAINBUS () { 0; }") unless defined(&VAX_BUS_MAINBUS);
    eval("sub VAX_BUS_SBI () { 1; }") unless defined(&VAX_BUS_SBI);
    eval("sub VAX_BUS_MASSBUS () { 2; }") unless defined(&VAX_BUS_MASSBUS);
    eval("sub VAX_BUS_UNIBUS () { 3; }") unless defined(&VAX_BUS_UNIBUS);
    eval("sub VAX_BUS_BI () { 4; }") unless defined(&VAX_BUS_BI);
    eval("sub VAX_BUS_XMI () { 5; }") unless defined(&VAX_BUS_XMI);
    eval("sub VAX_BUS_TURBOCHANNEL () { 6; }") unless defined(&VAX_BUS_TURBOCHANNEL);
    eval 'sub BUS_DMA_TAG_VALID {
        my($t) = @_;
	    eval q((($t) != ( &bus_dma_tag_t)0));
    }' unless defined(&BUS_DMA_TAG_VALID);
    eval 'sub vaxbus_dma_get_tag {
        my($t, $b) = @_;
	    eval q((*($t)-> &_get_tag)($t, $b));
    }' unless defined(&vaxbus_dma_get_tag);
    eval 'sub bus_dmamap_create {
        my($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        my($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        my($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        my($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        my($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        my($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        my($t, $p, $o, $l, $ops) = @_;
	    eval q((*($t)-> &_dmamap_sync)(($t), ($p), ($o), ($l), ($ops)));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        my($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        my($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        my($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        my($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        my($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    eval 'sub bus_dmatag_subregion {
        my($t, $mna, $mxa, $nt, $f) = @_;
	    eval q( &EOPNOTSUPP);
    }' unless defined(&bus_dmatag_subregion);
    eval 'sub bus_dmatag_destroy {
        my($t) = @_;
	    eval q();
    }' unless defined(&bus_dmatag_destroy);
}
1;
