require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_VAX_CPU_H_)) {
    eval 'sub _VAX_CPU_H_ () {1;}' unless defined(&_VAX_CPU_H_);
    if(defined(&_KERNEL_OPT)) {
	require './vax/opt_gprof.ph';
	require './vax/opt_multiprocessor.ph';
	require './vax/opt_lockdebug.ph';
    }
    eval 'sub CPU_PRINTFATALTRAPS () {1;}' unless defined(&CPU_PRINTFATALTRAPS);
    eval 'sub CPU_CONSDEV () {2;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_BOOTED_DEVICE () {3;}' unless defined(&CPU_BOOTED_DEVICE);
    eval 'sub CPU_BOOTED_KERNEL () {4;}' unless defined(&CPU_BOOTED_KERNEL);
    if(defined(&_KERNEL)) {
	require 'sys/cdefs.ph';
	require 'sys/queue.ph';
	require 'sys/device_if.ph';
	require 'sys/cpu_data.ph';
	require 'machine/mtpr.ph';
	require 'machine/pcb.ph';
	require 'machine/uvax.ph';
	require 'machine/psl.ph';
	eval 'sub enablertclock () {
	    eval q();
	}' unless defined(&enablertclock);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub IPI_START_CNTX () {1;}' unless defined(&IPI_START_CNTX);
	    eval 'sub IPI_SEND_CNCHAR () {2;}' unless defined(&IPI_SEND_CNCHAR);
	    eval 'sub IPI_RUNNING () {3;}' unless defined(&IPI_RUNNING);
	    eval 'sub IPI_TBIA () {4;}' unless defined(&IPI_TBIA);
	    eval 'sub IPI_DDB () {5;}' unless defined(&IPI_DDB);
	    eval 'sub IPI_XCALL () {6;}' unless defined(&IPI_XCALL);
	    eval 'sub IPI_GENERIC () {7;}' unless defined(&IPI_GENERIC);
	    eval 'sub IPI_DEST_MASTER () {-1;}' unless defined(&IPI_DEST_MASTER);
	    eval 'sub IPI_DEST_ALL () {-2;}' unless defined(&IPI_DEST_ALL);
	}
	eval 'sub CPU_RAISEIPL () {1;}' unless defined(&CPU_RAISEIPL);
	if(defined(&__HAVE_FAST_SOFTINTS)) {
	}
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	}
	eval 'sub CI_MASTERCPU () {1;}' unless defined(&CI_MASTERCPU);
	eval 'sub CI_RUNNING () {2;}' unless defined(&CI_RUNNING);
	eval 'sub CI_STOPPED () {4;}' unless defined(&CI_STOPPED);
	eval 'sub curcpu () {
	    eval q(( ($curlwp->{l_cpu}) + 0));
	}' unless defined(&curcpu);
	eval 'sub curlwp () {( &mfpr( &PR_SSP));}' unless defined(&curlwp);
	eval 'sub cpu_number () {
	    eval q(( &curcpu()-> &ci_cpuid));
	}' unless defined(&cpu_number);
	eval 'sub cpu_need_resched {
	    my($ci, $l, $flags) = @_;
    	    eval q( &do { \'struct pcb\' * &pcb =  &lwp_getpcb( &curlwp);  &__USE($flags);  ($pcb->{P0LR}) = ( ($pcb->{P0LR}) & ~ &AST_MASK) |  &AST_ON;  &mtpr( &AST_OK, &PR_ASTLVL); }  &while ( 0));
	}' unless defined(&cpu_need_resched);
	eval 'sub cpu_proc_fork {
	    my($x, $y) = @_;
    	    eval q( &do { }  &while ( 0));
	}' unless defined(&cpu_proc_fork);
	eval 'sub cpu_intr_p {
	    my($void) = @_;
    	    eval q({  &register_t  &psl;  &__asm(\\"movpsl %0\\" : \\"=g\\"( &psl)); ( &psl &  &PSL_IS) != 0; });
	}' unless defined(&cpu_intr_p);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub CPU_IS_PRIMARY {
	        my($ci) = @_;
    		eval q((($ci)-> &ci_flags &  &CI_MASTERCPU));
	    }' unless defined(&CPU_IS_PRIMARY);
	    eval 'sub CPU_INFO_ITERATOR () {\'int\'  &__unused;}' unless defined(&CPU_INFO_ITERATOR);
	    eval 'sub CPU_INFO_FOREACH {
	        my($cii, $ci) = @_;
    		eval q($ci =  &SIMPLEQ_FIRST( &cpus); $ci !=  &NULL; $ci =  &SIMPLEQ_NEXT($ci,  &ci_next));
	    }' unless defined(&CPU_INFO_FOREACH);
	}
	eval 'sub cpu_signotify {
	    my($l) = @_;
    	    eval q( &do { \'struct pcb\' * &pcb =  &lwp_getpcb($l);  ($pcb->{P0LR}) = ( ($pcb->{P0LR}) & ~ &AST_MASK) |  &AST_ON;  &mtpr( &AST_OK, &PR_ASTLVL); }  &while ( 0));
	}' unless defined(&cpu_signotify);
	eval 'sub cpu_need_proftick {
	    my($l) = @_;
    	    eval q( &do { \'struct pcb\' * &pcb =  &lwp_getpcb($l); ($l)-> &l_pflag |=  &LP_OWEUPC;  ($pcb->{P0LR}) = ( ($pcb->{P0LR}) & ~ &AST_MASK) |  &AST_ON;  &mtpr( &AST_OK, &PR_ASTLVL); }  &while ( 0));
	}' unless defined(&cpu_need_proftick);
	eval 'sub IOSPSZ () {((64*1024) /  &VAX_NBPG);}' unless defined(&IOSPSZ);
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q( &cpu_lwp_pc($l));
	}' unless defined(&LWP_PC);
	require 'sys/lwp.ph';
	if(defined(&MULTIPROCESSOR)) {
	}
	if(defined(&DDB)) {
	}
    }
    if(defined(&_STANDALONE)) {
    }
}
1;
