/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import java.io.IOException;
import org.campagnelab.goby.counts.CountsWriterHelperI;
import org.campagnelab.goby.counts.CountsWriterI;

public class CountWriterHelper
implements CountsWriterHelperI {
    private final CountsWriterI delegate;
    private int previousCount;
    private int accumulatedLength = 0;
    private int previousPosition = 0;
    private boolean firstAppend;

    public CountWriterHelper(CountsWriterI delegate) {
        this.delegate = delegate;
        this.firstAppend = true;
    }

    @Override
    public void appendCountAtPosition(int count, int position) throws IOException {
        System.out.printf(" count=%d position=%d previousCount=%d length-constant=%d %n", count, position, this.previousCount, this.accumulatedLength);
        if (this.firstAppend && count != this.previousCount) {
            this.accumulatedLength = position;
            if (this.accumulatedLength != 0) {
                this.delegate.appendCount(0, this.accumulatedLength);
                this.accumulatedLength = 1;
                this.firstAppend = false;
                this.previousPosition = position;
                this.previousCount = count;
                return;
            }
        }
        if (this.firstAppend || count != this.previousCount && this.previousPosition == position - 1) {
            if (this.accumulatedLength > 0) {
                this.delegate.appendCount(this.previousCount, this.accumulatedLength);
                this.previousCount = count;
                this.previousPosition = position;
                this.accumulatedLength = 1;
            }
        } else if (this.previousPosition == position - 1) {
            ++this.accumulatedLength;
        } else if (this.accumulatedLength > 0) {
            this.delegate.appendCount(this.previousCount, this.accumulatedLength);
            this.accumulatedLength = position - this.previousPosition - 1;
            this.previousCount = 0;
            this.delegate.appendCount(0, this.accumulatedLength);
            this.previousCount = count;
            this.accumulatedLength = 1;
        }
        this.previousPosition = position;
        this.firstAppend = false;
    }

    @Override
    public void close() throws IOException {
        this.delegate.appendCount(this.previousCount, this.accumulatedLength);
        if (this.previousCount != 0) {
            this.delegate.appendCount(0, 1);
        }
        this.delegate.close();
    }
}

