package TDS::RequestMode;
# $Id: RequestMode.pm,v 1.4 2000/12/03 20:55:23 tom Exp $
################################################################

use strict;
use vars qw(@ISA @EXPORT);
use Exporter;

use ObjectTemplate;
use CGI::QueryString;

@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes);

attributes qw(mode year month day_part topic);

################################################################
sub GetMode ($;$$)
{
    my ($self, $query, $now) = @_;

    require DateTime::Time;
    
    # default start_time is now
    unless (ref $now){
	$now = new DateTime::Time;
	$now->SetTime(time(), $TDS::System::TZ);
    }
    unless ($query){
	$query = param('keywords');
    }
    
    # check the mode
    if (param('keyword')){            # Search
	$self->mode('SEARCH');
	my ($year, $month) = split("/", param('year_month'));
	$self->year($year || $now->year);
	$self->month($month || $now->month);
	$self->day_part(param('part'));
    } elsif ($query =~ /^(\d{4})(\d{2})([abc]?)$/){
	if ($1 > 1900){               # ?YYMM[abc] : month, part
	    $self->year($1);
	    $self->month($2);
	    if ($3){
		$self->day_part($3);
		$self->mode('PART');
	    } else {
		$self->day_part(undef);
		$self->mode('MONTH');
	    }
	}
    } elsif ($query =~ /^(\d{4})(\d{2})(\d)$/){
	if ($1 > 1900){               # ?YYMMD 
	    $self->year($1);
	    $self->month($2);
	    my @tmp = qw(a b c c);
	    $self->day_part($tmp[$3]);
	    $self->mode('DAYS');
	}
    } elsif ($query =~ /^(\d{4})(\d{2})(\d{2})$/){
	if ($1 > 1900){               # ?YYMMDD
	    $self->year($1);
	    $self->month($2);
	    $self->day_part($3);
	    $self->mode('DAY');
#	    param('command', 'title')    #??? for i-mode ?
#		unless param('command');
	}
    } elsif ($query =~ /^(\d{4})(\d{2})(\d{2})\-(\d+)$/){
	if ($1 > 1900){               # ?YYMMDD-T
	    $self->year($1);
	    $self->month($2);
	    $self->day_part($3);
	    $self->topic($4);
	    $self->mode('TOPIC');
	    # disable cache in topic specification
	    $TDS::Cache::EnableCache = 0;
	}
    } elsif ($query =~ /^(\d{4})(\d{2})(\d{2})R$/){ # pseudo recent
	    $self->year($1);
	    $self->month($2);
	    $self->day_part($3);
	    $self->mode('PSEUDO_RECENT');
    } elsif ($query =~ /^(\d{2})(\d{2})$/){    # n-year
	$self->year($now->year);
	$self->month($1);
	$self->day_part($2);
	$self->mode('N_YEAR');
    } elsif (param('year_month')){    # from jump
	my ($year, $month) = split("/", param('year_month'));
	$self->year($year);
	$self->month($month);
	my $part = param('part');
	if ($part){
	    $self->day_part($part);
	    $self->mode('PART');
	} else {
	    $self->day_part(undef);
	    $self->mode('MONTH');
	}
    }
    # regard as recent
    unless ($self->mode) {
	$self->year($now->year);
	$self->month($now->month);
	$self->day_part($now->day);
	$self->mode('RECENT');
    }
    return $self->mode;
}
1;
