%%%%%%%%%%%%%%%%%%%%%%%%% rel.p %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%			JPSG parser ver1.3
%%%			    1992.6.6
%%%		       JPSG Parser Sample
%%%            1995.12  commented by John Fry (ETL)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%  Category :
%%%	{core/{pos/Pos, form/Form, asp/View}, 
%%	  ajc/Adjacent, sc/Subcat, ajn/Adjoin, 
%%	  psl/PSlash, slash/Slash, refl/Refl, sem/Sem (,temp/Temp)}
%%% Pos: part of speech   p,n,v,vs(sahen-dousi),adn(rentai-si),adv(fuku-si)
%%% Form: when Pos=n, n,ns(sahen-meisi)
%%%	  when Pos=v, vv,vk,vcw,... (verb form), 
%%%		   adj(adjective), na(adjective-verb)
%%% Temp: Temp feature for proto-lexicon

%% write_dl(L1,L2):-write("["),w_dl(L1,L2),write("]").
%% w_dl(X,X).
%% w_dl([A|L1],L2):-write(A),write(" "),w_dl(L1,L2).

%%%  Left Corner Parser
p2(S):-parse0(A,B,S,[],[idx(s,speaker)]),write(A),nl,pcon,nl.
p(Sentence):-
	parse0(Cat,H,Sentence,[],[idx(s,speaker)]),nl,
	tree(H),nl,
	write("category= "),write(Cat),nl,
	write("constraint= "),project_cstr(Cat),nl.

nil_or_speaker([]).
nil_or_speaker([{sem/speaker}]).

parse0(MCat,MHist,Str,Rest,Idxlist):-
	lookup(Str,SubStr,Cat,Hist,Idxlist,Nidx),!,
	parse1(Cat,Hist,MCat,MHist,SubStr,Rest,Nidx).

parse1(LCat,LHist,GCat,GHist,[Word|SubStr],Rest,Idxlist):-
	lookup_post(LCat,Word,RCat,RHist,RuleName),
	psr_adj(LCat,RCat,MCat),
	parse1(MCat,
		t(t(MCat,RuleName,[]),LHist,RHist),
		GCat,GHist,SubStr,Rest,Idxlist).

parse1(Cat,H,Cat,H,Str,Str,N).

parse1(LCat,LHist,GCat,GHist,Str,Rest,Idxlist):-
	psr(LCat,RCat,MCat,RN),
	parse0(RCat,RHist,Str,SubStr,Idxlist),
	parse1(MCat,t(t(MCat,RN,[]),LHist,RHist),
		GCat,GHist,SubStr,Rest,Idxlist).

%%%  phrase structure rules
%%%     psr(LeftCat,RightCat,MotherCat)

%%% 1. Adjacent Structure:  psr_adj(Left,Head,Mother)
psr_adj({core/Cc,sc/Csc,refl/Cref,slash/Csl,psl/Cpsl,sem/SEM0,ajn/[]},
    {core/Hc,ajc/[{core/Cc,sc/Asc,refl/ReflAC,sem/SEM0}],
      ajn/Adj, sc/Hsc, refl/Href, slash/Hsl, sem/SEM},
    {core/Hc,ajc/[],ajn/Adj,sc/Msc,refl/Mref,slash/Msl,psl/Cpsl,
	sem/SEM});
	adjacent_sc_p(Csc,Asc,Hsc,Msc),
	slash_p(Csl,Hsl,Msl),
	refl_cond(Cref,Href,Mref,Hsc).

%%% slash feature principle: 
%%%	slash_p(LeftS,RightS,MotherS)
%%%	LeftS=C.slash, RightS=H.slash, MotherS=M.slash
slash_p([],[],[]).
slash_p([S],[],[S]).
slash_p([],[S],[S]).
slash_p([S],[RS],[RS]):-sem_unify(S,RS).
sem_unify({sem/X},{sem/X}).

%%  adjacent-subcat principle for adjacent structure
%% adjacent_sc_p(CSC,ASC,HSC,MSC).
%%	CSC=C.sc, ASC=H.ajc.sc, HSC=H.sc, MSC=M.sc
%% adjacent_sc_p(CSC,[],HSC,MSC):-merge(CSC,HSC,MSC).
adjacent_sc_p([],[],SC,SC).
adjacent_sc_p([SC|R],[],[],[SC|R]).
adjacent_sc_p(CSC,[AS],HSC,SC):-one_of(CSC,AS,Rest),append(HSC,Rest,SC).
adjacent_sc_p([A1,A2|R],[A1,A2],SC,MSC):-append(SC,R,MSC).  /* for ukemi */

%%%	2. relative clause structure : psr(R,H,M)
psr({core/{form/rel},sc/Rsc,slash/Rsl,psl/Rps,sem/Rs,ajc/[],ajn/[]},
    {core/Hc,ajc/Ha,slash/Hsl,sem/Hs},
    {core/Hc,sc/[],slash/Msl,psl/[],sem/[Hs,Rs]},[relative_s]);
	{pos/n}=Hc,sc_sl(Rsc,Rsl,Rps,Ha,Hsl,Msl,Hs).

sc_sl([],[{sem/Hsm}],Rps,[],Hsl,Msl,Hsm):-slash_p(Rps,Hsl,Msl).
sc_sl([],Rsl,Rps,[{core/{form/rel}}],Hsl,Msl,Hsm):-sl_psl_p(Rsl,Hsl,Msl,Rps).
sc_sl([{sem/Hsm}],[Rsl],Rps,[],Hsl,Msl,Hsm):-sl_psl_p([Rsl],Hsl,Msl,Rps).

%% sl_psl_p(Csl,Hsl,Msl,Psl)
sl_psl_p([],[],[P],[P]).
sl_psl_p(Csl,Hsl,Msl,[]):-slash_p(Csl,Hsl,Msl).
sl_psl_p(Csl,Hsl,Msl,[{sem/X}]):-slash_p(Csl,Hsl,[{sem/X}]).

%%%	3. Subcategorization Structure : psr(C,H,M)
psr(Comp,
    {core/Hc, ajn/Hn, ajc/Hac, sc/HC, refl/Hr, slash/Hsl, sem/Hs},
    {core/Hc, ajn/Hn, ajc/Hac, sc/Rest, refl/Mr, slash/Msl,psl/Cps,sem/Hs},
	[subcat_p] );
	{core/Cc, ajc/[], refl/Cr,slash/Csl,psl/Cps, ajn/[]}=Comp,
	one_of(HC,Comp,Rest),
	slash_p(Csl,Hsl,Msl),
	refl_cond(Cr,Hr,Mr,Rest),
	sc_cond(Cc,Hc).

sc_cond({pos/p},{pos/v}).
sc_cond({pos/adn},{pos/n}).

refl_cond([],[],[],Rt).
refl_cond([],[Cat],[Cat],Rt).
refl_cond([Cat],[],[Cat],Rt).
refl_cond([Cat],[],[],SC) :- memb3(Cat,SC).

%%%	4. Adjunction Structure: psr(An,H,M)
psr({core/_,ajn/[Head], slash/Asl,refl/ReflA,psl/Apsl,sem/As},
    Head,
    {core/C,ajn/A,ajc/[],sc/Hsc,slash/Msl,refl/ReflM,psl/Apsl,sem/As},
	[adjunct_p] );
	{core/C,ajn/A,ajc/[],sc/Hsc,slash/Hsl,refl/ReflH,sem/Hs}=Head,
	refl_cond(ReflA,ReflH,ReflM,Hsc),
	slash_p(Asl,Hsl,Msl).

%%%%%	lexical rule (for general dictionary)
%%% lex_rule(OrigCat,NewCat)
lex_rule(C,Cat):-
	same_feature(C,Cat),
	sc_to_sl(C,Cat),default(Cat,{},{ajc/[],ajn/[],refl/[]}).

%% core,sem
same_feature({core/C,sem/S},{core/C,sem/S}).

%% adjacent default(defaul value is [], if it is not specified)
%% ajc_default({ajc/[]},{ajc/[]}):-!.
%% ajc_default({ajc/X},{ajc/X}).

%% adjoin default(defaul value is [], if it is not specified)
%% ajn_default({ajn/[]},{ajn/[]}):-!.
%% ajn_default({ajn/X},{ajn/X}).

%% refl default(defaul value is [], if it is not specified)
%% refl_default({refl/[]},{refl/[]}):-!.
%% refl_default({refl/X},{refl/X}).

%% sc,slash (subcat to slash movement, sc,slash,psl default) 
sc_to_sl({sc/[]},{sc/[],slash/[],psl/[]}):-!.
sc_to_sl({sc/S},{sc/Nsc,slash/Nsl,psl/[]});sc_sl_move(S,Nsc,Nsl).
sc_sl_move(Sc,Sc,[]).
sc_sl_move(Sc,Nsc,[{sem/Sl}]):-one_of(Sc,{sem/Sl},Nsc).

%% temp,asp (temp to aspect conversion, asp default)
%% temp_to_asp({temp/[]},{core/{asp/[]}}):-!.
%% temp_to_asp({temp/t(S,F,R,DSF,DRF)},{core/{view/asp(AB,AE,AD,AT)}});
%%	temp_cstr(S,F,R,DSF,DRF,AB,AE,AD,AT).
temp_cstr(S,F,T0,DSF,T1,S,F,DSF,basic).
temp_cstr(T0,F,R,T1,f,F,R,f,result).
temp_cstr(T0,F,T1,T2,T3,F,i,i,exp).
temp_cstr(T0,T1,R,T2,f,R,i,i,exp).

%%%%%	general dictionary
%%%%%  lookup(Str,RestStr,Cat,Hist,OldIdx,NewIdx)
%%%%%  lookup([nil|X],X,_,_):-fail,!.
%%lookup([idx([Sent|Cont],I)|X],X,Cat,Hist):-
%%	parse0(Cat,Hist,[Sent|Cont],[]).
lookup([idx(Word,I)|X],X,Cat,t(Cat,[Word,I],[]),OldIdx,OldIdx)
	:-member(idx(I,Sem),OldIdx),!,
%%	write("lookup "),write(idx(I,Sem)),write(" in "),write(OldIdx),nl,
	dict1(Word,C),lex_rule(C,Cat);{sem/Sem}=Cat.
lookup([idx(Word,I)|X],X,Cat,t(Cat,[Word,I],[]),OldIdx,[idx(I,Sem)|OldIdx])
	:-!,
	dict1(Word,C),lex_rule(C,Cat);{sem/Sem}=C.
lookup([[Sent|Cont]|X],X,Cat,Hist,Idx,Idx):-
	parse0(Cat,Hist,[Sent|Cont],[],Idx).
lookup([Word|X],X,Cat,t(Cat,[Word],[]),Idx,Idx)
	:-dict1(Word,C),lex_rule(C,Cat).

%%%%%	pp, suffix, auxiliary verb dictionary
%%%%%	lookup_post(PreCat, Word, PostCat, PostHist,RuleName)
lookup_post({core/{pos/v,form/Form}},Word, Cat,t(Cat,[Word],[]),[suff_p])
	:-search_suffix(Form,Word,Cat);
	{slash/[],psl/[],refl/[]}=Cat.
lookup_post(_,Word,Cat,t(Cat,[Word],[]),[adjacent_p])
	:-dict_pos(Word,Cat);
	{slash/[],psl/[],refl/[]}=Cat.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%	jconst.p 
%%%%%%%%%  constraints
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%	general constraint	   %%%
%%%  constraint  (finite predicate)

%%% one_of(List, One, Rest)    |List|<=3  
one_of([X|Y],X,Y).
one_of([X,Y|Z],Y,[X|Z]).
one_of([X,Y,Z],Z,[X,Y]).

%%% member(X,List)	|List|<=3
memb3(X,[X|Y]).
memb3(X,[Y,X|Z]).
memb3(X,[Y,Z,X]).

%%% finite permutation 
perm2([A,B],[A,B]).
perm2([A,B],[B,A]).
perm3([A,B,C],[A|X]):-perm2([B,C],X).
perm3([A,B,C],[B|X]):-perm2([A,C],X).
perm3([A,B,C],[C|X]):-perm2([A,B],X).

%%%%%%%  constraint (recursive predicate)
merge([],[],[]).
merge([],[A|X],[A|X]).
merge([A|X],[],[A|X]).
merge([A|X],[B|Y],[A|Z]):-merge(X,[B|Y],Z).
merge([B|X],[A|Y],[A|Z]):-merge([B|X],Y,Z).

append([],X,X).
append([A|X],Y,[A|Z]):-append(X,Y,Z).

member(X,[X|Y]).
member(X,[Y|Z]):-member(X,Z).

%%%%%%%%%%%%% sahen constraint %%%%%%%%%%%%%%%%%%%
su_handler(Adjacent,v_su,[],SC,Sem) :-
      suru(Adjacent,SC,Sem).
su_handler([{core/{pos/v,form/vcs},ajc/[],ajn/[],sc/[],sem/Sem}],
		Form,[],[],Sem).

suru([{core/{pos/n,form/ns},sc/Subc,sem/[Pred|SRest]}],
	SC,[Pred|SRest]):- suru_correspond(SRest,Subc,SC).
suru([],[{core/{pos/p,form/wo},
		sc/[{core/{pos/adn,form/ga},refl/RF,sem/Sbj}|Sc],
	refl/RF,sem/[Pred,Sbj,Obj|SRest]}|SC],
	[Pred,Sbj,Obj|SRest] ):-
       suru_correspond([Sbj|SRest],
	[{core/{pos/adn,form/ga},refl/RF,sem/Sbj}|Sc],SC).
suru([],
	[{core/{pos/p,form/ga},refl/RF,sem/Sbj},
	{core/{pos/p,form/wo}, 
		sc/[{core/{pos/adn,form/ga},refl/RF,sem/Sbj}|SC],
		sem/[Pred,Sbj,Obj|SRest]}|SC],
     BR,RF,[Pred,Sbj,Obj|SRest]) :- suru_correspond(SRest,Sc,SC).

suru_correspond([],[],[]).
suru_correspond([Sbj], [{core/{form/F},sem/Sbj}], 
	[{core/{pos/p,form/F},sem/Sbj}]).
suru_correspond([Sbj,Obj], 
	[{core/{form/FO},sem/Obj},{core/{form/FS},sem/Sbj}], 
	[{core/{pos/p,form/FS},sem/Sbj},{core/{pos/p,form/FO},sem/Obj}]).
suru_correspond([Sbj,Obj,Iob],
	[{core/{form/FO},sem/Obj},
	{core/{form/FI},sem/Iob},{core/{form/FS},sem/Sbj}],
	[{core/{pos/p,form/FS},sem/Sbj},
	{core/{pos/p,form/FI},sem/Iob},
	{core/{pos/p,form/FO},sem/Obj}]).

adn_2([{core/{pos/adn,form/First},sem/Obj},
	{core/{pos/adn,form/Second},sem/Sbj}],
	First,Second,Obj,Sbj).
adn_2([{core/{pos/adn,form/First},sem/Obj},
	{core/{pos/adn,form/Second},sem/Sbj}],
	Second,First,Obj,Sbj).

adn_wo_ga(SC,Obj,Sbj):-adn_2(SC,wo,ga,Obj,Sbj).

adn_1([{core/{pos/adn,form/First},sem/Sem}],Form,Sem).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%		post.p	
%%%	PP, aux , etc.   (have ADJACENT feature)
%%%	dict_pos( 1word, Cat)		: pp, aux, etc.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%	Post Positions
dict_pos(nado,
       	{core/{pos/n,form/Form},ajn/[],sc/[],
	ajc/[{core/{pos/n,form/Form},sc/[],sem/SEM}],sem/etc(SEM)} ).

%%%%%   Postpositional particles (joshi)	%%%%%%%%%%%%%%%%%%%%
%%%  --wo,ga,ni,de,to,no,ha,ba
general_pp(Form,
	{core/{pos/p,form/Form},ajn/[],sc/[],
	ajc/[{core/{pos/n},sc/[],sem/SEM}],sem/SEM} ).
dict_pos(wo, Cat):-general_pp(wo, Cat).
dict_pos(ga, Cat):-general_pp(ga, Cat).
dict_pos(ni, Cat):-general_pp(ni, Cat).

dict_pos(de,
	{core/{pos/adn,form/de},sc/[],
	ajc/[{core/{pos/n},sc/[],sem/SEM1}],
	ajn/[{core/{pos/v},sem/SEM2}],sem/de(SEM1,SEM2)} ).

dict_pos(to,
	{core/{pos/Pos,form/to},sc/[],
	ajc/[{core/{pos/Cat1,form/Form},sc/[],sem/SEM1}],
	ajn/[{core/{pos/Cat2},sem/SEM2}], sem/SEM} );
	to_compl(Pos,Cat1,Form,SEM1,Cat2,SEM2,SEM).

to_compl(adj,n,_,S1,v,S2,[with(S1)|S2]).
to_compl(adn,n,_,S1,n,S2,[S1,and|S2]).
to_compl(adj,v,Inf,S1,v,S2, [with,S1,S2] ):-sentence_end(Inf).
sentence_end(inf).
sentence_end(a_inf).
to_compl(adj,v,imp,S1,nil,S2,S1).

dict_pos(no,
       {core/{pos/adn,form/Form},sc/[],
	ajc/[{core/{pos/CP,form/CF},sc/[],sem/CS}],ajn/Adjoin,sem/SEM} );
	no_handler(CP,CF,Form,Adjoin,CS,SEM).

no_handler(p,Form,Form,[],Sem,Sem):-
    with_case(Form).
no_handler(n,n,no,
	[{core/{pos/n,form/n},ajc/[],ajn/[],sc/[],sem/inst(Obj,Type)}],
           Atr,inst(Obj,[rel,Atr,Type])).
%%no_handler(n,n,Form,[],Sem,Sem):-
%%    without_case(Form).

dict_pos(ha,
       {core/{pos/p,form/Form},ajn/[],sc/[],
	ajc/[{core/{pos/Cat,form/F},sc/[],sem/SEM}],sem/SEM} );
       wa_compl(Cat,F,Form).

wa_compl(p,Form,Form):-with_case(Form).
wa_compl(n,_,Form) :- without_case(Form).

with_case(to).
with_case(he).
with_case(ni).
with_case(no).

without_case(ga).
without_case(wo).

dict_pos(mo,
       {core/{pos/p,form/Form},ajn/[],sc/[],
	ajc/[{core/{pos/Cat,form/F},sc/[],sem/SEM}],sem/SEM} );
	       mo_compl(Cat,F,Form).

mo_compl(p,wo,wo).
mo_compl(n,F,ga).
mo_compl(p,Form,Form):-with_case(Form).

%%%%%%% general constraint
v_renyou(conj).
v_renyou(vv).
v_renyou(v_y).
v_renyou(v_si).
inf_form(inf).
inf_form(a_inf).

%%%%%%%%%%%%%%% fuku-joshi
%%%%%%%---ba,temo,demo,te,de,tari,dari,shi

dict_pos(ba,
	{core/{pos/adv,form/katei},sc/[],
	ajc/[{core/{pos/v,form/katei},sc/[],sem/SEM1}],
	ajn/[{core/{pos/v},ajc/[],ajn/[],sem/SEM2}],
	sem/if(SEM1,SEM2) } ).

%%%%	--temo,demo  (even if)
temo_demo(Form,
	{core/{pos/adj,form/temo},sc/[],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/SEM1}],
	ajn/[{core/{pos/v},ajc/[],ajn/[],sem/SEM2}],
	sem/even_if(SEM1,SEM2) } ).
dict_pos(temo,Cat):-temo_demo(Form,Cat);te_form(Form).
dict_pos(demo,Cat):-temo_demo(Form,Cat);demo_form(Form).
demo_form(conj_de).
demo_form(na).

%%%%%   --te, de      + iru,miru, etc. 
te_de(Form,
	{core/{pos/v,form/conj2},sc/[],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/SEM}],sem/SEM} ).
dict_pos(te,Cat):-te_de(Form,Cat);te_form(Form).
dict_pos(de,Cat):-te_de(conj_de,Cat).
te_form(vv).
te_form(v_y).
te_form(conj_te).
te_form(v_si).

%%%%	--tari,dari  
tari_dari(Form, 
	{core/{pos/adj,form/tari},sc/[],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/SEM1}],
	ajn/[{core/{pos/vs},ajc/[],ajn/[],sem/SEM2}],
	sem/[SEM1|SEM2]} ).

dict_pos(tari,Cat):-tari_dari(Form,Cat);te_form(Form).
dict_pos(dari,Cat):-tari_dari(conj_de,Cat).

%%%%	--shi    (--shi,--shi)
dict_pos(shi,
%       {core/{pos/adj,form/and},sc/[],       (J.Fry)
       {core/{pos/adj,form/adn},sc/[],        
	ajc/[{core/{pos/v,form/Form},sc/[],sem/SEM1}],
	ajn/[{core/{pos/v,form/Form},ajc/[],ajn/[],sc/[],sem/SEM2}],
	sem/[SEM1|SEM2] } );
	inf_form(Form).

%%%%%%%%%%% weak verbs  
%%%%%	--(te/de)iru,iku,kuru,miru,shimawu: stative verbs
stative_verb(F,
	{core/{pos/v,form/F},ajn/[],sc/[],
	ajc/[{core/{pos/v,form/conj2},sc/[],sem/Sem}],sem/[stative|Sem]}).
dict_pos(i,Cat):-stative_verb(vv,Cat).
dict_pos(ik,Cat):-stative_verb(vck,Cat).
dict_pos(k,Cat):-stative_verb(vk,Cat).
dict_pos(mi,Cat):-stative_verb(vv,Cat).
dict_pos(shimaw,Cat):-stative_verb(vcw,Cat).

%%%%	--dasu,kakeru,hajimeru,owaru,tuzukeru :v(renyou) + v  sub-verb
sub_verb(F,A,
	{core/{pos/v,form/F},ajn/[],sc/[],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/Sem}],sem/[A|Sem]} );
%		tai_set(Form).    (J.Fry 95.12)
		v_renyou(Form).
dict_pos(das,Cat):-sub_verb(vcs,begin,Cat).
dict_pos(kake,Cat):-sub_verb(vv,nearly,Cat).
dict_pos(hajime,Cat):-sub_verb(vv,begin,Cat).
dict_pos(owar,Cat):-sub_verb(vcr,end,Cat).
dict_pos(tuzuke,Cat):-sub_verb(vv,continue,Cat).

%%%%%%%%%%%%%   Auxiliary verbs (jyo-doushi)	%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% 	--seru, --saseru : Causative verb (shieki)
shieki_verb(Form, 
	{core/{pos/v,form/vv},ajn/[],
	ajc/[{core/{pos/v,form/Form},sc/[{core/{pos/p,form/ga},sem/Iob}],
		sem/Act}],
	sc/[{core/{pos/p,form/ga},sem/Sbj},
	    {core/{pos/p,form/ni},sem/Iob}],
	sem/[cause,Sbj,Iob,Act]} ).

dict_pos(sase,Cat):-shieki_verb(Form,Cat);sara_set(Form).
dict_pos(se,Cat):-shieki_verb(Form,Cat);sere_set(Form).
sara_set(vv).
sara_set(vk). 
sere_set(vc_m).
sere_set(v_sa).

%%%%%	--re(ru), --rare(ru) : Passive verb (ukemi)
dict_pos(rare,Cat):-ukemi_verb(Form,Cat);sara_set(Form).
dict_pos(re,Cat):-ukemi_verb(Form,Cat);sere_set(Form).

ukemi_verb(Form,
       {core/{pos/v,form/vv},ajn/[],
	ajc/[{core/{pos/v,form/Form},
		sc/[{core/{pos/p,form/ga},sem/Agt},
		    {core/{pos/p,form/F},sem/Pat}],
		sem/Act}],
	sc/[{core/{pos/p,form/ga},sem/Pat},{core/{pos/p,form/ni},sem/Agt}],
	sem/[passive,Pat,Agt,Act]} );
	obj_case(F).

control_passive([],Sbj,[]).
control_passive(
	[{core/{pos/p,form/Form},ajc/[],ajn/[],sc/[],sem/Sbj}|Rest],
	Sbj,Rest):-obj_case(Form).

obj_case(ni).
obj_case(wo).

%%% general auxirialy verb (syusi,rentai form & others)
%%%   nu, ta,u,you,mai
aux_syu_ren(Form,A,
       {core/{pos/v,form/Fm},ajn/X,sc/[],sem/Z,
	ajc/[{core/{pos/v,form/Form},sc/Y,sem/Sem}]} );
		syu_ren(Fm,X,Y,Z,[A,Sem]).

aux_verb(Fm,Form,A,
	{core/{pos/v,form/Fm},ajn/[],sc/[],sem/[A,Sem],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/Sem}]}).

%%% rel_clause(Form,HSC,CSC,HAdjoin,Csem,Hsem)
syu_ren(inf,[],[],Z,Z).
syu_ren(rel,[{core/{pos/n},sem/inst(A,B)}],[{core/{pos/p},sem/A}],
		inst(A,[B,Z]),Z).

%%%%%	--na(i),--nu  : Not   
dict_pos(na,Cat):-aux_verb(adj,Form,no,Cat); nai_set(Form).
nai_set(vc_m).
nai_set(vv).
nai_set(vk).
nai_set(v_si).
nai_set(mizen).

dict_pos(nu,Cat):-aux_syu_ren(Form,no,Cat);nu_set(Form).
dict_pos(n,Cat):-aux_syu_ren(Form,no,Cat);nu_set(Form).
dict_pos(zu,Cat):-aux_verb(renyou,Form,no,Cat);nu_set(Form).
dict_pos(ne,Cat):-aux_verb(katei,Form,no,Cat);nu_set(Form).
nu_set(vc_m).
nu_set(vv).
nu_set(vk).
nu_set(v_se).

%%%%%	--ta,da : Past 
dict_pos(ta,Cat):-aux_syu_ren(Form,past,Cat);ta_form(Form).
dict_pos(da,Cat):-aux_syu_ren(conj_de,past,Cat).
dict_pos(tara,Cat):-aux_verb(katei,Form,past,Cat);ta_form(Form).
dict_pos(dara,Cat):-aux_verb(katei,conj_de,past,Cat).

ta_form(adj_tt).
ta_form(na_tt).
ta_form(X):-te_form(X).

%%%%%	--u, --you  : suiryou (guess) or ishi(will)
dict_pos(u,Cat):-aux_syu_ren(Form,may,Cat);u_set(Form).
u_set(vc_o).
u_set(mizen).

dict_pos(you,Cat):-aux_syu_ren(Form,may,Cat);you_set(Form).
you_set(vv).
you_set(vk).
you_set(v_si).

%%%%% --rashii : suitei
dict_pos(rashi,Cat):-aux_verb(adj,Form,polite,Cat);rashii_set(Form).
rashii_set(na).
rashii_set(F):-inf_form(F).

%%%%%%  --mai  : not+guess, not+will
dict_pos(mai,Cat):-aux_syu_ren(Form,no,Cat);mai_set(Form).
mai_set(inf).
mai_set(vv).
mai_set(vk).
mai_set(v_si).

%%%%%%	--ta(i)  : hope
dict_pos(ta,Cat):-aux_verb(adj,Form,hope,Cat);v_renyou(Form).

%%%%%  --sou(da). : may & I hear
dict_pos(sou,Cat):-aux_verb(na,Form,A,Cat); souda_set(Form,A).
souda_set(F,may):-souda_may_set(F).
souda_may_set(F):-v_renyou(F).
souda_may_set(adj).
souda_may_set(na).
souda_set(inf,hear).
souda_set(a_inf,hear).

%%%%%  --desu, masu.	: teinei
desu(Inf,Cat):-aux_verb(Inf,Form,polite,Cat);desu_set(Form).
desu_set(rel).
desu_set(adj).
desu_set(na).
dict_pos(desho,Cat):-desu(vc_o,Cat).
dict_pos(deshi,Cat):-desu(v_y,Cat).
dict_pos(desu,Cat):-aux_syu_ren(Form,polite,Cat);desu_set(Form).
masu(Inf,Cat):-aux_verb(Inf,Form,polite,Cat);v_renyou(Form).
dict_pos(mase,Cat):-masu(v_se,Cat).
dict_pos(masho,Cat):-masu(vc_o,Cat).
dict_pos(mashi,Cat):-masu(v_y,Cat).
dict_pos(masu,Cat):-aux_syu_ren(Form,polite,Cat);v_renyou(Form).
dict_pos(masure,Cat):-masu(katei,Cat).
dict_pos(mase,Cat):-masu(imp,Cat).

%%%%%  --nagara, --tsutsu : cont. adverb
dict_pos(nagara,
       {core/{pos/adv,form/adv},sc/[],
	ajc/[{core/{pos/v,form/Form},sc/[],sem/SEM}],
	ajn/[{core/{pos/v1},ajc/[],ajn/[],sem/SEM1}],
	sem/[with,SEM,SEM1]} );
       nagara_set(Form).
nagara_set(a_inf).
nagara_set(F):-v_renyou(F).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%	suffix.p	%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%	verb suffix 	%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%	search_suffix(Form,Word,Cat)	%%%%%%%%%%%%%%
%%	<< Example >>
%%			mizen/	renyou/	syusi/	rentai/	katei/	imp/
%%
%% vc?	yom-mu		ma	mi	mu	mu	me	me
%%			mo(+u)	n
%% vv	iki-ru		_	_	ru	ru	re	ro
%% vk	kuru		ko	ki	kuru	kuru	kure	koi
%% vs1	tanjyou-suru	si	si	suru	suru	sure	seyo
%%			sa					siro
%%			se
%% vs2	ai-suru		sa	si	suru	suru	sure	seyo
%% adj	haya-i		karo	katt	i	i	kere	_
%%				ku
%% na	kirei-da	daro	datt	da	na	nara	_
%%				de
%%				ni
%%	<< Form Table >>
%% vc?:			vc_m	conj	inf	rel	katei	imp
%% (vck,vcs,vct,vcn,	vc_o	conj_te (k,t,r,w,ik)
%%  vcr,vcw,vcg,vcb,		conj_de (g,n,m,b)
%%  vcik)			
%% vv:			vv	vv	inf	rel	katei	imp
%% vk:			mizen	v_y	inf	rel	katei	imp
%% vs1:			v_si	v_si	inf	rel	katei	imp
%%			v_se
%%			v_sa
%% vs2:			vc_m	v_y	inf	rel	katei	imp
%% adj:			mizen	adj_tt	a_inf	rel	katei	__
%%				adj_ku
%% na:			mizen	na_tt	a_inf	rel	katei	__
%%				na_de
%%				na_ni

%%%	exception
search_suffix(adj,i,
      {core/{pos/v,form/Form},ajn/X,sc/[],sem/Z,
	ajc/[{core/{pos/v,form/adj},sc/Y,sem/Sem}]} );
		syu_ren(Form,X,Y,Z,[neg,Sem]).

search_suffix(na,na,
      {core/{pos/v,form/rel},sc/[],
	ajc/[{core/{pos/v,form/na},
		sc/[{core/{pos/p},ajc/[],ajn/[],sc/[],sem/Obj}],
		sem/Sem}],
	ajn/[{core/{pos/n,form/n},ajc/[],ajn/[],sc/[],sem/inst(Obj,Type)}],
	sem/inst(Obj,[and,Type,Sem])} ).

%%%	suffix search
search_suffix(Fm,Word,
	{core/{pos/v,form/Form},ajn/X,sc/[],sem/Z,
	ajc/[{core/{pos/v,form/Fm},sc/Y,sem/Sem}]} )
	:-suff_s(Word,Fm);syu_ren(Form,X,Y,Z,Sem).

search_suffix(Form2,Word,
	{core/{pos/v,form/Form1},ajn/[],sc/[],
	ajc/[{core/{pos/v,form/Form2},sc/[],sem/Sem}],sem/Sem} )
	:-suff(Word,Form1,Form2).

%%%%%	suffix	-  syusi, rentai
suff_s(su,vcs).
suff_s(nu,vcn).
suff_s(mu,vcm).
suff_s(bu,vcb).
suff_s(ku,vck).
suff_s(ku,vcik).
suff_s(tu,vct).
suff_s(u,vcw).
suff_s(ru,vcr).
suff_s(ru,vv).
suff_s(kuru,vk).
suff_s(suru,vs1).
suff_s(suru,vs2).

%%%%%    Suffix ( mizen, renyou, meirei )

%%%	adj, na	
suff(karo,mizen,adj).
suff(katt,adj_tt,adj).
suff(ku,adj_ku,adj).
suff(daro,mizen,na).
suff(datt,na_tt,na).
suff(de,na_de,na).
suff(ni,na_ni,na).
suff(da,a_inf,na).

%%%	vs, vk	- mizen, renyou
suff(se,v_se,vs1).
suff(si,v_si,vs1).
suff(sa,v_sa,vs1).
suff(si,v_y,vs2).
suff(ko,mizen,vk).
suff(ki,v_y,vk).

%%%	v5 mizen
suff(Suf,vc_m,Inf):-vc_m_suff(Suf,Inf).
vc_m_suff(sa,vcs). 
vc_m_suff(sa,vs2).
vc_m_suff(na,vcn).
vc_m_suff(ma,vcm).
vc_m_suff(ba,vcb).
vc_m_suff(ka,vck).
vc_m_suff(ka,vcik).
vc_m_suff(ta,vct).
vc_m_suff(wa,vcw).
vc_m_suff(ra,vcr).

suff(Suf,vc_o,Inf):-vc_o_suff(Suf,Inf).
vc_o_suff(so,vcs). 
vc_o_suff(so,vs2).
vc_o_suff(no,vcn).
vc_o_suff(mo,vcm).
vc_o_suff(bo,vcb).
vc_o_suff(ko,vck).
vc_o_suff(ko,vcik).
vc_o_suff(to,vct).
vc_o_suff(wo,vcw).
vc_o_suff(ro,vcr).

%%%	v5 renyou
suff(si,v_y,vcs).

suff(Suf,conj,Inf):-vc_conj_suff(Suf,Inf).
vc_conj_suff(ni,vcn).
vc_conj_suff(mi,vcm).
vc_conj_suff(bi,vcb).
vc_conj_suff(wi,vcw).
vc_conj_suff(gi,vcg).
vc_conj_suff(ki,vck).
vc_conj_suff(ki,vcik).
vc_conj_suff(ti,vct).
vc_conj_suff(ri,vcr).

%%%	v5 renyou - onbin
suff(i,conj_te,vck).
suff(i,conj_de,vcg).
suff(t,conj_te,vct).
suff(t,conj_te,vcw).
suff(n,conj_de,vcb).
suff(n,conj_de,vcm).
suff(t,conj_te,vcr).
% suff(n,conj_te,vcn).           sin de, not sin te (FRY)
suff(n,conj_de,vcn).
suff(t,conj_te,vcik).

%%%	katei  ( only  -ba)
suff(Suf,katei,Inf):-suff_ba(Suf,Inf).
suff_ba(se,vcs). 
suff_ba(ne,vcn).
suff_ba(me,vcm).
suff_ba(be,vcb).
suff_ba(ke,vck).
suff_ba(ke,vcik).
suff_ba(te,vct).
suff_ba(we,vcw).
suff_ba(re,vcr).
suff_ba(re,vv).
suff_ba(kure,vk).
suff_ba(sure,vs1).
suff_ba(sure,vs2).
suff_ba(kere,adj).
suff_ba(nara,na).


%%%	meirei
suff(Suf,imp,Inf):-imp_suff(Suf,Inf).
imp_suff(se,vcs). 
imp_suff(ne,vcn).
imp_suff(me,vcm).
imp_suff(be,vcb).
imp_suff(ke,vck).
imp_suff(ke,vcik).
imp_suff(te,vct).
imp_suff(we,vcw).
imp_suff(re,vcr).
imp_suff(ro,vv).
imp_suff(koi,vk).
imp_suff(siro,vs1).
imp_suff(sero,vs1).
imp_suff(seyo,vs2).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%% noun.dic %%%%%%%%%%%%%%%%%%%%%%
%%%%%%% common noun, proper nouns %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%	common nouns.
c_noun(Sem,{core/{pos/n,form/n},sem/inst(Obj,Sem)}).

dict1(ari,Cat):-c_noun(ant,Cat).
dict1(esa,Cat):-c_noun(food,Cat).
dict1(gakusha,Cat):-c_noun(scholar,Cat).
dict1(gyouretsu,Cat):-c_noun(row,Cat).
dict1(hana,Cat):-c_noun(flower,Cat).
dict1(hatarakiari,Cat):-c_noun(worker_ant,Cat).
dict1(hito,Cat):-c_noun(person,Cat).
dict1(hon,Cat):-c_noun(book,Cat).
dict1(ishi,Cat):-c_noun(stone,Cat).
dict1(jimen,Cat):-c_noun(ground,Cat).
dict1(katamari,Cat):-c_noun(block,Cat).
dict1(michi,Cat):-c_noun(road,Cat).
dict1(michishirube,Cat):-c_noun(row,Cat).
dict1(michisuji,Cat):-c_noun(road,Cat).
dict1(mokutekichi,Cat):-c_noun(goal,Cat).
dict1(natsu,Cat):-c_noun(summer,Cat).
dict1(niwa,Cat):-c_noun(garden,Cat).
dict1(satou,Cat):-c_noun(sugar,Cat).
dict1(soto,Cat):-c_noun(out,Cat).
dict1(sumi,Cat):-c_noun(corner,Cat).
dict1(tsubu,Cat):-c_noun(grain,Cat).
dict1(yousu,Cat):-c_noun(yousu,Cat).
dict1(yukute,Cat):-c_noun(way,Cat).

%%%%%%%	proper nouns.
p_noun(Sem,{core/{pos/n,form/n},sem/Sem}).

% dict1(america,Cat):-p_noun(america,Cat).  (Fry)
dict1(amerika,Cat):-p_noun(america,Cat).
dict1(hiroshi,Cat):-p_noun(hiroshi,Cat).
dict1(ken,Cat):-p_noun(ken,Cat).
dict1(naomi,Cat):-p_noun(naomi,Cat).
dict1(wilson,Cat):-p_noun(wilson,Cat).

%%%%% jibun (self)
dict1(jibun, {core/{pos/n,form/n},
	refl/[{core/{pos/p,form/ga},sem/Sem}],
	sem/Sem}).
dict1(jken, {core/{pos/n,form/n},
	refl/[{core/{pos/p,form/ga},sem/ken}],
	sem/ken}).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%  verb.dic		  %%%%%%%
%%%%%%  Verbs except sahen-v	%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% vi (|subcat|==1: --ga)
ga_verb(F,Act, 
	{core/{pos/v,form/F},
	sc/[{core/{pos/p,form/ga},sem/Sbj}],
	sem/[Act,Sbj]}).

%%%%% vt (|subcat|==2:)
%%  --ga --wo
ga_wo_verb(F,Act, 
	{core/{pos/v,form/F},
	sc/[{core/{pos/p,form/ga},sem/Sbj},
	    {core/{pos/p,form/wo},sem/Obj}],
	sem/[Act,Sbj,Obj]}).
%%  --ga --ni
ga_ni_verb(F,Act, 
	{core/{pos/v,form/F},
	sc/[{core/{pos/p,form/ga},sem/Sbj},
	    {core/{pos/p,form/ni},sem/Obj}],
	sem/[Act,Sbj,Obj]}).

%%  --ga --wo --ni
ga_wo_ni_verb(F,Act, 
	{core/{pos/v,form/F},
	sc/[{core/{pos/p,form/ga},sem/Sbj},
	    {core/{pos/p,form/wo},sem/Iob},
	    {core/{pos/p,form/ni},sem/Dob}],
	sem/[Act,Sbj,Iob,Dob]}).

%%% temp feature
%% kiru,akeru
temp1({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,2,f,f,AB,AE,AD,AT).
%% anki-suru
temp2({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,0,f,u,AB,AE,AD,AT).
%% aruku,yomu
temp3({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,2,f,0,AB,AE,AD,AT).
%% matu,damaru
temp4({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,1,1,f,0,AB,AE,AD,AT).
%% suwaru,kekkon-suru
temp5({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,2,0,f,AB,AE,AD,AT).
%% suwaru,sinu
temp6({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,0,0,f,AB,AE,AD,AT).
%% niru,tadayou
temp7({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(0,0,0,0,u,AB,AE,AD,AT).
%% odoroku,tumaduku
temp8({core/{view/asp(AB,AE,AD,AT)}});
	temp_cstr(3,2,2,0,0,AB,AE,AD,AT).

%%% lexical entry
dict1(age,Cat):-ga_wo_ni_verb(vv,give,Cat).
dict1(ai,Cat):-ga_wo_verb(vs2,love,Cat).
dict1(ake,Cat):-ga_wo_verb(vv,open,Cat),temp1(Cat).
% dict1(aruku,Cat):-ga_verb(vck,walk,Cat). (Fry)
dict1(aruk,Cat):-ga_verb(vck,walk,Cat).
dict1(chigaw,Cat):-ga_verb(vcw,differ,Cat).
dict1(chirijirininar,Cat):-ga_verb(vcr,scatter,Cat).
dict1(deki,Cat):-ga_verb(vv,can,Cat).
% dict1(der,Cat):-ga_ni_verb(vv,go_out,Cat).  (Fry)
dict1(de,Cat):-ga_ni_verb(vv,go_out,Cat).
% dict1(hashi,Cat):-ga_verb(vcr,run,Cat). (Fry)
dict1(hashir,Cat):-ga_verb(vcr,run,Cat).
dict1(hazure,Cat):-ga_wo_verb(vv,be_off,Cat).
dict1(i,Cat):-ga_verb(vv,be,Cat).
dict1(ik,Cat):-ga_ni_verb(vck,go_to,Cat).
dict1(isog,Cat):-ga_verb(vcg,hurry,Cat).
dict1(kaer,Cat):-ga_ni_verb(vcr,return,Cat).
dict1(kag,Cat):-ga_wo_verb(vcg,smell_of,Cat).
dict1(kak,Cat):-ga_wo_verb(vck,write,Cat).
dict1(kaw,Cat):-ga_wo_verb(vcw,buy,Cat).
dict1(kawar,Cat):-ga_verb(vcr,lose,Cat).
dict1(kat,Cat):-ga_ni_verb(vct,win,Cat).
% dict1(ker,Cat):-ga_wo_verb(vv,kick,Cat). (Fry)
dict1(ke,Cat):-ga_wo_verb(vv,kick,Cat). 
dict1(ki,Cat):-ga_wo(vv,wear,Cat),temp1(Cat).
dict1(majiwar,Cat):-ga_verb(vcr,cross,Cat).
dict1(manab,Cat):-ga_wo_verb(vcb,learn,Cat).
dict1(mayow,Cat):-ga_verb(vcw,be_lost,Cat).
dict1(mi,Cat):-ga_wo_verb(vv,see,Cat).
dict1(midare,Cat):-ga_verb(vv,be_confused,Cat).
dict1(mitsuke,Cat):-ga_wo_verb(vv,find,Cat).
dict1(mot,Cat):-ga_wo_verb(vct,have,Cat).
% dict1(nar,Cat):-ga_ni_verb(vv,become,Cat). (Fry) 
dict1(na,Cat):-ga_ni_verb(vv,become,Cat). 
dict1(nor,Cat):-ga_ni_verb(vcr,get_on,Cat).
dict1(ok,Cat):-ga_wo_ni_verb(vck,put,Cat).
dict1(omow,Cat):-ga_wo_verb(vcw,think,Cat).
dict1(os,Cat):-ga_wo_verb(vcs,push,Cat).
% dict1(saegi,Cat):-ga_wo_verb(vcr,interrupt,Cat). (Fry)
dict1(saegir,Cat):-ga_wo_verb(vcr,interrupt,Cat).
dict1(sagas,Cat):-ga_wo_verb(vcs,seek,Cat).
dict1(shir,Cat):-ga_wo_verb(vcr,know,Cat).
dict1(shin,Cat):-ga_verb(vcn,die,Cat).
dict1(susum,Cat):-ga_ni_verb(vcm,advance,Cat).
dict1(tador,Cat):-ga_wo_verb(vcr,follow,Cat).
% dict1(tasuker,Cat):-ga_wo_verb(vv,help,Cat). (Fry)
dict1(tasuke,Cat):-ga_wo_verb(vv,help,Cat).
dict1(toor,Cat):-ga_ni_verb(vcr,pass,Cat).
% dict1(tsuger,Cat):-ga_wo_ni_verb(vv,tell,Cat). (Fry)
dict1(tsuge,Cat):-ga_wo_ni_verb(vv,tell,Cat).
dict1(tsuk,Cat):-ga_ni_verb(vck,reach,Cat).
dict1(tsuzuku,Cat):-ga_verb(vck,continue,Cat).
dict1(wakar,Cat):-ga_wo_verb(vcr,understand,Cat).
dict1(yom,Cat):-ga_wo_verb(vcm,read,Cat).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%	sahen.dic
%%%%%	sahen-n,v dictionary
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%	verb : SURU
suru_verb(F,
	{core/{pos/vs,form/F},ajc/Adj,sc/SC,sem/Sem}); 
	suru(Adj,SC,Sem).

dict1(shi,Cat):-suru_verb(v_si,Cat).
dict1(se,Cat):-suru_verb(v_se,Cat).
dict1(sa,Cat):-suru_verb(v_sa,Cat).
dict1(sure,Cat):-suru_verb(katei,Cat).
dict1(shiro,Cat):-suru_verb(imp,Cat).
dict1(sero,Cat):-suru_verb(imp,Cat).

%%%%%   sa-hen verbs (do)
sahen_verb(F,Act,
	{core/{pos/v,form/F},sc/[{core/{pos/p,form/ga},sem/Sbj}],
	sem/[Act,Sbj]} ).
dict1(tanjou,Cat):-sahen_verb(vs1,be_born,Cat).

%%%%%	sa-hen nouns.
%% dict1(chousa,
%%       {pos/n,NFORM,[],[],SC,[],[],Sem} );
%%	sahen_noun(NFORM,investigate,SC,SEM).
%% sahen_noun(n,SEM,[],SEM).
%% sahen_noun(ns,SEM1,SC,[SEM1,Sbj,Obj]):-adn_wo_ga(SC,Obj,Sbj).
dict1(chousa, 
	{core/{pos/n,form/ns},sc/SC,sem/[investigate,Sbj,Obj]} );
	adn_wo_ga(SC,Obj,Sbj).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%   adject.dic
%%%%%	adjective, adjective-verb
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%   Adjectives	%%%%%%%%%%%%%
adjective(A,
	{core/{pos/v,form/adj},
	sc/[{core/{pos/p,form/ga},sem/Obj}],
	sem/[A,Obj]} ).
dict1(aka,Cat):-adjective(red,Cat).
dict1(siro,Cat):-adjective(white,Cat).
dict1(kuro,Cat):-adjective(black,Cat).
dict1(ooki,Cat):-adjective(big,Cat).
dict1(yo,Cat):-adjective(good,Cat).

%%%%%	na (adjective-verb)
ajverb(A,
	{core/{pos/v,form/na},
	sc/[{core/{pos/p,form/ga},sem/Obj}],
	sem/[A,Obj]} ).
dict1(kirei,Cat):-ajverb(beautifle,Cat).
dict1(kaiteki,Cat):-ajverb(comfortable,Cat).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%		etc.dic
%%%%%%%		dictionary of other words
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%% rentai-shi
rentaishi(A,
	{core/{pos/adn, form/adn}, 
	ajn/[{core/{pos/n,form/n},ajc/[],ajn/[],sc/[],sem/SEM}], 
%	sem/[A|SEM]}
	sem/[A|[SEM]]}
).
dict1(sono,Cat):-rentaishi(the,Cat).
dict1(kono,Cat):-rentaishi(this,Cat).
dict1(ano,Cat):-rentaishi(that,Cat).
dict1(ippikino,Cat):-rentaishi(one,Cat).

%%%%%%% fuku-shi (adverb)

adverb(MODIFY, 
	{core/{pos/adv, form/adv}, ajn/[{core/{pos/v},sem/SEM}], 
	sem/[MODIFY|SEM]}).
dict1(yoku,Cat):-adverb(often,Cat).
dict1(zutto,Cat):-adverb(continue,Cat).
dict1(hajimeni,Cat):-adverb(first,Cat).
dict1(sukoshi,Cat):-adverb(slightly,Cat).
dict1(yagate,Cat):-adverb(in_the_end,Cat).
dict1(tsugitsugito,Cat):-adverb(continue,Cat).
dict1(dandanni,Cat):-adverb(gradually,Cat).
dict1(komakani,Cat):-adverb(minutely,Cat).
dict1(kesshite,
%	{core/{pos/adv,form/adv}, ajn/[{core/{pos/v},sem/[not|SEM]}],(Fry)
	{core/{pos/adv,form/adv}, ajn/[{core/{pos/v},sem/[no|SEM]}],
	sem/[never|SEM]}).


%%  Examples
%% ?-p([ken,ga,naomi,wo,ai,suru]).
%% ?-p([ken,ga,naomi,ni,ai,sa,re,ta]).
%%
