/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.filters;

import edu.cornell.med.icb.identifier.IndexedIdentifier;
import java.io.FileNotFoundException;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.filters.AbstractAlignmentEntryFilter;
import org.campagnelab.goby.alignments.filters.BestScoreOnlyAlignmentFilter;
import org.campagnelab.goby.alignments.filters.TranscriptsAlignmentFilter;

public class TranscriptBestScoreAlignmentFilter
extends AbstractAlignmentEntryFilter {
    private final TranscriptsAlignmentFilter transcriptFilter;
    private final BestScoreOnlyAlignmentFilter bestScoreFilter;
    private int notBestScoreCount;
    private int geneAmbiguityCount;
    private int entryCount;
    private final int minQueryIndex;

    @Override
    public void printStats() {
        System.out.printf("notBestScoreCount=%g %% geneAmbiguityCount=%g %% %n", this.div(this.notBestScoreCount, this.entryCount) * 100.0, this.div(this.geneAmbiguityCount, this.entryCount) * 100.0);
    }

    private double div(int a, int b) {
        return (double)a / (double)b;
    }

    public TranscriptBestScoreAlignmentFilter(String geneTranscriptFile, int kVal, int maxNumberOfReads, int minQueryIndex) throws FileNotFoundException {
        this.minQueryIndex = minQueryIndex;
        this.transcriptFilter = new TranscriptsAlignmentFilter(geneTranscriptFile, kVal);
        this.bestScoreFilter = new BestScoreOnlyAlignmentFilter(maxNumberOfReads, minQueryIndex);
    }

    @Override
    public void inspectEntry(Alignments.AlignmentEntry entry) {
        this.bestScoreFilter.inspectEntry(entry);
        this.transcriptFilter.inspectEntry(entry);
    }

    @Override
    public void postProcessing() {
        this.bestScoreFilter.postProcessing();
        this.transcriptFilter.postProcessing();
    }

    @Override
    public boolean shouldRetainEntry(Alignments.AlignmentEntry entry) {
        this.entryCount += entry.getMultiplicity();
        if (!this.bestScoreFilter.shouldRetainEntry(entry)) {
            this.notBestScoreCount += entry.getMultiplicity();
            return false;
        }
        boolean notGeneAmbiguous = this.transcriptFilter.shouldRetainEntry(entry);
        if (!notGeneAmbiguous) {
            this.geneAmbiguityCount += entry.getMultiplicity();
        }
        return notGeneAmbiguous;
    }

    @Override
    public void setTargetIdentifiers(IndexedIdentifier targets) {
        this.transcriptFilter.setTargetIdentifiers(targets);
        this.bestScoreFilter.setTargetIdentifiers(targets);
    }
}

