/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.htsjdk;

import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import edu.cornell.med.icb.identifier.IndexedIdentifier;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import it.unimi.dsi.fastutil.ints.Int2ByteAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.lang.MutableString;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.ReadOriginInfo;
import org.campagnelab.goby.alignments.ReferenceLocation;
import org.campagnelab.goby.readers.sam.ConversionConfig;
import org.campagnelab.goby.readers.sam.ConvertSamBAMReadToGobyAlignment;
import org.campagnelab.goby.readers.sam.SamRecordParser;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTSJDKReaderImpl
implements AlignmentReader {
    private SAMRecordIterator samRecordIterator;
    private int[] targetLengths;
    private String filename;
    @RegisterThis
    public static final DynamicOptionClient doc = new DynamicOptionClient(HTSJDKReaderImpl.class, "force-sorted:boolean, when true, assume all alignments are sorted. When false, check the SO:coordinate flag in the header. Use this option only when you know that each input alignment has been sorted:false");
    private static final Logger LOG = LoggerFactory.getLogger(HTSJDKReaderImpl.class);
    DateFormat dateFormatter = new SimpleDateFormat("dd:MMM:yyyy");
    private boolean sorted;
    private IndexedIdentifier readGroups;
    private SamReader.Indexing index;
    private List<Alignments.ReadOriginInfo> readOriginInfoList = new ArrayList<Alignments.ReadOriginInfo>();
    private int numberOfAlignedReads;
    private int lastPosition = -1;
    private int lastTargetIndex = -1;
    private ConversionConfig config = new ConversionConfig();
    private SamReader parser;
    private ConvertSamBAMReadToGobyAlignment convertReads;
    private IndexedIdentifier targetIds;
    private DoubleIndexedIdentifier reverseTargetIndex2Id;
    final Int2ByteMap queryIndex2NextFragmentIndex;
    private List<Alignments.AlignmentEntry.Builder> builders = new ArrayList<Alignments.AlignmentEntry.Builder>();

    public static final DynamicOptionClient doc() {
        return doc;
    }

    public HTSJDKReaderImpl(String basename, int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) throws IOException {
        this(basename);
        if (!this.parser.hasIndex()) {
            throw new UnsupportedOperationException("Cannot use slices when an alignment is not indexed. Check index file is present: .crai, .bai");
        }
        if (this.samRecordIterator != null) {
            this.samRecordIterator.close();
        }
        int startSamPositionOneBased = startPosition + 1;
        int endSamPositionOneBased = endPosition + 1;
        QueryInterval[] intervals = this.constructQueryIntervals(startReferenceIndex, startSamPositionOneBased, endReferenceIndex, endSamPositionOneBased);
        this.samRecordIterator = this.parser.query(intervals, false);
    }

    public HTSJDKReaderImpl(String basename, long startOffset, long endOffset) {
        throw new UnsupportedOperationException("Currently not implemented");
    }

    private void importReadGroups(SAMFileHeader samHeader, IndexedIdentifier readGroups) {
        if (!samHeader.getReadGroups().isEmpty() && this.config.storeReadOrigin) {
            for (SAMReadGroupRecord rg : samHeader.getReadGroups()) {
                String sample = rg.getSample();
                String library = rg.getLibrary();
                String platform = rg.getPlatform();
                String platformUnit = rg.getPlatformUnit();
                Date date = rg.getRunDate();
                String id = rg.getId();
                int readGroupIndex = readGroups.registerIdentifier(new MutableString(id));
                Alignments.ReadOriginInfo.Builder roi = Alignments.ReadOriginInfo.newBuilder();
                roi.setOriginIndex(readGroupIndex);
                roi.setOriginId(id);
                if (library != null) {
                    roi.setLibrary(library);
                }
                if (platform != null) {
                    roi.setPlatform(platform);
                }
                if (platformUnit != null) {
                    roi.setPlatformUnit(platformUnit);
                }
                if (sample != null) {
                    roi.setSample(sample);
                }
                if (date != null) {
                    roi.setRunDate(this.dateFormatter.format(date));
                }
                this.readOriginInfoList.add(roi.build());
            }
        }
    }

    private int getTargetIndex(IndexedIdentifier targetIds, String sequenceName, boolean thirdPartyInput) {
        int targetIndex = -1;
        targetIndex = targetIds.registerIdentifier(new MutableString(sequenceName));
        return targetIndex;
    }

    public HTSJDKReaderImpl(String basename) throws IOException {
        this.filename = HTSJDKReaderImpl.getFilename(basename);
        InputStream stream = "-".equals(this.filename) ? System.in : new FileInputStream(this.filename);
        File indexFile = new File(this.filename + ".bai");
        boolean indexFileExists = indexFile.exists();
        SamReaderFactory readerFactory = SamReaderFactory.make();
        readerFactory.validationStringency(ValidationStringency.SILENT);
        this.parser = indexFileExists ? readerFactory.open(new File(this.filename)) : readerFactory.open(SamInputResource.of((InputStream)stream));
        this.targetIds = new IndexedIdentifier();
        this.queryIndex2NextFragmentIndex = new Int2ByteAVLTreeMap();
        ObjectArrayList builders = new ObjectArrayList();
        SamRecordParser samRecordParser = new SamRecordParser();
        samRecordParser.setQualityEncoding(this.config.qualityEncoding);
        samRecordParser.setGenome(this.config.genome);
        this.readHeader();
        this.convertReads = new ConvertSamBAMReadToGobyAlignment(this.targetIds, this.readGroups, this.queryIndex2NextFragmentIndex, (ObjectArrayList<Alignments.AlignmentEntry.Builder>)builders, samRecordParser);
        this.convertReads.setConfig(this.config);
        this.samRecordIterator = this.parser.iterator();
    }

    @Override
    public boolean isIndexed() {
        try {
            if (!new File(this.filename + ".bai").exists() && !new File(this.filename + ".crai").exists()) {
                return false;
            }
            return this.parser.indexing() != null && this.parser.indexing().getIndex() != null;
        }
        catch (SAMException e) {
            return false;
        }
    }

    @Override
    public String basename() {
        return FilenameUtils.removeExtension((String)this.filename);
    }

    @Override
    public boolean hasNext() {
        if (this.hasMoreCached()) {
            return true;
        }
        if (this.samRecordIterator.hasNext()) {
            try {
                this.cacheMore(this.samRecordIterator);
            }
            catch (IOException e) {
                LOG.error("Exception caught while iterating " + this.filename, (Throwable)e);
            }
        }
        return this.hasMoreCached();
    }

    private boolean hasMoreCached() {
        return !this.builders.isEmpty();
    }

    private void cacheMore(SAMRecordIterator samRecordIterator) throws IOException {
        do {
            SAMRecord samRecord = null;
            try {
                samRecord = (SAMRecord)samRecordIterator.next();
            }
            catch (NoSuchElementException e) {
                System.out.println("samRecordIterator no next element exception caught");
            }
            if (samRecord != null) {
                ++this.config.numberOfReads;
                this.convertReads.setSamRecord(samRecord);
                this.convertReads.invoke();
                if (!this.convertReads.hasResult()) continue;
                this.builders.addAll((Collection<Alignments.AlignmentEntry.Builder>)this.convertReads.getBuilders());
                this.numberOfAlignedReads += this.builders.size();
                continue;
            }
            if (samRecordIterator.hasNext()) continue;
            return;
        } while (this.builders.size() == 0);
    }

    @Override
    public Alignments.AlignmentEntry next() {
        Alignments.AlignmentEntry alignmentEntry = this.builders.remove(0).build();
        if (alignmentEntry.getTargetIndex() != this.lastTargetIndex) {
            this.queryIndex2NextFragmentIndex.clear();
        }
        this.lastTargetIndex = alignmentEntry.getTargetIndex();
        this.lastPosition = alignmentEntry.getPosition();
        return alignmentEntry;
    }

    @Override
    public Alignments.AlignmentEntry skipTo(int targetIndex, int position) throws IOException {
        boolean doesNotUseIndex;
        boolean bl = doesNotUseIndex = targetIndex == this.lastTargetIndex;
        if (doesNotUseIndex) {
            return this.slowSkipTo(targetIndex, position);
        }
        this.reposition(targetIndex, position);
        if (this.hasNext()) {
            return this.next();
        }
        return null;
    }

    public Alignments.AlignmentEntry slowSkipTo(int targetIndex, int position) throws IOException {
        Alignments.AlignmentEntry entry = null;
        while (this.hasNext()) {
            entry = this.next();
            if (targetIndex < entry.getTargetIndex()) {
                return entry;
            }
            if (entry.getTargetIndex() != targetIndex || position > entry.getPosition()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public void reposition(int targetIndex, int position) throws IOException {
        if (!this.parser.hasIndex()) {
            throw new UnsupportedOperationException("Cannot use skipTo/reposition when an alignment is not indexed. Check index file is present: .crai, .bai");
        }
        if (this.samRecordIterator != null) {
            this.samRecordIterator.close();
        }
        int samPositionOneBased = position + 1;
        QueryInterval[] intervals = this.constructQueryIntervalsStartingAt(targetIndex, samPositionOneBased);
        this.samRecordIterator = this.parser.query(intervals, false);
        ArrayList<Alignments.AlignmentEntry.Builder> toRemove = new ArrayList<Alignments.AlignmentEntry.Builder>();
        for (Alignments.AlignmentEntry.Builder builder : this.builders) {
            if (builder.getTargetIndex() < targetIndex) {
                toRemove.add(builder);
                continue;
            }
            if (builder.getTargetIndex() != targetIndex || builder.getPosition() >= samPositionOneBased) continue;
            toRemove.add(builder);
        }
        this.builders.removeAll(toRemove);
    }

    private QueryInterval[] constructQueryIntervalsStartingAt(int targetIndex, int samPositionOneBased) {
        int numElements = this.targetIds.size() - targetIndex;
        QueryInterval[] intervals = new QueryInterval[numElements];
        for (int i = 0; i < numElements; ++i) {
            int startPosition = i == 0 ? samPositionOneBased : 1;
            intervals[i] = new QueryInterval(i + targetIndex, startPosition, -1);
        }
        return QueryInterval.optimizeIntervals((QueryInterval[])intervals);
    }

    private QueryInterval[] constructQueryIntervals(int startTargetIndex, int startSamPositionOneBased, int endTargetIndex, int endSamPositionOneBased) {
        int numElements = endTargetIndex - startTargetIndex + 1;
        QueryInterval[] intervals = new QueryInterval[numElements];
        for (int i = 0; i < numElements; ++i) {
            int startPosition = i == 0 ? startSamPositionOneBased : 1;
            int endPosition = i == endTargetIndex - startTargetIndex ? endSamPositionOneBased : -1;
            intervals[i] = new QueryInterval(i + startTargetIndex, startPosition, endPosition);
        }
        return QueryInterval.optimizeIntervals((QueryInterval[])intervals);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not implemented");
    }

    @Override
    public void readHeader() throws IOException {
        int numTargets;
        SAMFileHeader samHeader = this.parser.getFileHeader();
        this.readGroups = new IndexedIdentifier();
        this.importReadGroups(samHeader, this.readGroups);
        boolean hasPaired = false;
        this.targetIds = new IndexedIdentifier();
        this.config.numberOfReads = 0;
        Object prevRecord = null;
        if (samHeader.getSequenceDictionary().isEmpty()) {
            System.err.println("SAM/BAM file/input appear to have no target sequences. If reading from stdin, please check you are feeding this mode actual SAM/BAM content and that the header of the SAM file is included.");
            if (this.config.runningFromCommandLine) {
                System.exit(0);
            }
        } else {
            if (this.config.genome != null) {
                for (int genomeTargetIndex = 0; genomeTargetIndex < this.config.genome.size(); ++genomeTargetIndex) {
                    this.getTargetIndex(this.targetIds, this.config.genome.getReferenceName(genomeTargetIndex), this.config.thirdPartyInput);
                }
            }
            numTargets = samHeader.getSequenceDictionary().size();
            for (int i = 0; i < numTargets; ++i) {
                SAMSequenceRecord seq = samHeader.getSequence(i);
                this.getTargetIndex(this.targetIds, seq.getSequenceName(), this.config.thirdPartyInput);
            }
        }
        if (!this.targetIds.isEmpty() && this.targetIds.size() != samHeader.getSequenceDictionary().size()) {
            LOG.warn("targets: " + this.targetIds.size() + ", records: " + samHeader.getSequenceDictionary().size());
        }
        numTargets = Math.max(samHeader.getSequenceDictionary().size(), this.targetIds.size());
        int[] targetLengths = new int[numTargets];
        for (int i = 0; i < numTargets; ++i) {
            int targetIndex;
            SAMSequenceRecord seq = samHeader.getSequence(i);
            if (seq == null || (targetIndex = this.getTargetIndex(this.targetIds, seq.getSequenceName(), this.config.thirdPartyInput)) >= targetLengths.length) continue;
            targetLengths[targetIndex] = seq.getSequenceLength();
        }
        this.targetLengths = targetLengths;
        this.reverseTargetIndex2Id = new DoubleIndexedIdentifier(this.targetIds);
    }

    @Override
    public void readIndex() throws IOException {
        this.index = this.parser.indexing();
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException e) {
            LOG.error("Exception when attempting to close SAM/BAM/CRAM parser", (Throwable)e);
        }
    }

    @Override
    public Iterator<Alignments.AlignmentEntry> iterator() {
        return this;
    }

    @Override
    public Properties getStatistics() {
        return new Properties();
    }

    @Override
    public int getNumberOfAlignedReads() {
        return this.numberOfAlignedReads;
    }

    @Override
    public ObjectList<ReferenceLocation> getLocations(int modulo) throws IOException {
        ObjectArrayList locations = new ObjectArrayList();
        int targetIndex = 0;
        for (int targetLength : this.getTargetLength()) {
            for (int position = 0; position < targetLength; position += modulo) {
                ReferenceLocation location = new ReferenceLocation(targetIndex, position);
                locations.add((Object)location);
            }
            ++targetIndex;
        }
        return locations;
    }

    @Override
    public ReferenceLocation getMinLocation() throws IOException {
        return new ReferenceLocation(0, 0);
    }

    @Override
    public ReferenceLocation getMaxLocation() throws IOException {
        int lastTarget = this.getNumberOfTargets() - 1;
        return new ReferenceLocation(lastTarget, this.getTargetLength()[lastTarget]);
    }

    @Override
    public ObjectList<ReferenceLocation> getLocationsByBytes(int bytesPerSlice) throws IOException {
        throw new UnsupportedOperationException("Locations by byte are not supported for SAM/BAM/CRAM formats.");
    }

    @Override
    public boolean isQueryLengthStoredInEntries() {
        return true;
    }

    @Override
    public String getAlignerName() {
        List records = this.parser.getFileHeader().getProgramRecords();
        return "unknown";
    }

    @Override
    public String getAlignerVersion() {
        return "unknown";
    }

    @Override
    public int getSmallestSplitQueryIndex() {
        return 0;
    }

    @Override
    public int getLargestSplitQueryIndex() {
        return 0;
    }

    @Override
    public IndexedIdentifier getTargetIdentifiers() {
        return this.targetIds;
    }

    @Override
    public int[] getTargetLength() {
        return this.targetLengths;
    }

    @Override
    public int getNumberOfTargets() {
        return this.targetIds.size();
    }

    @Override
    public int getNumberOfQueries() {
        return 0;
    }

    @Override
    public boolean isConstantQueryLengths() {
        return false;
    }

    @Override
    public int getConstantQueryLength() {
        return 0;
    }

    @Override
    public IndexedIdentifier getQueryIdentifiers() {
        throw new UnsupportedOperationException("Read names can be obtained from alignemnt entry directly");
    }

    @Override
    public long getStartByteOffset(int startReferenceIndex, int startPosition) {
        return 0L;
    }

    @Override
    public boolean getQueryIndicesWerePermuted() {
        return false;
    }

    @Override
    public boolean hasQueryIndexOccurrences() {
        return false;
    }

    @Override
    public boolean hasAmbiguity() {
        return false;
    }

    @Override
    public long getEndByteOffset(int startReferenceIndex, int startPosition, int endReferenceIndex, int endPosition) {
        return 0L;
    }

    @Override
    public ReadOriginInfo getReadOriginInfo() {
        return new ReadOriginInfo(this.readOriginInfoList);
    }

    @Override
    public boolean isSorted() {
        Boolean aBoolean = HTSJDKReaderImpl.doc().getBoolean("force-sorted");
        if (aBoolean != null && aBoolean.booleanValue()) {
            return true;
        }
        return this.parser.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.unsorted;
    }

    public static boolean canRead(String basename) {
        String filename = basename;
        filename = HTSJDKReaderImpl.getFilename(basename);
        return filename.endsWith(".bam") || filename.endsWith(".sam") || filename.endsWith(".cram");
    }

    private static String getFilename(String basename) {
        String filename = basename;
        if (!new File(basename).exists()) {
            String[] extensions;
            for (String extension : extensions = new String[]{".bam", ".cram", ".sam"}) {
                if (new File(basename + extension).exists()) {
                    filename = basename + extension;
                } else {
                    String pathname = FilenameUtils.removeExtension((String)basename) + extension;
                    if (!new File(pathname).exists()) continue;
                    filename = pathname;
                }
                break;
            }
        } else {
            filename = basename;
        }
        return filename;
    }

    public static String[] getBasenames(String[] inputFilenames) {
        ObjectArraySet basenames = new ObjectArraySet();
        for (String filename : inputFilenames) {
            String[] extensions;
            for (String extension : extensions = new String[]{".bam", ".cram", ".sam"}) {
                if (!filename.endsWith(extension)) continue;
                basenames.add(filename);
            }
        }
        return basenames.toArray(new String[basenames.size()]);
    }
}

