/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class ChannelReader
extends Reader {
    private static final int DEFAULT_BUFFER_CAP = 8192;
    private ReadableByteChannel channel;
    private CharsetDecoder decoder;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;

    public int read(char[] buf, int offset, int count) throws IOException {
        if (!this.channel.isOpen()) {
            throw new IOException("Reader was already closed.");
        }
        if (this.decoder == null) {
            return -1;
        }
        int sum = -1;
        if (this.charBuffer.remaining() > 0) {
            sum = Math.min(count, this.charBuffer.remaining());
            this.charBuffer.get(buf, offset, sum);
            offset += sum;
            count -= sum;
        }
        this.charBuffer.compact();
        int converted = 0;
        boolean last = false;
        while (count != 0) {
            CoderResult result = this.decoder.decode(this.byteBuffer, this.charBuffer, last);
            if (result.isMalformed() || result.isUnmappable()) {
                result.throwException();
            }
            if (last) {
                this.decoder = null;
            } else if (result.isUnderflow()) {
                this.byteBuffer.compact();
                if (this.channel.read(this.byteBuffer) == -1) {
                    last = true;
                }
                this.byteBuffer.flip();
            }
            this.charBuffer.flip();
            converted = Math.min(count, this.charBuffer.remaining());
            this.charBuffer.get(buf, offset, converted);
            this.charBuffer.compact();
            offset += converted;
            count -= converted;
            sum += converted;
            if (this.decoder == null) break;
        }
        this.charBuffer.flip();
        return sum;
    }

    public void close() throws IOException {
        this.channel.close();
        if (this.decoder != null) {
            this.decoder.reset();
        }
    }

    public ChannelReader(ReadableByteChannel channel, CharsetDecoder decoder, int minBufferCap) {
        this.channel = channel;
        this.decoder = decoder;
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.reset();
        int size = minBufferCap == -1 ? 8192 : minBufferCap;
        this.byteBuffer = ByteBuffer.allocate(size);
        this.byteBuffer.flip();
        this.charBuffer = CharBuffer.allocate((int)((float)size * decoder.averageCharsPerByte()));
    }
}

