package TDS::Cache::Part;
# $Id: Part.pm,v 1.4 2001/02/06 05:02:13 tom Exp $
################################################################

use strict;
use vars qw(@ISA);

use TDS;
use TDS::Cache::Display;
use TDS::DirInfo;

@ISA = qw(TDS::Cache::Display);

attributes qw(year month part);
################################################################

sub initialize($)
{
    my $self = shift;

    $self->year($TDS::Status->year) unless $self->year;
    $self->month($TDS::Status->month) unless $self->month;
    $self->part($TDS::Status->day_part) unless $self->part;

    $self->SUPER::initialize;
}
    
sub GetCacheFilename($)
{
    my $self = shift;

    return $self->create_cache_filename(sprintf("c%04d%02d%s", 
						$self->year, $self->month, $self->part));
}


1;
