/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class LoggingOutputStream
extends OutputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private byte[] prefix;
    private final String prefixStr;
    private final Level logLevel;
    private final Logger log;
    private int lastb;

    public LoggingOutputStream(Class logAsClass, Level logLevel, String prefixStr) {
        this.log = LoggerFactory.getLogger((Class)logAsClass);
        if (StringUtils.isBlank((String)prefixStr)) {
            this.prefix = null;
            this.prefixStr = null;
        } else {
            this.prefixStr = prefixStr;
            this.prefix = prefixStr.getBytes();
        }
        this.logLevel = logLevel;
    }

    final void setOutputTag(String outputTag) {
        if (this.prefixStr == null) {
            return;
        }
        String newPrefixStr = StringUtils.replace((String)this.prefixStr, (String)"__OUTPUT_TAG__", (String)outputTag);
        this.prefix = newPrefixStr.getBytes();
    }

    @Override
    public void write(int b) {
        if (b == 13) {
            b = 10;
        }
        if (b == 10) {
            if (this.lastb != 10) {
                this.log.info(this.buffer.toString());
                this.buffer.reset();
                try {
                    if (this.prefix != null) {
                        this.buffer.write(this.prefix);
                    }
                }
                catch (IOException e) {
                    this.log.error("Cannot prepend prefix to buffer");
                }
            }
        } else {
            this.buffer.write((char)b);
        }
        this.lastb = b;
    }
}

