'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  If an argument is present, then a line break is
'\"	forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" SCCS: @(#) man.macros 1.8 96/02/15 20:02:24
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$1"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH gdmo n "" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
gdmo \- A Tcl interface to GDMO definitions.
.BE

.SH DESCRIPTION
The gdmo Tcl command allows to access definitions conforming to the
Guidelines for the Definition of Managed Objects (GDMO). The integrated
GDMO parser converts GDMO definitions into an internal representation
which can be queried using the gdmo Tcl command.

.SH GDMO COMMAND
.TP
.B gdmo load \fIpath\fR
Parse the GDMO file given by \fIpath\fR and store its content into
internal structures. \fIpath\fR may be an absolute or relative path to
the desired file and the tilde ~ is also allowed for starting at
an users home directory.

Example: gdmo load ~idefix/GDMO/example.gdmo

.TP
.B gdmo info \fIoption\fR
Show a list of all sub-options that \fIoption\fR understand, where
\fIoption\fR is one of the following: class, package, parameter,
namebinding, attribute, group, action, notification, behaviour.

Example: gdmo info class

exist superior mandatory conditional oid

.TP
.B gdmo class ?\fIlabel\fR \fIoption\fR?
Get the stored information for the MANAGED OBJECT CLASS templates. If
used without the optional parameters, it shows a list of stored
class-labels. If used with the optional parameters, \fIlabel\fR should
be one of the stored class-labels (gdmo class) and \fIoption\fR should
be a valid option (gdmo info class).

.RS 5
The available 
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given class-label exist, else it
returns "0". (that is the class-label is referenced, but there is no
definition for it)

.TP
.B superior
Returns a list of class-labels that are superclasses to the given
class-label. (DERIVED FROM)

.TP
.B mandatory
Returns a list of package-labels specifying the behaviour that
characterizes all instances of the given class-label. (CHARACTERIZED BY) 

.TP
.B conditional
Returns a list which elements are a pair of package-label and
condition-definition that are present in instances of the class under
the given condition. (CONDITIONAL PACKAGES, PRESENT IF)

.TP
.B oid
Returns a list which parts form the object-identifier value which
identifies to the managed object class definition. (REGISTERED AS)

.RE

.TP
.B gdmo package ?\fIlabel\fR \fIoption\fR?
Get the stored information for the PACKAGE templates. If
used without the optional parameters, it shows a list of stored
package-labels. If used with the optional parameters, \fIlabel\fR should
be one of the stored package-labels (gdmo package) and \fIoption\fR should
be a valid option (gdmo info package).

.RS 5
The available 
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given package-label exist, else it
returns "0". (that is the package-label is referenced, but there is no
definition for it)

.TP
.B behaviours
Returns a list of behaviour-definition-label which define the behaviour
that is included in the package. (BEHAVIOUR)

.TP
.B attributes
Returns a list, which elements are a list of attribute-label followed
by a complex propertylist and a list of parameter-labels, the package
contains. (ATTRIBUTES)

.TP
.B groups
Returns a list, which elements are a list of group-label followed by a
list of attribute-labels, the package contains. (ATTRIBUTE GROUP)

.TP
.B actions
Returns a list, which elements are a list of action-label followed by
a list of parameter-labels, the package contains. (ACTIONS)

.TP
.B notifications
Returns a list, which elements are a list of notification-label
followed by a list of parameter-labels, the package contains.
(NOTIFICATIONS)

.TP
.B oid
Returns a list which parts form the object-identifier the package-label
is REGISTERED AS.

.RE

.TP
.B gdmo parameter ?\fIlabel\fR \fIoption\fR?
Get the stored information for the PARAMETER templates. If
used without the optional parameters, it shows a list of stored
parameter-labels. If used with the optional parameters, \fIlabel\fR should
be one of the stored parameter-labels (gdmo parameter) and \fIoption\fR should
be a valid option (gdmo info parameter).

.RS 5
The available 
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given parameter-label exist, else it
returns "0". (that is the parameter-label is referenced, but there is no
definition for it)

.TP
.B context
Returns a context-keyword or a context-type which is one of
ACTION-INFO, ACTION-REPLY, EVENT-INFO, EVENT-REPLY or
SPECIFIC-ERROR. (CONTEXT)

.TP
.B choice
Returns a list with two elements, one of which is empty. If the first
element is not empty it is a type-reference (WITH SYNTAX), otherwise
the second element is not empty and is an attribute-label
(ATTRIBUTE). The given list specify the parameter.

.TP
.B behaviours
Returns a list of behaviour-definition-labels that applies to the use
of the parameter. (BEHAVIOUR)

.TP
.B oid
Returns a list which parts form the object-identifier the parameter-label
is REGISTERED AS.

.RE

.TP
.B gdmo namebinding ?\fIlabel\fR \fIoption\fR?
Get the stored information for the NAME BINDING templates. If used
without the optional parameters, it shows a list of stored
name-binding-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored name-binding-labels (gdmo namebinding) and
\fIoption\fR should be a valid option (gdmo info namebinding).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given name-binding-label exist, else it
returns "0". (that is the name-binding-label is referenced, but there is no
definition for it)

.TP
.B subordinate
Returns a list with two elements, the first is an class-label of the
class that is named by the superior object class and the second is "1",
if the name binding applies to all subclasses of the specified managed
object class and "0" otherwise. (SUBORDINATE OBJECT CLASS)

.TP
.B superior
Returns a list with two elements, the first is an class-label of the
class that names the subordinate object class and the second is "1",
if the name binding applies to all subclasses of the specified managed
object class and "0" otherwise. (NAMED BY SUPERIOR OBJECT CLASS)

.TP
.B attribute
Returns the attribute-label that shall be used, in the context of this
name binding, to construct the relative distinguished name for
instances of the managed object class defined by
subordinate. (ATTRIBUTE)

.TP
.B behaviours
Returns a list of behaviour-definition-label that identifies the
behaviour definition concerned for this name binding. (BEHAVIOUR)

.TP
.B create
Returns a list of two elements, the first element is the
create-modifier(s) (WITH-REFERENCE-OBJECT,
WITH-AUTOMATIC-INSTANCE-NAMING) and the second element is a list of
parameter-labels. (CREATE)

.TP
.B delete
Returns a list of two elements, the first element is the
delete-modifier (ONLY-IF-NO-CONTAINED-OBJECTS,
DELETES-CONTAINED-OBJECTS) and the second element is a list of
parameter-labels. (DELETE)

.TP
.B oid
Returns a list which parts form the object-identifier the name-binding-label
is REGISTERED AS.

.RE

.TP
.B gdmo attribute ?\fIlabel\fR \fIoption\fR?
Get the stored information for the ATTRIBUTE templates. If used
without the optional parameters, it shows a list of stored
attribute-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored attribute-labels (gdmo attribute) and
\fIoption\fR should be a valid option (gdmo info attribute).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given attribute-label exist, else it
returns "0". (that is the attribute-label is referenced, but there is no
definition for it)

.TP
.B choice
Returns a list with two elements, one of which is empty. If the first
element is not empty it is an attribute-label (DERIVED FROM), otherwise
the second element is not empty and is a type-reference (WITH
ATTRIBUTE SYNTAX). The given list specify the attribute.

.TP
.B matchesfor
Returns a list of value matching types. The value matching types are
EQUALITY, ORDERING, SUBSTRINGS, SET-COMPARISON and
SET-INTERSECTION. (MATCHES FOR)

.TP
.B behaviours
Returns a list of behaviour-definition-labels that specify the
behaviour of the attribute. (BEHAVIOUR)

.TP
.B parameters
Returns a list parameter-labels that specify attribute-specific error
parameters associated with management operations on the attribute type
used for processing failures. (PARAMETERS)

.TP
.B oid
Returns a list which parts form the object-identifier the attribute-label
is REGISTERED AS.

.RE

.TP
.B gdmo group ?\fIlabel\fR \fIoption\fR?
Get the stored information for the ATTRIBUTE GROUP templates. If used
without the optional parameters, it shows a list of stored
group-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored group-labels (gdmo group) and
\fIoption\fR should be a valid option (gdmo info group).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given group-label exist, else it
returns "0". (that is the group-label is referenced, but there is no
definition for it)

.TP
.B attributes
Returns a list of attribute-labels that constitute the group. (GROUP
ELEMENTS)

.TP
.B fixed
Returns "1", if the FIXED-token has been given in the attribute group
template and  "0" otherwise. (FIXED)

.TP
.B description
Returns a string that describes the attribute group. (DESCRIPTION)

.TP
.B oid
Returns a list which parts form the object-identifier the group-label
is REGISTERED AS.

.RE

.TP
.B gdmo action ?\fIlabel\fR \fIoption\fR?
Get the stored information for the ACTION templates. If used
without the optional parameters, it shows a list of stored
action-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored action-labels (gdmo action) and
\fIoption\fR should be a valid option (gdmo info action).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given action-label exist, else it
returns "0". (that is the action-label is referenced, but there is no
definition for it)

.TP
.B behaviours
Returns a list of behaviour-definition-labels which define the
behaviour of the action. (BEHAVIOUR)

.TP
.B mode
Returns "1", if the MODE CONFIRMED-token has been given in the
action template and  "0" otherwise. (FIXED)

.TP
.B parameters
Returns a list of parameter-labels that identify the action
information or action reply parameters, or processing failures
associated with the action type. (PARAMETERS)

.TP
.B infosyntax
Returns a type-reference that identifies the ASN.1 data type that
describes the structure of the action information parameter that is
carried in management protocol. (WITH INFORMATION SYNTAX)

.TP
.B replysyntax
Returns a type-reference that identifies the ASN.1 data type that
describes the structure of the action reply parameter that is carried
in management protocol. (WITH REPLY SYNTAX)

.TP
.B oid
Returns a list which parts form the object-identifier the action-label
is REGISTERED AS.

.RE

.TP
.B gdmo notification ?\fIlabel\fR \fIoption\fR?
Get the stored information for the NOTIFICATION templates. If used
without the optional parameters, it shows a list of stored
notification-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored notification-labels (gdmo notification) and
\fIoption\fR should be a valid option (gdmo info notification).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given notification-label exist,
else it returns "0". (that is the notification-label is referenced,
but there is no definition for it)

.TP
.B behaviours
Returns a list of behaviour-definition-labels which shall specify the
circumstances under which a notification of the type is
generated. (BEHAVIOUR)

.TP
.B parameters
Returns a list of parameter-labels associated with the notification
type. (PARAMETERS)

.TP
.B infosyntaxandids
Returns a list with a type-reference as the first element and if
present the second element is a list of field-name and attribute-label
pairs. (WITH INFORMATION SYNTAX ... [AND ATTRIBUTE IDS])

.TP
.B replysyntax
Returns a type-reference that identifies the ASN.1 data type that
describes the structure of the notification reply that is carried in
management protocol. (WITH REPLY SYNTAX)

.TP
.B oid
Returns a list which parts form the object-identifier the
notification-label is REGISTERED AS.

.RE

.TP
.B gdmo behaviour ?\fIlabel\fR \fIoption\fR?
Get the stored information for the BEHAVIOUR templates. If used
without the optional parameters, it shows a list of stored
behaviour-labels. If used with the optional parameters, \fIlabel\fR
should be one of the stored behaviour-labels (gdmo behaviour) and
\fIoption\fR should be a valid option (gdmo info behaviour).

.RS 5
The available
.I options
are:
.RE

.RS 
.TP 10

.B exist
Returns "1" if the definition for the given behaviour-label exist,
else it returns "0". (that is the behaviour-label is referenced, but
there is no definition for it)

.TP
.B definition
Returns a textual definition of the behaviour-label. (DEFINED AS)

.RE

.SH SEE ALSO
scotty(1), Tcl(n)

.SH AUTHORS
Michael Kernchen <kernchen@ibr.cs.tu-bs.de>
.br
Juergen Schoenwaelder <schoenw@cs.utwente.nl>
.br
