/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.awt.Image;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.classview.model.ClassifierNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;

public class EnumNode
extends ClassifierNode {
    private CharSequence name;
    private CharSequence qname;
    private static Image enumImage = null;

    public EnumNode(CsmEnum enumeration, Children.Array key) {
        super((CsmCompoundClassifier)enumeration, key);
        this.init(enumeration);
    }

    private void init(CsmEnum enumeration) {
        final CharSequence old = this.name;
        this.name = enumeration.getName();
        final CharSequence oldQ = this.qname;
        this.qname = enumeration.getQualifiedName();
        if (enumImage == null) {
            enumImage = CsmImageLoader.getImage((CsmObject)enumeration);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (old == null || !old.equals(EnumNode.this.name)) {
                    EnumNode.this.fireNameChange(old == null ? null : old.toString(), EnumNode.this.name == null ? null : EnumNode.this.name.toString());
                    EnumNode.this.fireDisplayNameChange(old == null ? null : old.toString(), EnumNode.this.name == null ? null : EnumNode.this.name.toString());
                }
                if (oldQ == null || !oldQ.equals(EnumNode.this.qname)) {
                    EnumNode.this.fireShortDescriptionChange(oldQ == null ? null : oldQ.toString(), EnumNode.this.qname == null ? null : EnumNode.this.qname.toString());
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public String getName() {
        return this.name.toString();
    }

    public String getDisplayName() {
        return this.name.toString();
    }

    public String getShortDescription() {
        return this.qname.toString();
    }

    @Override
    public Image getIcon(int param) {
        return enumImage;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o instanceof CsmEnum) {
            CsmEnum cls = (CsmEnum)o;
            this.setObject((CsmOffsetableDeclaration)cls);
            this.init(cls);
        } else if (o != null) {
            System.err.println("Expected CsmEnum. Actually event contains " + o.toString());
        }
    }
}

