/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkSupport;
import org.openide.text.NbDocument;

class MsgTooltipWindow
implements AWTEventListener,
MouseMotionListener,
MouseListener,
WindowFocusListener,
KeyListener {
    private static final int SCREEN_BORDER = 20;
    private final JComponent parent;
    private final String message;
    private final VCSFileProxy file;
    private JTextPane textPane;
    private int messageOffset;
    private VCSHyperlinkSupport linkerSupport = new VCSHyperlinkSupport();
    private JWindow contentWindow;
    private TooltipContentPanel cp;
    private final String revision;
    private final String author;
    private final Date date;

    MsgTooltipWindow(JComponent parent, VCSFileProxy file, String message, String revision, String author, Date date) {
        this.parent = parent;
        this.file = file;
        this.message = message;
        this.revision = revision;
        this.author = author;
        this.date = date;
    }

    void show(Point location) {
        GraphicsDevice device;
        GraphicsConfiguration gc;
        GraphicsDevice[] gds;
        Rectangle screenBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = gds = ge.getScreenDevices();
        int n = graphicsDeviceArray.length;
        for (int i = 0; i < n && !(screenBounds = (gc = (device = graphicsDeviceArray[i]).getDefaultConfiguration()).getBounds()).contains(location); ++i) {
        }
        this.cp = new TooltipContentPanel();
        Window w = SwingUtilities.windowForComponent(this.parent);
        this.contentWindow = new JWindow(w);
        this.contentWindow.add(this.cp);
        this.contentWindow.pack();
        Dimension dim = this.contentWindow.getSize();
        if (screenBounds.width + screenBounds.x - location.x < this.cp.longestLine) {
            int left = screenBounds.width + screenBounds.x - this.cp.longestLine;
            location.x = Math.max(screenBounds.x, left);
        }
        if (location.y + dim.height + 20 > screenBounds.y + screenBounds.height) {
            dim.height = screenBounds.y + screenBounds.height - (location.y + 20);
        }
        if (location.x + dim.width + 20 > screenBounds.x + screenBounds.width) {
            dim.width = screenBounds.x + screenBounds.width - (location.x + 20);
        }
        this.contentWindow.setSize(dim);
        this.contentWindow.setLocation(location.x, location.y + 1);
        this.contentWindow.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MsgTooltipWindow.this.cp.scrollRectToVisible(new Rectangle(1, 1));
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        w.addWindowFocusListener(this);
        this.contentWindow.addWindowFocusListener(this);
        this.contentWindow.addKeyListener(this);
        w.addKeyListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() == 501 || event.getID() == 401) {
            this.onClick(event);
        }
    }

    private void onClick(AWTEvent event) {
        Component component = (Component)event.getSource();
        if (this.outsideOfTooltipWindow(component)) {
            this.shutdown();
        }
    }

    private boolean outsideOfTooltipWindow(Component component) {
        boolean retval = true;
        while (component != null) {
            if (component instanceof TooltipContentPanel) {
                retval = false;
                break;
            }
            component = component.getParent();
        }
        return retval;
    }

    private void shutdown() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        if (this.contentWindow != null) {
            this.contentWindow.getOwner().removeWindowFocusListener(this);
            this.contentWindow.getOwner().removeKeyListener(this);
            this.contentWindow.removeWindowFocusListener(this);
            this.contentWindow.removeKeyListener(this);
            this.contentWindow.dispose();
        }
        this.contentWindow = null;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource().equals(this.textPane)) {
            this.textPane.setCursor(Cursor.getPredefinedCursor(0));
            this.linkerSupport.computeBounds(this.textPane, 0);
            this.linkerSupport.mouseMoved(e.getPoint(), (JComponent)this.textPane, this.messageOffset);
        }
        this.textPane.setToolTipText("");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.textPane)) {
            this.linkerSupport.computeBounds(this.textPane, 0);
            if (this.linkerSupport.mouseClicked(e.getPoint(), 0)) {
                this.shutdown();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        if (this.contentWindow != null && e.getOppositeWindow() == null) {
            this.shutdown();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.shutdown();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private class TooltipContentPanel
    extends JComponent {
        int longestLine = 0;

        public TooltipContentPanel() {
            try {
                MsgTooltipWindow.this.textPane = new JTextPane();
                StyledDocument doc = (StyledDocument)MsgTooltipWindow.this.textPane.getDocument();
                Style normalStyle = MsgTooltipWindow.this.textPane.getStyle("normal");
                Style hyperlinkStyle = MsgTooltipWindow.this.textPane.addStyle("hyperlink", normalStyle);
                StyleConstants.setForeground(hyperlinkStyle, Color.BLUE);
                StyleConstants.setUnderline(hyperlinkStyle, true);
                Style authorStyle = MsgTooltipWindow.this.textPane.addStyle("author", normalStyle);
                StyleConstants.setForeground(authorStyle, Color.BLUE);
                doc.insertString(doc.getLength(), MsgTooltipWindow.this.revision + " - ", normalStyle);
                doc.insertString(doc.getLength(), MsgTooltipWindow.this.author, normalStyle);
                doc.insertString(doc.getLength(), " ", normalStyle);
                doc.insertString(doc.getLength(), DateFormat.getDateInstance().format(MsgTooltipWindow.this.date), normalStyle);
                doc.insertString(doc.getLength(), "\n", normalStyle);
                VCSHyperlinkSupport.IssueLinker l = null;
                List<VCSHyperlinkProvider> providers = History.getInstance().getHyperlinkProviders();
                for (VCSHyperlinkProvider hp : providers) {
                    File f = MsgTooltipWindow.this.file != null ? MsgTooltipWindow.this.file.toFile() : null;
                    if (f == null || (l = VCSHyperlinkSupport.IssueLinker.create((VCSHyperlinkProvider)hp, (Style)hyperlinkStyle, (File)f, (StyledDocument)doc, (String)MsgTooltipWindow.this.message)) == null) continue;
                    MsgTooltipWindow.this.linkerSupport.add((VCSHyperlinkSupport.Hyperlink)l, 0);
                    break;
                }
                if (l != null) {
                    l.insertString(doc, normalStyle);
                } else {
                    doc.insertString(doc.getLength(), MsgTooltipWindow.this.message, normalStyle);
                }
                MsgTooltipWindow.this.textPane.setDocument(doc);
                MsgTooltipWindow.this.textPane.setEditable(false);
                Color color = UIManager.getColor("nb.versioning.tooltip.background.color");
                if (null == color) {
                    color = new Color(233, 241, 255);
                }
                MsgTooltipWindow.this.textPane.setBackground(color);
                Element rootElement = NbDocument.findLineRootElement((StyledDocument)doc);
                int lineCount = rootElement.getElementCount();
                int height = MsgTooltipWindow.this.textPane.getFontMetrics(MsgTooltipWindow.this.textPane.getFont()).getHeight() * (lineCount + 1);
                int maxWidth = 0;
                for (int line = 0; line < lineCount; ++line) {
                    Element lineElement = rootElement.getElement(line);
                    String text = null;
                    try {
                        text = doc.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    int lineLength = MsgTooltipWindow.this.textPane.getFontMetrics(MsgTooltipWindow.this.textPane.getFont()).stringWidth(text);
                    if (lineLength <= maxWidth) continue;
                    maxWidth = lineLength;
                    this.longestLine = lineLength;
                }
                if (maxWidth < 50) {
                    maxWidth = 50;
                }
                MsgTooltipWindow.this.textPane.setPreferredSize(new Dimension(maxWidth * 7 / 6, height));
                if (!MsgTooltipWindow.this.textPane.isEditable()) {
                    MsgTooltipWindow.this.textPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
                }
                MsgTooltipWindow.this.textPane.addMouseListener(MsgTooltipWindow.this);
                MsgTooltipWindow.this.textPane.addMouseMotionListener(MsgTooltipWindow.this);
                JScrollPane jsp = new JScrollPane(MsgTooltipWindow.this.textPane);
                jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
                this.setLayout(new BorderLayout());
                this.add(jsp);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

