/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.lib.profiler.ui.swing.ProfilerColumnModel;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerTableActions {
    private final ProfilerTable table;

    static void install(ProfilerTable table) {
        new ProfilerTableActions(table).install();
    }

    private ProfilerTableActions(ProfilerTable table) {
        this.table = table;
    }

    private void install() {
        ActionMap map = this.table.getActionMap();
        map.put("selectNextColumn", this.selectNextColumnAction());
        map.put("selectPreviousColumn", this.selectPreviousColumnAction());
        map.put("selectNextColumnCell", this.createNextCellAction());
        map.put("selectPreviousColumnCell", this.createPreviousCellAction());
        map.put("selectFirstColumn", this.selectFirstColumnAction());
        map.put("selectLastColumn", this.selectLastColumnAction());
        map.put("selectNextRowCell", this.selectNextRowAction());
        map.put("selectPreviousRowCell", this.selectPreviousRowAction());
        map.put("selectNextRowExtendSelection", map.get("selectNextRow"));
        map.put("selectPreviousRowExtendSelection", map.get("selectPreviousRow"));
        map.put("selectNextColumnExtendSelection", map.get("selectNextColumn"));
        map.put("selectPreviousColumnExtendSelection", map.get("selectPreviousColumn"));
        map.put("selectLastColumnExtendSelection", map.get("selectLastColumn"));
        map.put("selectFirstColumnExtendSelection", map.get("selectFirstColumn"));
    }

    private Action selectNextRowAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int row = ProfilerTableActions.this.table.getSelectedRow();
                if (row == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    if (++row == ProfilerTableActions.this.table.getRowCount()) {
                        row = 0;
                        int column = ProfilerTableActions.this.table.getSelectedColumn();
                        if (column == -1) {
                            column = cModel.getFirstVisibleColumn();
                        }
                        column = cModel.getNextVisibleColumn(column);
                        ProfilerTableActions.this.table.selectColumn(column, false);
                    }
                    ProfilerTableActions.this.table.selectRow(row, true);
                }
            }
        };
    }

    private Action selectPreviousRowAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int row = ProfilerTableActions.this.table.getSelectedRow();
                if (row == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getLastVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(ProfilerTableActions.this.table.getRowCount() - 1, true);
                } else {
                    if (--row == -1) {
                        row = ProfilerTableActions.this.table.getRowCount() - 1;
                        int column = ProfilerTableActions.this.table.getSelectedColumn();
                        if (column == -1) {
                            column = cModel.getLastVisibleColumn();
                        }
                        column = cModel.getPreviousVisibleColumn(column);
                        ProfilerTableActions.this.table.selectColumn(column, false);
                    }
                    ProfilerTableActions.this.table.selectRow(row, true);
                }
            }
        };
    }

    private Action selectFirstColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int row = ProfilerTableActions.this.table.getSelectedRow();
                ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), row != -1);
                if (row == -1) {
                    ProfilerTableActions.this.table.selectRow(0, true);
                }
            }
        };
    }

    private Action selectLastColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int row = ProfilerTableActions.this.table.getSelectedRow();
                ProfilerTableActions.this.table.selectColumn(cModel.getLastVisibleColumn(), row != -1);
                if (row == -1) {
                    ProfilerTableActions.this.table.selectRow(0, true);
                }
            }
        };
    }

    private Action selectNextColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int column = ProfilerTableActions.this.table.getSelectedColumn();
                if (column == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int nextColumn = cModel.getNextVisibleColumn(column);
                    if (nextColumn > column) {
                        ProfilerTableActions.this.table.selectColumn(nextColumn, true);
                    }
                }
            }
        };
    }

    private Action selectPreviousColumnAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int column = ProfilerTableActions.this.table.getSelectedColumn();
                if (column == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int previousColumn = cModel.getPreviousVisibleColumn(column);
                    if (previousColumn < column) {
                        ProfilerTableActions.this.table.selectColumn(previousColumn, true);
                    }
                }
            }
        };
    }

    private Action createNextCellAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int column = ProfilerTableActions.this.table.getSelectedColumn();
                if (column == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int newRow;
                    int row;
                    boolean differentRow;
                    int nextColumn = cModel.getNextVisibleColumn(column);
                    boolean bl = differentRow = nextColumn <= column && ProfilerTableActions.this.table.getRowCount() > 1;
                    if (nextColumn != column) {
                        ProfilerTableActions.this.table.selectColumn(nextColumn, !differentRow);
                    }
                    if (differentRow && (row = ProfilerTableActions.this.table.getSelectedRow()) != (newRow = ProfilerTableActions.this.getNextRow(row))) {
                        ProfilerTableActions.this.table.selectRow(newRow, true);
                    }
                }
            }
        };
    }

    private Action createPreviousCellAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerColumnModel cModel = ProfilerTableActions.this.table._getColumnModel();
                if (ProfilerTableActions.this.table.getRowCount() == 0 || cModel.getVisibleColumnCount() == 0) {
                    return;
                }
                int column = ProfilerTableActions.this.table.getSelectedColumn();
                if (column == -1) {
                    ProfilerTableActions.this.table.selectColumn(cModel.getFirstVisibleColumn(), false);
                    ProfilerTableActions.this.table.selectRow(0, true);
                } else {
                    int newRow;
                    int row;
                    boolean differentRow;
                    int previousColumn = cModel.getPreviousVisibleColumn(column);
                    boolean bl = differentRow = previousColumn >= column && ProfilerTableActions.this.table.getRowCount() > 1;
                    if (previousColumn != column) {
                        ProfilerTableActions.this.table.selectColumn(previousColumn, !differentRow);
                    }
                    if (differentRow && (row = ProfilerTableActions.this.table.getSelectedRow()) != (newRow = ProfilerTableActions.this.getPreviousRow(row))) {
                        ProfilerTableActions.this.table.selectRow(newRow, true);
                    }
                }
            }
        };
    }

    private int getNextRow(int row) {
        return ++row == this.table.getRowCount() ? 0 : row;
    }

    private int getPreviousRow(int row) {
        return --row == -1 ? this.table.getRowCount() - 1 : row;
    }
}

