/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.util;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.openide.filesystems.FileObject;

public final class ComposerUtils {
    private static final String USAGE_LOGGER_NAME = "org.netbeans.ui.metrics.php.composer";
    private static final UsageLogger COMPOSER_REQUIRE_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.php.composer").message(ComposerUtils.class, "USG_COMPOSER_EDIT").create();
    private static final UsageLogger COMPOSER_LIBRARY_USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.php.composer").message(ComposerUtils.class, "USG_COMPOSER_LIBRARY").firstMessageOnly(false).create();

    private ComposerUtils() {
        throw new IllegalStateException("no instances allowed");
    }

    public static void logUsageComposerRequire() {
        COMPOSER_REQUIRE_USAGE_LOGGER.log(new Object[0]);
    }

    public static void logUsageComposerLibrary(String type, String name, String version) {
        COMPOSER_LIBRARY_USAGE_LOGGER.log(new Object[]{type, name, version});
    }

    @NonNull
    public static FileObject getComposerWorkDir(@NonNull PhpModule phpModule) {
        assert (phpModule != null);
        FileObject projectDirectory = phpModule.getProjectDirectory();
        if (projectDirectory.getFileObject("composer.json") != null) {
            return projectDirectory;
        }
        FileObject sourceDirectory = phpModule.getSourceDirectory();
        if (sourceDirectory != null && sourceDirectory.getFileObject("composer.json") != null) {
            return sourceDirectory;
        }
        return projectDirectory;
    }
}

