/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.modules.cordova.updatetask.CordovaTask;
import org.netbeans.modules.cordova.updatetask.DeviceConfig;
import org.netbeans.modules.cordova.updatetask.InfoPlist;
import org.netbeans.modules.cordova.updatetask.SourceConfig;

public class IOSUpdateTask
extends CordovaTask {
    public void execute() throws BuildException {
        try {
            File root = new File(this.getProject().getBaseDir().getAbsolutePath() + "/" + this.getProperty("cordova.platforms") + "/ios");
            File configFile = this.getConfigFile();
            String[] list = root.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("xcodeproj");
                }
            });
            String name = list[0].substring(0, list[0].indexOf("."));
            File iosConfigFile = new File(this.getProject().getBaseDir().getAbsolutePath() + "/" + this.getProperty("cordova.platforms") + "/ios/" + name + "/" + "config.xml");
            this.getProject().setProperty("xcode.project.name", name);
            File infoPlist = new File(root.getPath() + "/" + name + "/" + name + "-Info.plist");
            InfoPlist plist = new InfoPlist(infoPlist);
            String bundleID = this.getProperty("android.project.package") + "." + this.getProperty("android.project.activity");
            plist.setBundleIdentifier(bundleID);
            plist.save();
            DeviceConfig iosConfig = new DeviceConfig(iosConfigFile);
            SourceConfig config = new SourceConfig(configFile);
            this.updateIOSConfig(config, iosConfig);
            iosConfig.save();
            this.updateResources(config);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void updateIOSConfig(SourceConfig config, DeviceConfig iosConfig) {
        iosConfig.setAccess(config.getAccess());
        this.remap(config, iosConfig, "webviewbounce", "UIWebViewBounce");
        this.remap(config, iosConfig, "DisallowOverscroll", "DisallowOverscroll");
        this.remap(config, iosConfig, "auto-hide-splash-screen", "AutoHideSplashScreen");
    }

    private void remap(SourceConfig config, DeviceConfig iosConfig, String orig, String newOne) {
        String pref = config.getPreference(orig);
        if (pref != null) {
            iosConfig.setPreference(newOne, pref);
        }
    }

    private void updateResources(SourceConfig config) throws IOException {
        String icon = config.getIcon("ios", 57, 57);
        this.copy(icon, "icons/icon");
        icon = config.getIcon("ios", 114, 114);
        this.copy(icon, "icons/icon@2x");
        icon = config.getIcon("ios", 72, 72);
        this.copy(icon, "icons/icon-72");
        icon = config.getIcon("ios", 144, 144);
        this.copy(icon, "icons/icon-72@2x");
        String splash = config.getSplash("ios", 320, 480);
        this.copy(splash, "splash/Default~iphone");
        splash = config.getSplash("ios", 640, 960);
        this.copy(splash, "splash/Default@2x~iphone");
        splash = config.getSplash("ios", 768, 1024);
        this.copy(splash, "splash/Default-Portrait~ipad");
        splash = config.getSplash("ios", 1536, 2048);
        this.copy(splash, "splash/Default-Portrait@2x~ipad");
        splash = config.getSplash("ios", 1024, 768);
        this.copy(splash, "splash/Default-Landscape~ipad");
        splash = config.getSplash("ios", 2048, 1536);
        this.copy(splash, "splash/Default-Landscape@2x~ipad");
        splash = config.getSplash("ios", 640, 1136);
        this.copy(splash, "splash/Default-568h@2x~iphone.png");
    }

    private void copy(String source, String dest) throws IOException {
        if (source == null) {
            return;
        }
        String name = this.getProject().getProperty("xcode.project.name");
        int i = source.indexOf(".");
        String ext = i < 0 ? "" : source.substring(i);
        String prjPath = this.getProject().getBaseDir().getPath();
        FileUtils.getFileUtils().copyFile(prjPath + "/" + this.getProperty("site.root") + "/" + source, prjPath + "/" + this.getProject().getProperty("cordova.platforms") + "/ios/" + name + "/Resources/" + dest + ext);
    }
}

