/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.OnewayOperationParameterMode;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class OnewayOperationExceptions
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    public ErrorDescription[] apply(ExecutableElement subject, ProblemContext ctx) {
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.Oneway");
        Tree problemTree = ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
        if (!subject.getThrownTypes().isEmpty()) {
            String label = NbBundle.getMessage(OnewayOperationParameterMode.class, (String)"MSG_OnewayNotAllowed_HasExceptions");
            RemoveAnnotation removeFix = new RemoveAnnotation(ctx.getFileObject(), subject, annEntity);
            ctx.setElementToAnnotate(problemTree);
            ErrorDescription problem = OnewayOperationExceptions.createProblem((Element)subject, ctx, label, removeFix);
            ctx.setElementToAnnotate(null);
            return new ErrorDescription[]{problem};
        }
        return null;
    }

    @Override
    protected final boolean isApplicable(ExecutableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.Oneway");
    }
}

