/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.io.Externalizable;
import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.apache.tomcat.context.WebXmlReader;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.logging.TomcatLogger;
import org.apache.tomcat.service.PoolTcpConnector;
import org.apache.tomcat.startup.EmbededTomcat;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.netbeans.modules.httpserver.NbLoaderInterceptor;
import org.netbeans.modules.httpserver.NbServletsInterceptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HttpServerModule
extends ModuleInstall
implements Externalizable {
    private static ContextManager server;
    private static ContextReloader reloader;
    private static Thread serverThread;
    private static boolean inSetRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerModule.stopHTTPServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (inSetRunning) {
                return;
            }
            inSetRunning = true;
            try {
                if (serverThread != null) {
                    HttpServerModule.httpserverSettings();
                    if (!HttpServerSettings.running) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (serverThread != null) {
                            HttpServerModule.httpserverSettings();
                            if (!HttpServerSettings.running) {
                                serverThread.stop();
                                serverThread = null;
                            }
                        }
                    }
                }
                if (serverThread == null) {
                    serverThread = new Thread("HTTPServer"){

                        @Override
                        public void run() {
                            try {
                                server = HttpServerModule.buildServer();
                                server.start();
                                HttpServerModule.httpserverSettings().runSuccess();
                                reloader.activate();
                                if (HttpServerModule.httpserverSettings().isStartStopMessages()) {
                                    System.out.println(NbBundle.getMessage(HttpServerModule.class, (String)"CTL_ServerStarted", (Object[])new Object[]{new Integer(HttpServerModule.httpserverSettings().getPort())}));
                                }
                            }
                            catch (ThreadDeath td) {
                                throw td;
                            }
                            catch (Throwable ex) {
                                Logger.getLogger("global").log(Level.INFO, null, ex);
                                serverThread = null;
                                inSetRunning = false;
                                HttpServerModule.httpserverSettings().runFailure(ex);
                            }
                            finally {
                                HttpServerModule.httpserverSettings().setStartStopMessages(true);
                            }
                        }
                    };
                    serverThread.start();
                }
                try {
                    HttpServerSettings.httpLock().wait(3000L);
                }
                catch (Exception e) {
                    Logger.getLogger("global").log(Level.INFO, null, e);
                }
            }
            finally {
                inSetRunning = false;
            }
        }
    }

    public void uninstalled() {
        HttpServerModule.stopHTTPServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopHTTPServer() {
        if (inSetRunning) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            block13: {
                if (inSetRunning) {
                    return;
                }
                inSetRunning = true;
                try {
                    if (reloader != null) {
                        reloader.deactivate();
                        reloader = null;
                    }
                    if (serverThread == null || server == null) break block13;
                    try {
                        server.stop();
                        serverThread.join();
                    }
                    catch (InterruptedException e) {
                        serverThread.stop();
                    }
                    catch (Exception e) {
                        serverThread.stop();
                    }
                    serverThread = null;
                    if (HttpServerModule.httpserverSettings().isStartStopMessages()) {
                        System.out.println(NbBundle.getBundle(HttpServerModule.class).getString("CTL_ServerStopped"));
                    }
                }
                finally {
                    inSetRunning = false;
                }
            }
        }
    }

    private static ContextManager getContextManager(EmbededTomcat tc) {
        try {
            Field fm = EmbededTomcat.class.getDeclaredField("contextM");
            fm.setAccessible(true);
            return (ContextManager)fm.get(tc);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static void removeWebXmlReader(EmbededTomcat tc) {
        try {
            Field fm = EmbededTomcat.class.getDeclaredField("contextInt");
            fm.setAccessible(true);
            Vector contextInt = (Vector)fm.get(tc);
            for (Object o : contextInt) {
                if (!(o instanceof WebXmlReader)) continue;
                contextInt.remove(o);
                break;
            }
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
    }

    private static ContextManager buildServer() throws Exception {
        HttpServerSettings op = HttpServerModule.httpserverSettings();
        NbLogger logger = new NbLogger();
        logger.setName("tc_log");
        EmbededTomcat tc = new EmbededTomcat();
        File wd = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
        wd = new File(wd, "httpwork");
        tc.setWorkDir(wd.getAbsolutePath());
        NbLoaderInterceptor nbL = new NbLoaderInterceptor();
        tc.addContextInterceptor(nbL);
        tc.addApplicationAdapter(null);
        NbServletsInterceptor nbI = new NbServletsInterceptor();
        tc.addContextInterceptor(nbI);
        HttpServerModule.removeWebXmlReader(tc);
        ServletContext sctx = tc.addContext("", wd.toURI().toURL());
        tc.initContext(sctx);
        tc.addEndpoint(op.getPort(), null, null);
        ContextManager cm = HttpServerModule.getContextManager(tc);
        reloader = new ContextReloader(tc, cm, sctx);
        Enumeration e = cm.getConnectors();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!(o instanceof PoolTcpConnector)) continue;
            PoolTcpConnector conn = (PoolTcpConnector)o;
            conn.setAttribute("min_spare_threads", "0");
            conn.setAttribute("max_spare_threads", "1");
            conn.setAttribute("max_threads", "3");
        }
        return cm;
    }

    static HttpServerSettings httpserverSettings() {
        return HttpServerSettings.getDefault();
    }

    static {
        inSetRunning = false;
    }

    private static class ContextReloader
    implements LookupListener,
    Runnable {
        private ServletContext ide_ctx;
        private EmbededTomcat tc;
        private ContextManager cm;
        private Lookup.Result<ClassLoader> res;

        public ContextReloader(EmbededTomcat tc, ContextManager cm, ServletContext ctx) {
            this.ide_ctx = ctx;
            this.tc = tc;
            this.cm = cm;
        }

        public void activate() {
            this.res = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            this.res.addLookupListener((LookupListener)this);
        }

        public void deactivate() {
            if (this.res != null) {
                this.res.removeLookupListener((LookupListener)this);
                this.res = null;
            }
        }

        public void resultChanged(LookupEvent evt) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            ClassLoader cl = (ClassLoader)this.res.allInstances().iterator().next();
            this.cm.setParentClassLoader(cl);
            File wd = FileUtil.toFile((FileObject)FileUtil.getConfigRoot());
            wd = new File(wd, "httpwork");
            Enumeration e = this.cm.getContexts();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof Context)) continue;
                Context ctx = (Context)o;
                this.tc.removeContext(this.ide_ctx);
                try {
                    this.ide_ctx = this.tc.addContext("", wd.toURI().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.tc.initContext(this.ide_ctx);
            }
        }
    }

    private static class NbLogger
    extends TomcatLogger {
        @Override
        protected void realLog(String message) {
        }

        @Override
        protected void realLog(String message, Throwable t) {
        }

        @Override
        public void flush() {
        }
    }
}

