/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.utils;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class RemoteUtil {
    public static final Logger LOGGER = RemoteLogger.getInstance();

    private RemoteUtil() {
    }

    public static boolean isForeign(ExecutionEnvironment execEnv) {
        String protocolSeparator;
        if (execEnv == null) {
            return false;
        }
        String id = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv);
        if (id.indexOf(protocolSeparator = "://") < 0) {
            return false;
        }
        return !id.startsWith("ssh" + protocolSeparator);
    }

    public static String getDisplayName(ExecutionEnvironment execEnv) {
        ServerRecord rec = ServerList.get((ExecutionEnvironment)execEnv);
        if (rec == null) {
            return execEnv.getDisplayName();
        }
        return rec.getDisplayName();
    }

    public static void checkSetupAfterConnection(ExecutionEnvironment env) {
        RemoteServerRecord record = (RemoteServerRecord)ServerList.get((ExecutionEnvironment)env);
        RemoteUtil.checkSetupAfterConnection(record);
    }

    public static void checkSetupAfterConnection(RemoteServerRecord record) {
        if (!record.isOnline()) {
            record.resetOfflineState();
            record.init(null);
            if (record.isOnline()) {
                ToolsCacheManager cacheManager = ToolsCacheManager.createInstance((boolean)true);
                CompilerSetManager csm = cacheManager.getCompilerSetManagerCopy(record.getExecutionEnvironment(), false);
                csm.initialize(false, true, null);
                cacheManager.applyChanges();
            }
        }
    }

    public static boolean isWindows(ExecutionEnvironment env) {
        return env.isLocal() && Utilities.isWindows();
    }

    public static String getMessage(IOException e) {
        String reason = e.getMessage();
        String result = e instanceof UnknownHostException ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_UnknownHost", (Object)e.getMessage()) : (reason.startsWith("Auth fail") ? NbBundle.getMessage(RemoteConnectionSupport.class, (String)"REASON_AuthFailed") : reason);
        return result;
    }

    public static class PrefixedLogger {
        private final String prefix;

        public PrefixedLogger(String prefix) {
            this.prefix = prefix;
        }

        public void log(Level level, String format, Object ... args) {
            if (LOGGER.isLoggable(level)) {
                String text = String.format(format, args);
                text = this.prefix + ": " + text;
                LOGGER.log(level, text);
            }
        }

        public Level getLevel() {
            return LOGGER.getLevel();
        }

        public boolean isLoggable(Level level) {
            return LOGGER.isLoggable(level);
        }
    }
}

