/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.netbeans.modules.cnd.antlr.collections.AST;

public class CacheUtil {
    private static final int CHILD = 1;
    private static final int SIBLING = 2;
    private static final int END_AST = 3;

    public static String mangleName(CharSequence fileName, char filler) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '\\' || c == '/' || c == ':' || c == ' ') {
                c = filler;
            }
            if (i <= 0 && c == filler) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static void writeAST(ObjectOutputStream out, AST ast) throws IOException {
        out.writeObject(ast);
        if (ast != null) {
            CacheUtil.writeTree(out, ast);
        }
    }

    public static AST readAST(ObjectInputStream in) throws IOException, ClassNotFoundException {
        AST ast = (AST)in.readObject();
        if (ast != null) {
            CacheUtil.readTree(in, ast);
        }
        return ast;
    }

    private static void writeTree(ObjectOutputStream out, AST root) throws IOException {
        assert (root != null) : "there must be something to write";
        AST node = root;
        do {
            AST child;
            if ((child = node.getFirstChild()) != null) {
                out.writeInt(1);
                CacheUtil.writeAST(out, child);
            }
            if ((node = node.getNextSibling()) == null) continue;
            out.writeInt(2);
            out.writeObject(node);
        } while (node != null);
        out.writeInt(3);
    }

    private static void readTree(ObjectInputStream in, AST root) throws IOException, ClassNotFoundException {
        assert (root != null) : "there must be something to read";
        AST node = root;
        do {
            int kind = in.readInt();
            switch (kind) {
                case 3: {
                    return;
                }
                case 1: {
                    node.setFirstChild(CacheUtil.readAST(in));
                    break;
                }
                case 2: {
                    AST sibling = (AST)in.readObject();
                    node.setNextSibling(sibling);
                    node = sibling;
                    break;
                }
                default: {
                    assert (false);
                    {
                        break;
                    }
                }
            }
        } while (node != null);
    }
}

