/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContentSignature;
import org.netbeans.modules.cnd.modelimpl.content.project.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;

public final class DeepReparsingUtils {
    private static final Logger LOG = Logger.getLogger("DeepReparsingUtils");
    private static final boolean TRACE = LOG.isLoggable(Level.FINE);

    private DeepReparsingUtils() {
    }

    private static void reparseOnlyOneFile(ProjectBase project, FileImpl fileImpl) {
        DeepReparsingUtils.checkFileState(fileImpl, "reparseOnlyOneFile");
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnlyOneFile {0}", fileImpl.getAbsolutePath());
        }
        project.markAsParsingPreprocStates(fileImpl);
        fileImpl.markReparseNeeded(false);
        ParserQueue.instance().addToBeParsedNext(fileImpl);
    }

    static void reparseOnUndoEditedFile(ProjectBase project, FileImpl fileImpl) {
        DeepReparsingUtils.checkFileState(fileImpl, "reparseOnUndoEditedFile");
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnUndoEditedFile {0}", fileImpl.getAbsolutePath());
        }
        DeepReparsingUtils.reparseOnlyOneFile(project, fileImpl);
    }

    static void reparseOnEditingFile(ProjectBase project, FileImpl fileImpl) {
        DeepReparsingUtils.checkFileState(fileImpl, "reparseOnEditingFile");
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnEditingFile {0}", fileImpl.getAbsolutePath());
        }
        DeepReparsingUtils.reparseOnlyOneFile(project, fileImpl);
    }

    public static void tryPartialReparseOnChangedFile(ProjectBase changedFileProject, FileImpl fileImpl) {
        DeepReparsingUtils.checkFileState(fileImpl, "changedFileProject");
        if (TRACE) {
            LOG.log(Level.INFO, "tryPartialReparseOnChangedFile {0}", fileImpl.getAbsolutePath());
        }
        changedFileProject.markAsParsingPreprocStates(fileImpl);
        fileImpl.markReparseNeeded(true);
        ParserQueue.instance().addForPartialReparse(fileImpl);
    }

    static boolean finishPartialReparse(FileImpl fileImpl, FileContentSignature lastFileBasedSignature, FileContentSignature newSignature) {
        FileContentSignature.ComparisonResult compareResult = FileContentSignature.compare(newSignature, lastFileBasedSignature);
        if (compareResult == FileContentSignature.ComparisonResult.SAME) {
            if (TRACE) {
                LOG.log(Level.INFO, "partial reparseOnChangedFile was enough for {0}", fileImpl.getAbsolutePath());
            }
            return true;
        }
        if (fileImpl.isSourceFile() && compareResult == FileContentSignature.ComparisonResult.FILE_LOCAL_CHANGE) {
            if (TRACE) {
                LOG.log(Level.INFO, "partial reparseOnChangedFile was enough for changed src {0}", fileImpl.getAbsolutePath());
            }
            return true;
        }
        if (TRACE) {
            LOG.log(Level.INFO, "partial reparseOnChangedFile results in changed signature for {0}:\n{1}", new Object[]{fileImpl.getAbsolutePath(), FileContentSignature.testDifference(newSignature, lastFileBasedSignature)});
        }
        DeepReparsingUtils.reparseOnChangedFileImpl(fileImpl.getProjectImpl(true), fileImpl, false, lastFileBasedSignature);
        return false;
    }

    static void fullReparseOnChangedFile(ProjectBase changedFileProject, FileImpl fileImpl) {
        DeepReparsingUtils.reparseOnChangedFileImpl(changedFileProject, fileImpl, false, null);
    }

    private static void reparseOnChangedFileImpl(ProjectBase changedFileProject, FileImpl changedFile, boolean contentChanged, FileContentSignature lastFileBasedSignature) {
        if (TRACE) {
            LOG.log(Level.INFO, "full reparseOnChangedFile {0}", changedFile.getAbsolutePath());
        }
        if (contentChanged) {
            APTDriver.invalidateAPT((APTFileBuffer)changedFile.getBuffer());
        }
        boolean scheduleParsing = true;
        GraphContainer.ParentFiles top = changedFileProject.getGraph().getTopParentFiles(changedFile);
        Set<CsmFile> cuStartFiles = top.getCompilationUnits();
        Set<CsmFile> parents = top.getParentFiles();
        if (cuStartFiles.size() > 0) {
            Set<CsmFile> coherenceFiles;
            changedFile.clearStateCache();
            GraphContainer.CoherenceFiles coherence = changedFileProject.getGraph().getCoherenceFiles(changedFile);
            Set<CsmFile> affectedFiles = coherenceFiles = coherence.getCoherenceFiles();
            if (lastFileBasedSignature != null) {
                GraphContainer.CoherenceFiles oldCoherence = lastFileBasedSignature.getCoherenceFiles();
                Set<CsmFile> oldCoherenceFiles = oldCoherence.getCoherenceFiles();
                oldCoherenceFiles.removeAll(coherenceFiles);
                for (CsmFile file : oldCoherenceFiles) {
                    FileImpl impl = (FileImpl)file;
                    GraphContainer.ParentFiles orphanCandidateTop = changedFileProject.getGraph().getTopParentFiles(impl);
                    Set<CsmFile> parentOrphanFiles = orphanCandidateTop.getParentFiles();
                    if (parentOrphanFiles.size() == 1 && parentOrphanFiles.contains(impl)) {
                        changedFileProject.markAsParsingPreprocStates(impl);
                        if (!scheduleParsing) continue;
                        ParserQueue.instance().add(impl, changedFileProject.getPreprocHandlersForParse(impl, Interrupter.DUMMY), ParserQueue.Position.HEAD);
                        continue;
                    }
                    Set<CsmFile> startFilesForRemainingDetached = orphanCandidateTop.getCompilationUnits();
                    GraphContainer.CoherenceFiles coherenceOfDetached = changedFileProject.getGraph().getCoherenceFiles(impl);
                    Set<CsmFile> coherenceOfDetachedFiles = coherenceOfDetached.getCoherenceFiles();
                    cuStartFiles.addAll(startFilesForRemainingDetached);
                    affectedFiles.addAll(coherenceOfDetachedFiles);
                }
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(affectedFiles, cuStartFiles);
            for (CsmFile file : affectedFiles) {
                if (cuStartFiles.contains(file)) {
                    ((FileImpl)file).clearStateCache();
                    continue;
                }
                if (parents.contains(file)) {
                    ((FileImpl)file).clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(changedFileProject, file);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(changedFileProject, file);
            }
            if (scheduleParsing) {
                DeepReparsingUtils.addToReparse(changedFileProject, cuStartFiles, new HashSet<CsmFile>(0), false);
            }
        } else if (scheduleParsing) {
            ParserQueue.instance().add(changedFile, changedFileProject.getPreprocHandlersForParse(changedFile, Interrupter.DUMMY), ParserQueue.Position.HEAD);
        }
    }

    static void reparseOnEdit(Collection<FileImpl> toReparse, ProjectBase project, boolean scheduleParsing) {
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnEdit {0}", DeepReparsingUtils.toString(toReparse));
        }
        HashSet<CsmUID<CsmFile>> topParents = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> parents = new HashSet<CsmUID<CsmFile>>();
        HashSet<CsmUID<CsmFile>> coherence = new HashSet<CsmUID<CsmFile>>();
        for (FileImpl fileImpl : toReparse) {
            GraphContainer.ParentFiles parentFiles = project.getGraph().getTopParentFiles(fileImpl);
            Set<CsmUID<CsmFile>> units = parentFiles.getCompilationUnitsUids();
            if (units.size() > 0) {
                topParents.addAll(units);
                parents.addAll(parentFiles.getParentFilesUids());
                coherence.addAll(project.getGraph().getCoherenceFiles(fileImpl).getCoherenceFilesUids());
                continue;
            }
            if (!scheduleParsing) continue;
            ParserQueue.instance().add(fileImpl, project.getPreprocHandlersForParse(fileImpl, Interrupter.DUMMY), ParserQueue.Position.HEAD);
        }
        if (topParents.size() > 0) {
            CsmFile fileImpl;
            HashSet<CsmFile> topParentsImpl = new HashSet<CsmFile>();
            for (CsmUID csmUID : coherence) {
                fileImpl = UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (fileImpl == null) continue;
                DeepReparsingUtils.updateStartFilesWithBestStartFiles(Collections.singleton(fileImpl), topParentsImpl);
            }
            for (CsmUID csmUID : coherence) {
                fileImpl = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (fileImpl == null) continue;
                if (topParents.contains(csmUID)) {
                    topParentsImpl.add(fileImpl);
                    fileImpl.clearStateCache();
                    continue;
                }
                if (parents.contains(csmUID)) {
                    fileImpl.clearStateCache();
                    DeepReparsingUtils.invalidateFileAndPreprocState(project, fileImpl);
                    continue;
                }
                DeepReparsingUtils.invalidateFileAndPreprocState(project, fileImpl);
            }
            if (scheduleParsing) {
                DeepReparsingUtils.addToReparse(project, topParentsImpl, new HashSet<CsmFile>(0), false);
            }
        }
    }

    private static void gatherCoherenceLibrary(Set<CsmFile> coherenceLibrary) {
        while (true) {
            HashSet<CsmFile> newCoherenceLibrary = new HashSet<CsmFile>();
            for (CsmFile coherence : coherenceLibrary) {
                newCoherenceLibrary.add(coherence);
                ProjectBase coherenceProject = (ProjectBase)coherence.getProject();
                newCoherenceLibrary.addAll(coherenceProject.getGraph().getIncludedFiles(coherence));
            }
            if (newCoherenceLibrary.size() == coherenceLibrary.size()) {
                return;
            }
            coherenceLibrary.addAll(newCoherenceLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reparseOnPropertyChanged(Collection<NativeFileItem> items, ProjectBase changedProject, boolean invalidateLibs) {
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnPropertyChanged {0}{1}", new Object[]{invalidateLibs ? "With Invalidating Libs " : "", DeepReparsingUtils.toString(items)});
        }
        try {
            ParserQueue.instance().onStartAddingProjectFiles(changedProject);
            HashMap<FileImpl, NativeFileItem> pairs = new HashMap<FileImpl, NativeFileItem>();
            HashSet<CsmFile> cuStartFiles = new HashSet<CsmFile>();
            HashSet<CsmFile> coherence = new HashSet<CsmFile>();
            HashSet<CsmFile> coherenceLibrariesFiles = new HashSet<CsmFile>();
            for (NativeFileItem item : items) {
                FileImpl file;
                if (!Utils.acceptNativeItem(item) || (file = changedProject.getFile(item.getAbsolutePath(), false)) == null) continue;
                file.clearStateCache();
                pairs.put(file, item);
                cuStartFiles.addAll(changedProject.getGraph().getTopParentFiles(file).getCompilationUnits());
                coherence.addAll(changedProject.getGraph().getIncludedFiles(file));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(coherence, cuStartFiles);
            for (CsmFile file : coherence) {
                if (cuStartFiles.contains(file)) continue;
                if (changedProject.equals(file.getProject())) {
                    DeepReparsingUtils.invalidateFileAndPreprocState(changedProject, file);
                    continue;
                }
                coherenceLibrariesFiles.add(file);
            }
            if (!TraceFlags.DEEP_REPARSING_OPTIMISTIC) {
                DeepReparsingUtils.gatherCoherenceLibrary(coherenceLibrariesFiles);
                DeepReparsingUtils.invalidateFileAndPreprocState(coherenceLibrariesFiles);
            }
            for (CsmFile parent : cuStartFiles) {
                FileImpl parentImpl = (FileImpl)parent;
                if (pairs.containsKey(parentImpl)) {
                    NativeFileItem item = (NativeFileItem)pairs.get(parentImpl);
                    DeepReparsingUtils.addToReparse(changedProject, item, parentImpl);
                    continue;
                }
                DeepReparsingUtils.addCompilationUnitToReparse(parentImpl, true);
            }
            if (invalidateLibs) {
                if (TRACE) {
                    LOG.log(Level.INFO, "reparseOnPropertyChanged invalidates all libraries for {0}", changedProject);
                }
                assert (changedProject instanceof ProjectImpl) : "should be ProjectImpl: " + changedProject;
                LibraryManager.getInstance(changedProject.getUnitId()).onProjectPropertyChanged(changedProject);
            }
        }
        catch (Exception e) {
            DiagnosticExceptoins.register(e);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(changedProject);
        }
    }

    public static void reparseOnAdded(FileObject addedFile, ProjectBase project) {
        DeepReparsingUtils.reparseOnAdded(Collections.singleton(addedFile.getNameExt()), project);
    }

    static void reparseOnAdded(List<NativeFileItem> toReparse, ProjectBase project) {
        HashSet<String> names = new HashSet<String>();
        for (NativeFileItem item : toReparse) {
            names.add(item.getName());
        }
        DeepReparsingUtils.reparseOnAdded(names, project);
    }

    private static void reparseOnAdded(Set<String> names, ProjectBase project) {
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnAdded {0}", DeepReparsingUtils.toString(names));
        }
        HashSet<CsmFile> resolved = new HashSet<CsmFile>();
        for (CsmFile file : project.getAllFiles()) {
            DeepReparsingUtils.findResolved(names, resolved, file);
        }
        if (resolved.size() > 0) {
            HashSet<CsmFile> top = new HashSet<CsmFile>();
            HashSet<CsmFile> coherence = new HashSet<CsmFile>();
            for (CsmFile file : resolved) {
                top.addAll(project.getGraph().getTopParentFiles(file).getCompilationUnits());
                coherence.add(file);
                coherence.addAll(project.getGraph().getIncludedFiles(file));
            }
            DeepReparsingUtils.updateStartFilesWithBestStartFiles(coherence, top);
            DeepReparsingUtils.addToReparse(project, top, coherence, true);
        }
    }

    private static void findResolved(Set<String> names, Set<CsmFile> resolved, CsmFile file) {
        for (CsmInclude incl : file.getIncludes()) {
            String name = incl.getIncludeName().toString();
            int i = Math.max(name.lastIndexOf(92), name.lastIndexOf(47));
            if (i > 0) {
                name = name.substring(i);
            }
            if (!names.contains(name)) continue;
            resolved.add(file);
            break;
        }
    }

    static void reparseOnRemoved(Collection<FileImpl> removedPhysically, Collection<FileImpl> removedAsExcluded, ProjectBase project) {
        if (TRACE) {
            LOG.log(Level.INFO, "reparseOnRemoved \nPHYSICAL:{0}\nEXCLUDED:{1}", new Object[]{DeepReparsingUtils.toString(removedPhysically), DeepReparsingUtils.toString(removedAsExcluded)});
        }
        CndFileUtils.clearFileExistenceCache();
        HashSet<CsmFile> topParents = new HashSet<CsmFile>();
        HashSet<CsmFile> coherence = new HashSet<CsmFile>();
        for (FileImpl impl : removedPhysically) {
            if (impl == null) continue;
            topParents.addAll(project.getGraph().getTopParentFiles(impl).getCompilationUnits());
            coherence.addAll(project.getGraph().getCoherenceFiles(impl).getCoherenceFiles());
            project.getGraph().removeFile(impl);
            topParents.remove(impl);
            coherence.remove(impl);
        }
        for (FileImpl impl : removedAsExcluded) {
            project.getGraph().removeFile(impl);
            topParents.remove(impl);
            coherence.remove(impl);
        }
        DeepReparsingUtils.addToReparse(project, topParents, coherence, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToReparse(ProjectBase changedFileProject, Set<CsmFile> cuStartFiles, Set<CsmFile> coherence, boolean invalidateCache) {
        for (CsmFile incl : coherence) {
            if (cuStartFiles.contains(incl) || incl.getProject() != changedFileProject) continue;
            DeepReparsingUtils.invalidateFileAndPreprocState(changedFileProject, incl);
        }
        if (!cuStartFiles.isEmpty()) {
            try {
                ParserQueue.instance().onStartAddingProjectFiles(changedFileProject);
                for (CsmFile parent : cuStartFiles) {
                    FileImpl parentImpl = (FileImpl)parent;
                    DeepReparsingUtils.addCompilationUnitToReparse(parentImpl, invalidateCache);
                }
            }
            catch (Exception e) {
                DiagnosticExceptoins.register(e);
            }
            finally {
                ParserQueue.instance().onEndAddingProjectFiles(changedFileProject);
            }
        }
    }

    private static void addCompilationUnitToReparse(FileImpl fileImpl, boolean invalidateCache) {
        ProjectBase project = fileImpl.getProjectImpl(true);
        project.markAsParsingPreprocStates(fileImpl);
        fileImpl.markReparseNeeded(invalidateCache);
        ParserQueue.instance().add(fileImpl, fileImpl.getPreprocHandlersForParse(Interrupter.DUMMY), ParserQueue.Position.HEAD);
        if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
            System.out.println("Add file to reparse " + fileImpl.getAbsolutePath() + " from " + project);
        }
    }

    private static void addToReparse(ProjectBase project, NativeFileItem nativeFile, FileImpl file) {
        if (nativeFile.getFileObject() != null && nativeFile.getFileObject().isValid()) {
            file.markReparseNeeded(true);
            PreprocHandler.State state = project.setChangedFileState(nativeFile);
            if (state == null) {
                CndUtils.assertTrue((!file.isValid() ? 1 : 0) != 0, (String)"setChangedFileState returned null for valid file ", (Object)file);
            } else {
                if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                    System.out.println("Add file to reparse " + file.getAbsolutePath() + " from " + project);
                }
                ParserQueue.instance().add(file, state, ParserQueue.Position.HEAD);
            }
        } else assert (false);
    }

    private static void invalidateFileAndPreprocState(ProjectBase changedFileProject, CsmFile file) {
        FileImpl fileImpl = (FileImpl)file;
        ProjectBase fileProject = fileImpl.getProjectImpl(true);
        if (changedFileProject != null && fileProject != null && changedFileProject != fileProject && fileProject.isArtificial()) {
            return;
        }
        if (fileProject != null) {
            fileImpl.clearStateCache();
            fileProject.invalidatePreprocState(fileImpl.getAbsolutePath());
            fileImpl.markReparseNeeded(false);
            if (TraceFlags.USE_DEEP_REPARSING_TRACE) {
                System.out.println("Invalidate file to reparse " + file.getAbsolutePath() + " from " + fileProject);
            }
        }
    }

    private static void invalidateFileAndPreprocState(Set<CsmFile> coherenceLibrary) {
        for (CsmFile parent : coherenceLibrary) {
            CsmProject project = parent.getProject();
            if (!(project instanceof ProjectBase)) continue;
            FileImpl parentImpl = (FileImpl)parent;
            parentImpl.clearStateCache();
            ((ProjectBase)project).invalidatePreprocState(parentImpl.getAbsolutePath());
            parentImpl.markReparseNeeded(false);
            if (!TraceFlags.USE_DEEP_REPARSING_TRACE) continue;
            System.out.println("Invalidate file to reparse " + parent.getAbsolutePath() + " from " + project);
        }
    }

    private static void updateStartFilesWithBestStartFiles(Set<CsmFile> coherence, Set<CsmFile> cuStartFiles) {
        for (CsmFile csmFile : coherence) {
            if (cuStartFiles.contains(csmFile)) continue;
            Collection compilationUnits = CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0);
            for (CsmCompilationUnit cu : compilationUnits) {
                CsmFile startFile = cu.getStartFile();
                if (startFile == null) continue;
                cuStartFiles.add(startFile);
            }
        }
    }

    public static String toString(Collection<?> files) {
        StringBuilder out = new StringBuilder();
        for (Object elem : files) {
            if (elem instanceof FileImpl) {
                out.append(((FileImpl)elem).getAbsolutePath());
                continue;
            }
            if (elem instanceof NativeFileItem) {
                out.append(((NativeFileItem)elem).getAbsolutePath());
                continue;
            }
            out.append(elem.toString());
        }
        return out.toString();
    }

    private static void checkFileState(FileImpl fileImpl, String msg) {
        if (fileImpl.getState() == FileImpl.State.INITIAL) {
            LOG.log(Level.INFO, "{0} for INITIAL {1}", new Object[]{msg, fileImpl.getAbsolutePath()});
        }
    }
}

