/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.spi;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.openide.util.Lookup;

public abstract class CsmParserProvider {
    public static final CsmParserProvider DEFAULT = new Default();

    public static CsmParser createParser(final CsmFile file) {
        return CsmParserProvider.createParser(new CsmParserParameters(){

            @Override
            public CsmFile getMainFile() {
                return file;
            }

            @Override
            public String getLanguage() {
                return Utils.getLanguage(file.getFileType(), file.getAbsolutePath().toString());
            }

            @Override
            public String getLanguageFlavor() {
                if (file instanceof FileImpl) {
                    return ((FileImpl)file).getFileLanguageFlavor();
                }
                return "";
            }
        });
    }

    public static CsmParser createParser(CsmParserParameters params) {
        return DEFAULT.create(params);
    }

    protected abstract CsmParser create(CsmParserParameters var1);

    public static void registerParserError(ParserErrorDelegate delegate, String message, CsmFile file, int offset) {
        if (file != null) {
            int[] lineColumn = ((FileImpl)file).getLineColumn(offset);
            String s = file.getAbsolutePath() + ":" + lineColumn[0] + ":" + lineColumn[1] + ": error: " + message;
            delegate.onError(new ParserError(s, lineColumn[0], lineColumn[1], "", offset < 0));
        } else {
            delegate.onError(new ParserError(message, -1, -1, "", offset < 0));
        }
    }

    private static final class Default
    extends CsmParserProvider {
        private final Collection<? extends CsmParserProvider> parserProviders = Lookup.getDefault().lookupAll(CsmParserProvider.class);

        @Override
        protected CsmParser create(CsmParserParameters params) {
            for (CsmParserProvider csmParserProvider : this.parserProviders) {
                CsmParser out = csmParserProvider.create(params);
                if (out == null) continue;
                return out;
            }
            return null;
        }
    }

    public static interface ParserErrorDelegate {
        public void onError(ParserError var1);
    }

    public static final class ParserError {
        public String message;
        public String tokenText;
        public int line;
        public int column;
        public boolean eof;

        public ParserError(String message, int line, int column, String tokenText, boolean eof) {
            this.message = message;
            this.line = line;
            this.column = column;
            this.tokenText = tokenText;
            this.eof = eof;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public String getMessage() {
            return this.message;
        }

        public String getTokenText() {
            return this.tokenText;
        }

        public boolean isEof() {
            return this.eof;
        }

        public String toString() {
            return this.message;
        }
    }

    public static interface CsmParserResult {
        public void render(Object ... var1);

        public boolean isEmptyAST();

        public Object getAST();

        public void dumpAST();

        public int getErrorCount();
    }

    public static interface CsmParser {
        public void init(CsmObject var1, TokenStream var2, CsmParseCallback var3);

        public CsmParserResult parse(ConstructionKind var1);

        public void setErrorDelegate(ParserErrorDelegate var1);

        public static enum ConstructionKind {
            TRANSLATION_UNIT,
            TRANSLATION_UNIT_WITH_COMPOUND,
            CLASS_BODY,
            ENUM_BODY,
            TRY_BLOCK,
            COMPOUND_STATEMENT,
            INITIALIZER,
            NAMESPACE_DEFINITION_BODY,
            FUNCTION_DEFINITION_AFTER_DECLARATOR;

        }
    }

    public static interface CsmParserParameters {
        public CsmFile getMainFile();

        public String getLanguage();

        public String getLanguageFlavor();
    }

    public static interface CsmParseCallback {
    }
}

