/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static final Map<ClassLoader, Map<String, Object>> applicationMaps = new HashMap<ClassLoader, Map<String, Object>>();
    private static final String[] FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map<String, Class> factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String factoryName) throws FacesException {
        FactoryFinder.validateFactoryName(factoryName);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<ClassLoader, Map<String, Object>> map = applicationMaps;
        synchronized (map) {
            Map<String, Object> appMap = FactoryFinder.getApplicationMap();
            Object factoryOrList = appMap.get(factoryName);
            if (factoryOrList != null && !(factoryOrList instanceof List)) {
                return factoryOrList;
            }
            Object factory = FactoryFinder.getImplementationInstance(classLoader, factoryName, (List)factoryOrList);
            if (null == factory) {
                ResourceBundle rb = LOGGER.getResourceBundle();
                String message = rb.getString("severe.no_factory");
                message = MessageFormat.format(message, factoryName);
                throw new IllegalStateException(message);
            }
            appMap.put(factoryName, factory);
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String factoryName, String implName) {
        FactoryFinder.validateFactoryName(factoryName);
        Map<ClassLoader, Map<String, Object>> map = applicationMaps;
        synchronized (map) {
            Map<String, Object> appMap = FactoryFinder.getApplicationMap();
            ArrayList previouslySetFactories = appMap.get(factoryName);
            if (null != previouslySetFactories) {
                if (!(previouslySetFactories instanceof List)) {
                    return;
                }
            } else {
                previouslySetFactories = new ArrayList();
                appMap.put(factoryName, previouslySetFactories);
            }
            TypedCollections.dynamicallyCastList(previouslySetFactories, String.class).add(0, implName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseFactories() throws FacesException {
        ClassLoader cl = FactoryFinder.getClassLoader();
        Map<ClassLoader, Map<String, Object>> map = applicationMaps;
        synchronized (map) {
            HashMap map2 = (HashMap)applicationMaps.get(cl);
            if (map2 != null) {
                map2.clear();
                applicationMaps.remove(cl);
            }
        }
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            throw new FacesException("getContextClassLoader");
        }
        return cl;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String factoryName, List implementations) throws FacesException {
        String curImplClass;
        int len;
        Object result = null;
        if (null != implementations && (1 < (len = implementations.size()) || 1 == len)) {
            curImplClass = (String)implementations.remove(len - 1);
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, null);
        }
        if (null != (curImplClass = FactoryFinder.getImplNameFromServices(classLoader, factoryName))) {
            result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
        }
        if (null != implementations) {
            for (len = implementations.size() - 1; 0 <= len; --len) {
                curImplClass = (String)implementations.remove(len);
                result = FactoryFinder.getImplGivenPreviousImpl(classLoader, factoryName, curImplClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getImplNameFromServices(ClassLoader classLoader, String factoryName) {
        String result;
        block27: {
            result = null;
            BufferedReader reader = null;
            String resourceName = "META-INF/services/" + factoryName;
            InputStream stream = null;
            try {
                stream = classLoader.getResourceAsStream(resourceName);
                if (stream == null) break block27;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(stream));
                }
                result = reader.readLine();
            }
            catch (IOException e) {
            }
            catch (SecurityException e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable t) {}
                    reader = null;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {}
                    stream = null;
                }
            }
        }
        return result;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String factoryName, String implName, Object previousImpl) {
        Class<?> clazz;
        Class factoryClass = null;
        Object[] newInstanceArgs = new Object[1];
        Object result = null;
        if (null != previousImpl && null != (factoryClass = FactoryFinder.getFactoryClass(classLoader, factoryName))) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                Class[] getCtorArg = new Class[]{factoryClass};
                Constructor<?> ctor = clazz.getConstructor(getCtorArg);
                newInstanceArgs[0] = previousImpl;
                result = ctor.newInstance(newInstanceArgs);
            }
            catch (NoSuchMethodException nsme) {
                factoryClass = null;
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        if (null == previousImpl || null == factoryClass) {
            try {
                clazz = Class.forName(implName, false, classLoader);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new FacesException(implName, e);
            }
        }
        return result;
    }

    private static Class getFactoryClass(ClassLoader classLoader, String factoryClassName) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap<String, Class>(FACTORY_NAMES.length);
            factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
            factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
            factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
            factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        }
        return factoryClasses.get(factoryClassName);
    }

    private static Map<String, Object> getApplicationMap() {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        Map<String, Object> result = applicationMaps.get(classLoader);
        if (result == null) {
            result = new HashMap<String, Object>();
            applicationMaps.put(classLoader, result);
        }
        return result;
    }

    private static void validateFactoryName(String factoryName) {
        if (factoryName == null) {
            throw new NullPointerException();
        }
        boolean found = false;
        for (int i = 0; i < FACTORY_NAMES.length; ++i) {
            if (!factoryName.equals(FACTORY_NAMES[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(factoryName);
        }
    }
}

