/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.j2ee.weblogic9.VersionBridge;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.netbeans.modules.weblogic.common.api.Version;
import org.netbeans.modules.weblogic.common.api.WebLogicLayout;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ServerLocationVisual
extends JPanel {
    private static final FilenameFilter SERVER_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("wlserver");
        }
    };
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private transient WLInstantiatingIterator instantiatingIterator;
    private JFileChooser fileChooser;
    private ButtonGroup domainButtonGroup;
    private JLabel domainLabel;
    private JLabel downloadLabel;
    private JRadioButton localRadioButton;
    private JButton locationBrowseButton;
    private JTextField locationField;
    private JLabel locationLabel;
    private JRadioButton remoteRadioButton;

    public ServerLocationVisual(WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.setName(NbBundle.getMessage(ServerLocationVisual.class, (String)"SERVER_LOCATION_STEP"));
        this.initComponents();
        this.locationField.addKeyListener(new LocationKeyListener());
        String loc = WLPluginProperties.getLastServerRoot();
        if (loc != null) {
            this.locationField.setText(loc);
        }
        this.localRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerLocationVisual.this.fireChangeEvent();
            }
        });
        this.remoteRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerLocationVisual.this.fireChangeEvent();
            }
        });
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        File packed;
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        String location = this.getInstallLocation();
        if (location.trim().isEmpty()) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_EMPTY_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        File serverRoot = FileUtil.normalizeFile((File)new File(location));
        if ((serverRoot = ServerLocationVisual.findServerLocation(serverRoot, wizardDescriptor)) == null) {
            return false;
        }
        location = serverRoot.getPath();
        File weblogicJar = WebLogicLayout.getWeblogicJar((File)serverRoot);
        if (!weblogicJar.exists() && (packed = new File(serverRoot, "server/lib/weblogic.jar.pack")).isFile()) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_CONFIGURE", (Object)(Utilities.isWindows() ? "cmd" : "sh"));
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        Version version = WebLogicLayout.getServerVersion((File)serverRoot);
        if (!WebLogicLayout.isSupportedVersion((Version)version)) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_VERSION");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        if (!WebLogicLayout.isSupportedLayout((File)serverRoot)) {
            String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_ROOT");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
            return false;
        }
        WLPluginProperties.setLastServerRoot(location);
        this.instantiatingIterator.setServerRoot(location);
        this.instantiatingIterator.setServerVersion(VersionBridge.getVersion(version));
        this.instantiatingIterator.setRemote(this.remoteRadioButton.isSelected());
        return true;
    }

    public static File findServerLocation(File candidate, WizardDescriptor wizardDescriptor) {
        if (WebLogicLayout.isSupportedLayout((File)candidate)) {
            return candidate;
        }
        File[] files = candidate.listFiles(SERVER_FILTER);
        if (files != null) {
            if (files.length == 1) {
                return files[0];
            }
            for (File file : files) {
                if (!WebLogicLayout.isSupportedLayout((File)file)) continue;
                String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"WARN_CHILD_SERVER_ROOT", (Object)file.getPath());
                wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
                return file;
            }
        }
        String msg = NbBundle.getMessage(ServerLocationVisual.class, (String)"ERR_INVALID_SERVER_ROOT");
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(msg));
        return null;
    }

    private String getInstallLocation() {
        return this.locationField.getText();
    }

    private void showFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        this.fileChooser.setFileFilter(new DirectoryFileFilter());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileSelectionMode(1);
        File currentLocation = new File(this.locationField.getText());
        if (currentLocation.exists() && currentLocation.isDirectory()) {
            this.fileChooser.setCurrentDirectory(currentLocation.getParentFile());
            this.fileChooser.setSelectedFile(currentLocation);
        }
        if (this.fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.locationField.setText(this.fileChooser.getSelectedFile().getPath());
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.domainButtonGroup = new ButtonGroup();
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.locationBrowseButton = new JButton();
        this.downloadLabel = new JLabel();
        this.domainLabel = new JLabel();
        this.localRadioButton = new JRadioButton();
        this.remoteRadioButton = new JRadioButton();
        this.locationLabel.setLabelFor(this.locationField);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.locationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.locationBrowseButton, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.locationBrowseButton.text"));
        this.locationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLocationVisual.this.locationBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.downloadLabel, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.downloadLabel.text"));
        this.downloadLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ServerLocationVisual.this.downloadLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ServerLocationVisual.this.downloadLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ServerLocationVisual.this.downloadLabelMouseExited(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.domainLabel, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.domainLabel.text"));
        this.domainButtonGroup.add(this.localRadioButton);
        this.localRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.localRadioButton, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.localRadioButton.text"));
        this.domainButtonGroup.add(this.remoteRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteRadioButton, (String)NbBundle.getMessage(ServerLocationVisual.class, (String)"ServerLocationVisual.remoteRadioButton.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationField, -1, 204, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationBrowseButton)).addComponent(this.downloadLabel, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.domainLabel).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteRadioButton).addComponent(this.localRadioButton)))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2).addComponent(this.locationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.domainLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteRadioButton)));
        this.locationField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationField"));
        this.locationBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocationVisual.class, (String)"ACSD_ServerLocationPanel_locationBrowseButton"));
    }

    private void locationBrowseButtonActionPerformed(ActionEvent evt) {
        this.showFileChooser();
    }

    private void downloadLabelMouseEntered(MouseEvent evt) {
        this.downloadLabel.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void downloadLabelMouseExited(MouseEvent evt) {
        this.downloadLabel.setCursor(Cursor.getDefaultCursor());
    }

    private void downloadLabelMouseClicked(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://www.oracle.com/technetwork/middleware/weblogic/downloads/index.html"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class DirectoryFileFilter
    extends FileFilter {
        private DirectoryFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.exists() && file.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ServerLocationVisual.class, (String)"DIRECTORIES_FILTER_NAME");
        }
    }

    private class LocationKeyListener
    extends KeyAdapter {
        private LocationKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            ServerLocationVisual.this.fireChangeEvent();
        }

        @Override
        public void keyReleased(KeyEvent event) {
            ServerLocationVisual.this.fireChangeEvent();
        }
    }
}

