/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.push.impl;

import java.lang.reflect.Field;
import java.util.Map;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.handler.AnnotatedProxy;
import org.primefaces.push.annotation.PathParam;
import org.primefaces.push.annotation.PushEndpoint;
import org.primefaces.push.impl.PushEndpointHandlerProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AtmosphereInterceptorService
public class PushEndpointInterceptor
extends ManagedServiceInterceptor {
    private Logger logger = LoggerFactory.getLogger(PushEndpointInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mapAnnotatedService(boolean reMap, String path, AtmosphereRequest request, AtmosphereFramework.AtmosphereHandlerWrapper w) {
        Map map = this.config.handlers();
        synchronized (map) {
            String servletPath = (String)this.config.properties().get("servletPath");
            if (path.startsWith(servletPath)) {
                path = path.substring(servletPath.length());
            }
        }
        super.mapAnnotatedService(reMap, path, request, w);
    }

    protected AnnotatedProxy proxyHandler() throws IllegalAccessException, InstantiationException {
        return (AnnotatedProxy)this.config.framework().newClassInstance(AnnotatedProxy.class, PushEndpointHandlerProxy.class);
    }

    protected ManagedServiceInterceptor.ManagedAnnotation managed(AnnotatedProxy ap, final AtmosphereResource r) {
        final PushEndpoint a = ap.target().getClass().getAnnotation(PushEndpoint.class);
        if (a == null) {
            return null;
        }
        return new ManagedServiceInterceptor.ManagedAnnotation(){

            public String path() {
                return a.value();
            }

            public Class<? extends Broadcaster> broadcaster() {
                return r.getBroadcaster().getClass();
            }
        };
    }

    protected void injectPathParams(Object o, Map<String, String> annotatedPathVars) {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(PathParam.class)) continue;
            PathParam annotation = field.getAnnotation(PathParam.class);
            String name = annotation.value();
            if (name.isEmpty()) {
                name = field.getName();
            }
            if (annotatedPathVars.containsKey(name)) {
                try {
                    this.logger.debug("Annotating field {}", (Object)name);
                    field.setAccessible(true);
                    field.set(o, annotatedPathVars.get(name));
                }
                catch (Exception e) {
                    this.logger.error("Error processing @PathVariable annotation", (Throwable)e);
                }
                continue;
            }
            this.logger.error("No path marker found for PathVariable {}, class {}", (Object)field.getName(), o.getClass());
        }
    }

    public String toString() {
        return "@PushEndpoint Interceptor";
    }
}

