/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.packager;

import com.sun.javacard.converter.ConverterHarness;
import com.sun.javacard.packager.ErrorKey;
import com.sun.javacard.packager.model.AppletXML;
import com.sun.javacard.packager.model.ClassicLibrary;
import com.sun.javacard.packager.model.ClassicModule;
import com.sun.javacard.packager.model.ClassicModuleJCRD;
import com.sun.javacard.packager.model.FolderOrJar;
import com.sun.javacard.packager.model.PackageItem;
import com.sun.javacard.packager.model.Signer;
import com.sun.javacard.tools.util.JCToolsLogger;
import com.sun.javacard.util.AIDUtils;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Packager
extends PackageItem {
    private static Packager packager = new Packager();
    private boolean verbose;
    private String type;
    private String packageAID;
    private String exportPath;
    private File out;
    private boolean force = false;
    private boolean compress = false;
    private boolean useProxyClass = false;
    private FolderOrJar packageItem;
    private Signer signer = new Signer();
    private File workDir = null;
    private File converterWorkSpace = null;
    private String keepDir = null;

    public static Packager getPackager() {
        return packager;
    }

    private Packager() {
    }

    @Override
    public String getItemDisplayName() {
        return "Packager";
    }

    @Override
    public void initialize() {
        this.createWorkDir();
        if (this.isSign()) {
            this.addItem(this.signer);
            this.signer.initialize();
        }
        if (this.packageItem == null) {
            this.addError(ErrorKey.NoPackageItemSpecified, new Object[0]);
        } else {
            this.addItem(this.packageItem);
            this.packageItem.initialize();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processInternal() {
        Object object;
        String string;
        Vector<String> vector;
        String string2 = "";
        JCToolsLogger jCToolsLogger = JCToolsLogger.getLogger("test");
        if (this.packageItem != null) {
            this.packageItem.process();
        }
        if (!this.isOk(true)) {
            return;
        }
        if (this.out.exists()) {
            if (this.isForce()) {
                this.addWarning(ErrorKey.OutputFileWillBeOverWritten, this.out.getAbsolutePath());
            } else {
                this.addError(ErrorKey.CanNotOverWriteOutputFile, this.out.getAbsolutePath());
                return;
            }
        }
        if (this.type.equals("classic-applet")) {
            Serializable serializable;
            Object object2;
            this.converterWorkSpace = null;
            vector = new Vector();
            string = "";
            object = "";
            for (PackageItem packageItem : this.items) {
                if (!(packageItem instanceof ClassicModule)) continue;
                object2 = FileUtils.listAllFilesInFolder(((ClassicModule)packageItem).getFolder(), ".class");
                serializable = new HashSet<String>();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    void var11_24;
                    File n2 = ((Vector)object2).elementAt(i).getParentFile();
                    if (n2.getName().equals("proxy")) {
                        File n = n2.getParentFile();
                    }
                    serializable.add(var11_24.getAbsolutePath());
                }
                if (serializable.size() > 1) {
                    this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
                    return;
                }
                for (PackageItem packageItem2 : packageItem.getItems()) {
                    if (packageItem2 instanceof AppletXML) {
                        string = ((AppletXML)packageItem2).getPackageName();
                        vector = ((AppletXML)packageItem2).getAppletInfo();
                        continue;
                    }
                    if (!(packageItem2 instanceof ClassicModuleJCRD)) continue;
                    object = ((ClassicModuleJCRD)packageItem2).getAID();
                }
            }
            this.converterWorkSpace = new File(System.getProperty("java.io.tmpdir") + "converterWorkSpace_" + System.currentTimeMillis()).getAbsoluteFile();
            if (!this.converterWorkSpace.mkdirs()) {
                this.addError(ErrorKey.UnableToCreateWorkingFolder, this.converterWorkSpace);
                return;
            }
            Vector vector2 = new Vector();
            vector2.add("-i");
            if (packager.isUseProxyClass()) {
                vector2.add("-useproxyclass");
            }
            vector2.add("-exportpath");
            string2 = System.getProperty("jc.home");
            if (string2 == null) {
                this.addError(ErrorKey.JCHomeNotSet, new Object[0]);
                return;
            }
            vector2.add(string2 + "/api_export_files" + (this.getExportPath() != null ? ";" + this.getExportPath() : ""));
            vector2.add("-classdir");
            vector2.add(this.getWorkDir() + "/APPLET-INF/classes");
            vector2.add("-d");
            vector2.add(this.converterWorkSpace.getAbsolutePath());
            if (packager.getKeepDir() != null) {
                vector2.add("-keepproxysource");
                vector2.add(packager.getKeepDir());
            }
            int n = 0;
            while (n < vector.size()) {
                vector2.add("-applet");
                object2 = vector.elementAt(n++);
                vector2.add(AIDUtils.getAsPrintableHex((String)object2));
                vector2.add(vector.elementAt(n++));
            }
            vector2.add(string);
            vector2.add(AIDUtils.getAsPrintableHex((String)object));
            vector2.add("1.0");
            String[] stringArray = new String[vector2.size()];
            ConverterHarness.startConversion(vector2.toArray(stringArray), null);
            object2 = new StringBuffer();
            serializable = new StringBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            ((StringBuffer)object2).append(this.converterWorkSpace.getAbsolutePath());
            ((StringBuffer)object2).append("/");
            ((StringBuffer)object2).append(string.replace('.', '/'));
            stringBuffer.append((StringBuffer)object2);
            stringBuffer.append("/proxy");
            ((StringBuffer)object2).append("/javacard/");
            int n2 = string.lastIndexOf(".");
            if (n2 == -1) {
                ((StringBuffer)object2).append(string);
            } else {
                ((StringBuffer)object2).append(string.substring(n2 + 1));
            }
            ((StringBuffer)serializable).append((StringBuffer)object2);
            ((StringBuffer)object2).append(".cap");
            ((StringBuffer)serializable).append(".exp");
            try {
                FileUtils.copyFile(new File(((StringBuffer)object2).toString()), this.out.getAbsoluteFile());
                String string3 = this.out.getAbsolutePath();
                int n3 = string3.lastIndexOf(".cap");
                if (n3 != -1) {
                    string3 = string3.substring(0, n3);
                }
                File file = this.out.getParentFile();
                File file2 = new File(file, string.replace('.', File.separatorChar));
                file2 = new File(file2, "javacard");
                file2.mkdirs();
                FileUtils.copyFile(new File(((StringBuffer)serializable).toString()), new File(file2, new File(((StringBuffer)serializable).toString()).getName()));
                this.extractClassesAndPutAlongWithExpFile(this.out.getParentFile(), this.out, false);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnableToWriteTheContents, exception.getMessage());
                return;
            }
        }
        if (this.type.equals("classic-lib")) {
            Object object2;
            Serializable serializable;
            Serializable serializable2;
            Object object5;
            String[] stringArray22;
            this.converterWorkSpace = null;
            vector = new Vector();
            string = "";
            object = this.getPackageAID();
            if (object == null) {
                this.addError(ErrorKey.PackageAIDNotSpecified, new Object[0]);
                return;
            }
            for (String[] stringArray22 : this.items) {
                if (!(stringArray22 instanceof ClassicLibrary)) continue;
                object5 = (ClassicLibrary)stringArray22;
                serializable2 = FileUtils.listAllFilesInFolder(((FolderOrJar)object5).getFolder(), ".class");
                serializable = new HashSet<String>();
                for (int i = 0; i < ((Vector)serializable2).size(); ++i) {
                    object2 = ((Vector)serializable2).elementAt(i).getParentFile();
                    if (((File)object2).getName().equals("proxy")) {
                        object2 = ((File)object2).getParentFile();
                    }
                    serializable.add(((File)object2).getAbsolutePath());
                }
                if (serializable.size() > 1) {
                    this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
                    return;
                }
                string = this.findPackage(((FolderOrJar)object5).getFolder());
            }
            this.converterWorkSpace = new File(System.getProperty("java.io.tmpdir") + "converterWorkSpace_" + System.currentTimeMillis()).getAbsoluteFile();
            if (!this.converterWorkSpace.mkdirs()) {
                this.addError(ErrorKey.UnableToCreateWorkingFolder, this.converterWorkSpace);
                return;
            }
            Vector vector3 = new Vector();
            vector3.add("-i");
            vector3.add("-exportpath");
            string2 = System.getProperty("jc.home");
            if (string2 == null) {
                this.addError(ErrorKey.JCHomeNotSet, new Object[0]);
                return;
            }
            vector3.add(string2 + "/api_export_files" + (this.getExportPath() != null ? ";" + this.getExportPath() : ""));
            vector3.add("-classdir");
            vector3.add(this.getWorkDir().getAbsolutePath());
            vector3.add("-d");
            if (packager.getKeepDir() != null) {
                vector3.add(packager.getKeepDir());
            } else {
                vector3.add(this.converterWorkSpace.getAbsolutePath());
            }
            vector3.add(string);
            vector3.add(AIDUtils.getAsPrintableHex((String)object));
            vector3.add("1.0");
            stringArray22 = new String[vector3.size()];
            ConverterHarness.startConversion(vector3.toArray(stringArray22), null);
            object5 = new StringBuffer();
            serializable2 = new StringBuffer();
            serializable = new StringBuffer();
            if (packager.getKeepDir() != null) {
                ((StringBuffer)object5).append(packager.getKeepDir());
            } else {
                ((StringBuffer)object5).append(this.converterWorkSpace.getAbsolutePath());
            }
            ((StringBuffer)object5).append("/");
            ((StringBuffer)object5).append(string.replace('.', '/'));
            ((StringBuffer)serializable).append((StringBuffer)object5);
            ((StringBuffer)serializable).append("/proxy");
            ((StringBuffer)object5).append("/javacard/");
            int n = string.lastIndexOf(".");
            if (n == -1) {
                ((StringBuffer)object5).append(string);
            } else {
                ((StringBuffer)object5).append(string.substring(n + 1));
            }
            ((StringBuffer)serializable2).append((StringBuffer)object5);
            ((StringBuffer)object5).append(".cap");
            ((StringBuffer)serializable2).append(".exp");
            try {
                FileUtils.copyFile(new File(((StringBuffer)object5).toString()), this.out.getAbsoluteFile());
                object2 = this.out.getAbsolutePath();
                int n4 = ((String)object2).lastIndexOf(".cap");
                if (n4 != -1) {
                    object2 = ((String)object2).substring(0, n4);
                }
                File file = this.out.getParentFile();
                File file3 = new File(file, string.replace('.', File.separatorChar));
                file3 = new File(file3, "javacard");
                file3.mkdirs();
                FileUtils.copyFile(new File(((StringBuffer)serializable2).toString()), new File(file3, new File(((StringBuffer)serializable2).toString()).getName()));
                this.extractClassesAndPutAlongWithExpFile(this.out.getParentFile(), this.out, true);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.UnableToWriteTheContents, exception.getMessage());
                return;
            }
        }
        try {
            ZipUtils.zip(this.workDir, this.out, this.isCompress());
        }
        catch (Exception exception) {
            if (this.out.exists()) {
                this.out.delete();
            }
            this.addError(ErrorKey.UnableToZipTheContents, exception.getMessage());
            return;
        }
        if (this.workDir != null) {
            FileUtils.deleteDir(this.workDir);
        }
        if (this.converterWorkSpace != null) {
            FileUtils.deleteDir(this.converterWorkSpace);
        }
        if (this.isOk() && this.isSign()) {
            this.signer.process();
        }
        if (!this.isOk()) {
            vector = this.out.getAbsolutePath();
            int n = ((String)((Object)vector)).lastIndexOf(46);
            vector = ((String)((Object)vector)).substring(0, n) + ".signature";
            object = new File((String)((Object)vector));
            if (this.out.exists()) {
                this.out.delete();
            }
            if (((File)object).exists()) {
                ((File)object).delete();
            }
        }
    }

    public void setPackageItem(FolderOrJar folderOrJar) {
        this.packageItem = folderOrJar;
    }

    public FolderOrJar getPackageItem() {
        return this.packageItem;
    }

    public String getType() {
        return this.type != null ? this.type.toLowerCase() : null;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getPackageAID() {
        return this.packageAID;
    }

    public void setPackageAID(String string) {
        this.packageAID = string;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String string) {
        this.exportPath = string;
    }

    public File getOut() {
        return this.out;
    }

    public void setOut(File file) {
        this.out = file;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public boolean isUseProxyClass() {
        return this.useProxyClass;
    }

    public void setUseProxyClass() {
        this.useProxyClass = true;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
    }

    public boolean isSign() {
        return this.signer.isRequired();
    }

    public void setSign(boolean bl) {
        this.signer.setRequired(bl);
    }

    public String getKeystore() {
        return this.signer.getKeystore();
    }

    public void setKeystore(String string) {
        this.signer.setKeystore(string);
    }

    public String getStorepass() {
        return this.signer.getStorepass();
    }

    public void setStorepass(String string) {
        this.signer.setStorepass(string);
    }

    public String getPasskey() {
        return this.signer.getPasskey();
    }

    public void setPasskey(String string) {
        this.signer.setPasskey(string);
    }

    public String getAlias() {
        return this.signer.getAlias();
    }

    public void setAlias(String string) {
        this.signer.setAlias(string);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File file) {
        this.workDir = file;
    }

    public String getKeepDir() {
        return this.keepDir;
    }

    public void setKeepDir(String string) {
        this.keepDir = string;
    }

    public void addXtraOption(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() <= 0) {
            return;
        }
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("=");
        if (n == -1) {
            string2 = string;
        } else {
            string2 = string.substring(0, n).trim();
            string3 = string.substring(n + 1).trim();
            if (string3.length() <= 0) {
                string3 = null;
            }
        }
        if (string2.equalsIgnoreCase("workdir") && string3 != null) {
            this.workDir = new File(string3).getAbsoluteFile();
        }
    }

    private void createWorkDir() {
        if (this.workDir == null) {
            this.workDir = new File(System.getProperty("java.io.tmpdir") + "packager_temp_root_" + System.currentTimeMillis()).getAbsoluteFile();
        }
        if (!this.workDir.mkdirs()) {
            this.addError(ErrorKey.UnableToCreateWorkingFolder, this.workDir);
        }
    }

    private void extractClassesAndPutAlongWithExpFile(File file, File file2, boolean bl) throws Exception {
        ZipFile zipFile = new ZipFile(file2);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            File file3;
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            boolean bl2 = zipEntry.isDirectory();
            if (bl2 || !string.endsWith(".class")) continue;
            if (!bl) {
                if (!string.startsWith("APPLET-INF/classes/")) continue;
                string = string.substring(19);
            }
            if (!(file3 = new File(file, string)).getParentFile().exists()) {
                file3.getParentFile().mkdirs();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            int n = 0;
            byte[] byArray = new byte[1024];
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            while ((n = inputStream.read(byArray, 0, 1024)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
        }
        zipFile.close();
    }

    private String findPackage(File file) {
        return this.findPackageFromRoot(file, file);
    }

    private String findPackageFromRoot(File file, File file2) {
        File[] fileArray;
        if (file2.isFile()) {
            if (file2.getName().endsWith(".class")) {
                String string = file2.getAbsoluteFile().getParentFile().getAbsolutePath();
                String string2 = file.getAbsolutePath();
                return string.substring(string2.length() + 1).replace(File.separatorChar, '.');
            }
            return null;
        }
        for (File file3 : fileArray = file2.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            String string = this.findPackageFromRoot(file, file3);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private void copyJavaFiles(File file, File file2) throws Exception {
        try {
            file = file.getCanonicalFile().getAbsoluteFile();
            file2 = file2.getCanonicalFile().getAbsoluteFile();
            String string = file.getAbsolutePath();
            String string2 = null;
            Vector<File> vector = FileUtils.listAllFilesInFolder(file, ".java");
            for (File file3 : vector) {
                file3 = file3.getCanonicalFile().getAbsoluteFile();
                string2 = file3.getAbsolutePath();
                if ((string2 = string2.substring(string.length())).startsWith(File.separator)) {
                    string2 = string2.substring(1);
                }
                FileUtils.copyFile(file3, new File(file2, string2));
            }
        }
        catch (Exception exception) {
            throw new Exception("Unable to keep java files. Error: " + exception.getMessage());
        }
    }
}

