/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.StringArrayValuesMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestHeaderValuesMap
extends StringArrayValuesMap {
    private final HttpServletRequest request;

    RequestHeaderValuesMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String[] get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        ArrayList<String> valuesList = new ArrayList<String>();
        Enumeration valuesEnum = this.request.getHeaders(key.toString());
        while (valuesEnum.hasMoreElements()) {
            valuesList.add((String)valuesEnum.nextElement());
        }
        return valuesList.toArray(new String[valuesList.size()]);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getHeaders(key.toString()) != null;
    }

    @Override
    public Set<Map.Entry<String, String[]>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<String[]> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public int hashCode() {
        return this.hashCode(this.request);
    }

    @Override
    protected Iterator<Map.Entry<String, String[]>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.request.getHeaderNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.request.getHeaderNames());
    }

    @Override
    protected Iterator<String[]> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.request.getHeaderNames());
    }
}

