/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmVisibilityQuery;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.gotodeclaration.symbol.CppSymbolDescriptor;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.symbol.SymbolProvider;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CppSymbolProvider
implements SymbolProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.gotosymbol.trace");
    private static final Logger LOG = TRACE ? Logger.getLogger("cnd.symbol.provider.trace") : null;
    private static final RequestProcessor RP = new RequestProcessor(CppSymbolProvider.class.getName(), 1);
    private static final Object resultLock = new Object();
    private final Object activeTaskLock = new Object();
    private WorkerTask activeTask;

    public CppSymbolProvider() {
        if (TRACE) {
            LOG.info("CppSymbolProvider created");
        }
    }

    public String name() {
        return "C/C++";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CPP_Provider_Display_Name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void computeSymbolNames(SymbolProvider.Context context, SymbolProvider.Result res) {
        WorkerTask task;
        CsmSelect.NameAcceptor nameAcceptor;
        if (TRACE) {
            LOG.log(Level.INFO, "computeSymbolNames {0}", this.toString(context));
        }
        if ((nameAcceptor = CppSymbolProvider.createNameAcceptor(context.getText(), context.getSearchType())) == null) {
            if (CndUtils.isDebugMode()) {
                Logger log = Logger.getLogger("org.netbeans.modules.cnd.gotodeclaration");
                log.log(Level.SEVERE, "Can not create matcher for ''{0}'' search type {1}", new Object[]{context.getText(), context.getSearchType()});
            }
            return;
        }
        Object object = this.activeTaskLock;
        synchronized (object) {
            task = this.activeTask;
            if (task != null && !CppSymbolProvider.sameContext(task.context, context)) {
                task.cancel();
                task = null;
                this.activeTask = null;
            }
            if (task == null) {
                this.activeTask = task = new WorkerTask(context, nameAcceptor);
                RP.submit((Runnable)task);
            }
        }
        while (!task.isDone()) {
            try {
                task.get(200L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                break;
            }
            catch (InterruptedException ex) {
                task.cancel();
                Thread.interrupted();
                if (!TRACE) break;
                LOG.log(Level.INFO, "InterruptedException");
                break;
            }
            catch (CancellationException ex) {
                if (!TRACE) break;
                LOG.log(Level.INFO, "CancellationException");
                break;
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof CancellationException) break;
                Exceptions.printStackTrace((Throwable)ex);
                break;
            }
        }
        if (!task.isDone()) {
            res.pendingResult();
            if (TRACE) {
                LOG.log(Level.INFO, "Results are not fully available yet at {0} ms.", System.currentTimeMillis() - task.startTime);
            }
        } else if (TRACE) {
            LOG.log(Level.INFO, "Results are fully available at {0} ms.", System.currentTimeMillis() - task.startTime);
        }
        res.addResult(task.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        WorkerTask task;
        if (TRACE) {
            LOG.info("cancel request");
        }
        Object object = this.activeTaskLock;
        synchronized (object) {
            task = this.activeTask;
            this.activeTask = null;
        }
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanup() {
        if (TRACE) {
            LOG.info("cleanup request");
        }
        this.cancel();
    }

    private String toString(SymbolProvider.Context context) {
        return String.format("Context: prj=%s type=%s text=%s", context.getProject(), context.getSearchType(), context.getText());
    }

    public static CsmSelect.NameAcceptor createNameAcceptor(String text, SearchType searchType) {
        NameMatcher nameMatcher = NameMatcherFactory.createNameMatcher((String)text, (SearchType)searchType);
        return new NameAcceptorImpl(nameMatcher);
    }

    private static boolean sameContext(SymbolProvider.Context context1, SymbolProvider.Context context2) {
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        if (!context1.getSearchType().equals((Object)context2.getSearchType())) {
            return false;
        }
        return context1.getText().equals(context2.getText());
    }

    private static class Worker
    implements Runnable {
        private final SymbolProvider.Context context;
        private final Set<CppSymbolDescriptor> result;
        private long startTime;
        private final AtomicBoolean cancelled;
        private final CsmSelect.NameAcceptor nameAcceptor;

        private Worker(SymbolProvider.Context context, CsmSelect.NameAcceptor nameAcceptor, Set<CppSymbolDescriptor> result, AtomicBoolean cancelled) {
            if (TRACE) {
                LOG.log(Level.INFO, "New Worker for searching \"{0}\", {1} in {2} created.", new Object[]{context.getText(), context.getSearchType().name(), context.getProject()});
            }
            this.context = context;
            this.result = result;
            this.cancelled = cancelled;
            this.nameAcceptor = nameAcceptor;
        }

        @Override
        public void run() {
            block12: {
                if (TRACE) {
                    this.startTime = System.currentTimeMillis();
                }
                try {
                    CsmCacheManager.enter();
                    try {
                        this.collect(this.context);
                    }
                    finally {
                        CsmCacheManager.leave();
                    }
                    if (!TRACE) break block12;
                    LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} cancelled [after {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                }
                catch (CancellationException ex) {
                    block13: {
                        try {
                            if (!TRACE) break block13;
                            LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} cancelled [after {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                        }
                        catch (Throwable throwable) {
                            if (TRACE) {
                                LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                            }
                            throw throwable;
                        }
                    }
                    if (TRACE) {
                        LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                    }
                }
            }
            if (TRACE) {
                LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
            }
        }

        private void collect(SymbolProvider.Context context) {
            if (context.getProject() == null) {
                HashSet<CsmProject> libs = new HashSet<CsmProject>();
                for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                    this.checkCancelled();
                    this.collectSymbols(csmProject);
                    this.collectLibs(csmProject, libs);
                }
                for (CsmProject csmProject : libs) {
                    this.checkCancelled();
                    this.collectSymbols(csmProject);
                }
            } else {
                CsmProject csmProject;
                NativeProject nativeProject = (NativeProject)context.getProject().getLookup().lookup(NativeProject.class);
                if (nativeProject != null && (csmProject = CsmModelAccessor.getModel().getProject((Object)nativeProject)) != null) {
                    this.collectSymbols(csmProject);
                }
            }
        }

        private void collectLibs(CsmProject project, Collection<CsmProject> libs) {
            for (CsmProject lib : project.getLibraries()) {
                if (libs.contains(lib)) continue;
                libs.add(lib);
                this.collectLibs(lib, libs);
            }
        }

        private void collectSymbols(CsmProject csmProject) {
            this.collectSymbols(csmProject.getGlobalNamespace());
            CsmSelect.CsmFilter nameFilter = CsmSelect.getFilterBuilder().createNameFilter(this.nameAcceptor);
            for (CsmFile csmFile : csmProject.getAllFiles()) {
                this.checkCancelled();
                Iterator macros = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
                while (macros.hasNext()) {
                    this.checkCancelled();
                    CsmMacro macro = (CsmMacro)macros.next();
                    if (!this.nameAcceptor.accept(macro.getName()) || !CsmVisibilityQuery.isVisible((CsmObject)macro)) continue;
                    this.addResult(new CppSymbolDescriptor((CsmOffsetable)macro));
                }
                this.checkCancelled();
                Iterator funcs = CsmSelect.getStaticFunctions((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
                while (funcs.hasNext()) {
                    this.checkCancelled();
                    CsmFunction func = (CsmFunction)funcs.next();
                    if (!this.nameAcceptor.accept(func.getName())) continue;
                    if (CsmKindUtilities.isFunctionDefinition((CsmObject)func)) {
                        if (!CsmVisibilityQuery.isVisible((CsmObject)func)) continue;
                        this.addResult(new CppSymbolDescriptor((CsmOffsetable)func));
                        continue;
                    }
                    CsmFunctionDefinition definition = func.getDefinition();
                    if (definition == null || !CsmVisibilityQuery.isVisible((CsmObject)definition)) continue;
                    this.addResult(new CppSymbolDescriptor((CsmOffsetable)definition));
                }
                this.checkCancelled();
                CsmSelect.CsmFilter definitions = CsmSelect.getFilterBuilder().createCompoundFilter(nameFilter, CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION}));
                Iterator declarations = CsmSelect.getDeclarations((CsmFile)csmFile, (CsmSelect.CsmFilter)definitions);
                while (declarations.hasNext()) {
                    CsmFunction func;
                    this.checkCancelled();
                    CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)declarations.next();
                    if (!this.nameAcceptor.accept(decl.getName()) || !CsmKindUtilities.isFunctionDefinition((CsmObject)decl) || !((CsmFunction)decl).isStatic() || !(func = (CsmFunction)decl).equals(func.getDeclaration()) || !CsmKindUtilities.isFile((CsmObject)func.getScope()) || !CsmVisibilityQuery.isVisible((CsmObject)func)) continue;
                    this.addResult(new CppSymbolDescriptor((CsmOffsetable)func));
                }
                this.checkCancelled();
                Iterator vars = CsmSelect.getStaticVariables((CsmFile)csmFile, (CsmSelect.CsmFilter)nameFilter);
                while (vars.hasNext()) {
                    this.checkCancelled();
                    CsmVariable var = (CsmVariable)vars.next();
                    if (!this.nameAcceptor.accept(var.getName()) || !CsmVisibilityQuery.isVisible((CsmObject)var)) continue;
                    this.addResult(new CppSymbolDescriptor((CsmOffsetable)var));
                }
            }
        }

        private void collectSymbols(CsmNamespace namespace) {
            CsmSelect.CsmFilter nameFilter = CsmSelect.getFilterBuilder().createNameFilter(this.nameAcceptor);
            CsmSelect.CsmFilter simpleKindFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION, CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.TYPEDEF});
            CsmSelect.CsmFilter simpleNameAndKindFilter = CsmSelect.getFilterBuilder().createCompoundFilter(nameFilter, simpleKindFilter);
            Iterator declarations = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)simpleNameAndKindFilter);
            while (declarations.hasNext()) {
                this.checkCancelled();
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)declarations.next();
                if (!this.nameAcceptor.accept(decl.getName())) continue;
                this.addDeclarationItself(decl);
            }
            CsmSelect.CsmFilter kindFilter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT});
            CsmSelect.CsmFilter classesOrMembers = CsmSelect.getFilterBuilder().createOrFilter(kindFilter, nameFilter);
            declarations = CsmSelect.getDeclarations((CsmNamespace)namespace, (CsmSelect.CsmFilter)kindFilter);
            while (declarations.hasNext()) {
                this.checkCancelled();
                this.addDeclarationIfNeed((CsmOffsetableDeclaration)declarations.next(), classesOrMembers, nameFilter);
            }
            for (CsmNamespace child : namespace.getNestedNamespaces()) {
                this.checkCancelled();
                this.collectSymbols(child);
            }
        }

        private void addDeclarationIfNeed(CsmOffsetableDeclaration decl, CsmSelect.CsmFilter classesOrMembers, CsmSelect.CsmFilter nameFilter) {
            block4: {
                block3: {
                    if (this.nameAcceptor.accept(decl.getName())) {
                        this.addDeclarationItself(decl);
                    }
                    if (!CsmKindUtilities.isClass((CsmObject)decl)) break block3;
                    CsmClass cls = (CsmClass)decl;
                    Iterator classMembers = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)classesOrMembers);
                    while (classMembers.hasNext()) {
                        this.addDeclarationIfNeed((CsmOffsetableDeclaration)classMembers.next(), classesOrMembers, nameFilter);
                    }
                    break block4;
                }
                if (!CsmKindUtilities.isEnum((CsmObject)decl)) break block4;
                CsmEnum en = (CsmEnum)decl;
                Iterator enumerators = CsmSelect.getEnumerators((CsmEnum)en, (CsmSelect.CsmFilter)nameFilter);
                while (enumerators.hasNext()) {
                    CsmEnumerator enumerator = (CsmEnumerator)enumerators.next();
                    if (!this.nameAcceptor.accept(enumerator.getName()) || !CsmVisibilityQuery.isVisible((CsmObject)enumerator)) continue;
                    this.addResult(new CppSymbolDescriptor((CsmOffsetable)enumerator));
                }
            }
        }

        private void addDeclarationItself(CsmOffsetableDeclaration decl) {
            if (CsmKindUtilities.isFunction((CsmObject)decl)) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)decl)) {
                    if (CsmVisibilityQuery.isVisible((CsmObject)decl)) {
                        this.addResult(new CppSymbolDescriptor((CsmOffsetable)decl));
                    }
                } else {
                    boolean added = false;
                    CsmFunctionDefinition definition = ((CsmFunction)decl).getDefinition();
                    if (definition != null && CsmVisibilityQuery.isVisible((CsmObject)definition)) {
                        added = true;
                        if (definition != decl) {
                            this.addResult(new CppSymbolDescriptor((CsmOffsetable)decl, (CsmOffsetable)definition));
                        } else {
                            this.addResult(new CppSymbolDescriptor((CsmOffsetable)definition));
                        }
                    }
                    if (!added && CsmVisibilityQuery.isVisible((CsmObject)decl)) {
                        this.addResult(new CppSymbolDescriptor((CsmOffsetable)decl));
                    }
                }
            } else if (CsmVisibilityQuery.isVisible((CsmObject)decl)) {
                this.addResult(new CppSymbolDescriptor((CsmOffsetable)decl));
            }
        }

        private void checkCancelled() throws CancellationException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResult(CppSymbolDescriptor symbolDescriptor) {
            Object object = resultLock;
            synchronized (object) {
                this.result.add(symbolDescriptor);
            }
        }
    }

    private static class WorkerTask
    extends FutureTask<Void> {
        private final Set<CppSymbolDescriptor> result;
        private final SymbolProvider.Context context;
        private final AtomicBoolean cancelled;
        private long startTime;

        public WorkerTask(SymbolProvider.Context context, CsmSelect.NameAcceptor nameAcceptor) {
            this(context, nameAcceptor, new HashSet<CppSymbolDescriptor>(), new AtomicBoolean(false));
        }

        private WorkerTask(SymbolProvider.Context context, CsmSelect.NameAcceptor nameAcceptor, Set<CppSymbolDescriptor> result, AtomicBoolean cancelled) {
            super(new Worker(context, nameAcceptor, result, cancelled), null);
            this.context = context;
            this.result = result;
            this.cancelled = cancelled;
            if (TRACE) {
                this.startTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<CppSymbolDescriptor> getResult() {
            Object object = resultLock;
            synchronized (object) {
                return new ArrayList<CppSymbolDescriptor>(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasResult() {
            Object object = resultLock;
            synchronized (object) {
                return !this.result.isEmpty();
            }
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }

    private static final class NameAcceptorImpl
    implements CsmSelect.NameAcceptor {
        private final NameMatcher nameMatcher;

        public NameAcceptorImpl(NameMatcher nameMatcher) {
            this.nameMatcher = nameMatcher;
        }

        public boolean accept(CharSequence name) {
            return this.nameMatcher.accept(name.toString());
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + this.nameMatcher.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NameAcceptorImpl other = (NameAcceptorImpl)obj;
            return this.nameMatcher.equals(other.nameMatcher);
        }
    }
}

