/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.docker.IgnorePattern;

public class IgnoreFileFilter
implements FileFilter {
    private final File buildContext;
    private final File dockerfile;
    private final File dockerignore;
    private final List<IgnorePattern> patterns = new ArrayList<IgnorePattern>();

    public IgnoreFileFilter(File buildContext, File dockerfile, char separator) throws IOException {
        this.buildContext = buildContext;
        this.dockerfile = dockerfile != null ? dockerfile : new File(buildContext, "Dockerfile");
        this.dockerignore = new File(buildContext, ".dockerignore");
        if (this.dockerignore.isFile()) {
            this.patterns.addAll(this.load(this.dockerignore, separator));
        }
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.equals(this.dockerfile) || pathname.equals(this.dockerignore)) {
            return true;
        }
        assert (pathname.getAbsolutePath().startsWith(this.buildContext.getAbsolutePath()) && !pathname.equals(this.buildContext));
        String path = pathname.getAbsolutePath().substring(this.buildContext.getAbsolutePath().length());
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return this.accept(path);
    }

    public boolean accept(String relativePath) {
        assert (!(relativePath.startsWith("/") || relativePath.endsWith("/") || relativePath.isEmpty()));
        String path = relativePath;
        boolean include = true;
        for (IgnorePattern p : this.patterns) {
            if (!p.matches(path)) continue;
            include = p.isNegative();
        }
        return include;
    }

    private List<IgnorePattern> load(File dockerignore, char separator) throws IOException {
        ArrayList<IgnorePattern> ret = new ArrayList<IgnorePattern>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dockerignore), "UTF-8"));){
            String line;
            while ((line = r.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                ret.add(IgnorePattern.compile(line, Character.valueOf(separator), true));
            }
        }
        return ret;
    }
}

