/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.branch;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Action;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.client.ProgressDelegate;
import org.netbeans.modules.git.remote.ui.branch.Bundle;
import org.netbeans.modules.git.remote.ui.fetch.PullAction;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.LogUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class BranchSynchronizer {
    public void syncBranches(final VCSFileProxy repository, final String[] branchNames, final boolean interactive) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    new Executor(this.getClient(), this.getLogger(), repository, branchNames, this.getProgress(), interactive).execute();
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), interactive);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_SyncBranchAction_progressName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncBranches(VCSFileProxy repository, String[] branchNames, ProgressDelegate progress, OutputLogger logger) throws GitException {
        GitClient client = null;
        try {
            client = Git.getInstance().getClient(repository);
            new Executor(client, logger, repository, branchNames, progress, false).execute();
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    private static Map<String, GitBranch> getBranches(VCSFileProxy repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        return info.getBranches();
    }

    private static class Executor {
        private final OutputLogger logger;
        private final GitClient client;
        private final boolean interactive;
        private final VCSFileProxy repository;
        private final String[] branchNames;
        private final ProgressDelegate progress;

        public Executor(GitClient client, OutputLogger logger, VCSFileProxy repository, String[] branchNames, ProgressDelegate progress, boolean interactive) {
            this.client = client;
            this.logger = logger;
            this.repository = repository;
            this.branchNames = branchNames;
            this.interactive = interactive;
            this.progress = progress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            for (String branchName : this.branchNames) {
                try {
                    Map branches = BranchSynchronizer.getBranches(this.repository);
                    GitBranch branch = (GitBranch)branches.get(branchName);
                    if (branch == null) {
                        return;
                    }
                    final GitBranch tracked = branch.getTrackedBranch();
                    if (tracked == null) {
                        return;
                    }
                    this.logger.outputLine(Bundle.MSG_SyncBranchAction_result(branch.getName(), tracked.getName()));
                    GitRevisionInfo ancestor = this.client.getCommonAncestor(new String[]{branch.getName(), tracked.getName()}, this.progress.getProgressMonitor());
                    if (this.progress.isCanceled()) {
                        return;
                    }
                    if (this.equal(ancestor, tracked)) {
                        if (!tracked.isRemote() || this.equal(ancestor, branch)) {
                            this.processResult(GitRefUpdateResult.NO_CHANGE, branch, tracked);
                            continue;
                        }
                        this.processPushNeeded(branch);
                        continue;
                    }
                    if (branch.isActive()) {
                        try {
                            GitUtils.runWithoutIndexing(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    new PullAction.BranchSynchronizer(tracked.getName(), Executor.this.repository, new PullAction.BranchSynchronizer.GitProgressSupportDelegate(){

                                        @Override
                                        public GitClient getClient() throws GitException {
                                            return Executor.this.client;
                                        }

                                        @Override
                                        public OutputLogger getLogger() {
                                            return Executor.this.logger;
                                        }

                                        @Override
                                        public ProgressDelegate getProgress() {
                                            return Executor.this.progress;
                                        }
                                    }).execute();
                                    return null;
                                }
                            }, new VCSFileProxy[0]);
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.repository, Git.getInstance().getSeenRoots(this.repository)));
                        }
                        catch (Throwable throwable) {
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.repository, Git.getInstance().getSeenRoots(this.repository)));
                            GitUtils.headChanged(this.repository);
                            throw throwable;
                        }
                        GitUtils.headChanged(this.repository);
                        continue;
                    }
                    GitRefUpdateResult res = this.client.updateReference(branchName, tracked.getName(), this.progress.getProgressMonitor());
                    this.processResult(res, branch, tracked);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), this.interactive);
                }
            }
        }

        private void processResult(GitRefUpdateResult result, GitBranch current, GitBranch tracked) {
            GitRevisionInfo info = null;
            StringBuilder sb = new StringBuilder();
            switch (result) {
                case REJECTED: {
                    sb.append(Bundle.MSG_SyncBranchAction_result_rejected());
                    final Action openAction = this.logger.getOpenOutputAction();
                    if (openAction != null && this.interactive) {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    openAction.actionPerformed(new ActionEvent(this, 1001, null));
                                }
                            });
                        }
                        catch (InterruptedException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                    if (!this.interactive) break;
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_SyncBranchAction_result_rejected(), 0));
                    break;
                }
                case FAST_FORWARD: {
                    try {
                        info = this.client.log(current.getName(), GitUtils.NULL_PROGRESS_MONITOR);
                        sb.append(Bundle.MSG_SyncBranchAction_result_ff(current.getName()));
                        GitUtils.printInfo(sb, info, false);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                    }
                    break;
                }
                case NOT_ATTEMPTED: {
                    sb.append(Bundle.MSG_SyncBranchAction_result_notAttempted(current.getName()));
                    break;
                }
                case NO_CHANGE: {
                    sb.append(Bundle.MSG_SyncBranchAction_result_upToDate(tracked.getName()));
                    break;
                }
                default: {
                    sb.append(result.toString());
                }
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
            if (info != null) {
                LogUtils.logBranchUpdateReview(this.repository, current.getName(), current.getId(), info.getRevision(), this.logger);
            }
        }

        private boolean equal(GitRevisionInfo ancestor, GitBranch branch) {
            return ancestor != null && ancestor.getRevision().equals(branch.getId());
        }

        private void processPushNeeded(GitBranch branch) {
            this.logger.outputLine(Bundle.MSG_SyncBranchAction_result_notAttempted_pushNeeded(branch.getName()));
        }
    }
}

