/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.branch;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.ui.branch.Bundle;
import org.netbeans.modules.git.remote.ui.branch.CherryPickPanel;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class CherryPick {
    private final CherryPickPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean valid;
    private final VCSFileProxy repository;
    private final RequestProcessor.Task mergedIntoTask;
    private String revision;

    CherryPick(VCSFileProxy repository, String initialRevision) {
        this.repository = repository;
        this.revisionPicker = new RevisionDialogController(repository, new VCSFileProxy[]{repository}, initialRevision);
        this.revisionPicker.setMergingInto("HEAD");
        this.panel = new CherryPickPanel(this.revisionPicker.getPanel());
        this.mergedIntoTask = Utils.createTask((Runnable)new MergedIntoTask());
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getCommitId();
    }

    boolean showDialog() {
        this.okButton = new JButton(Bundle.LBL_CherryPick_OKButton_text());
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, Bundle.LBL_CherryPick_title(this.repository), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx("org.netbeans.modules.git.remote.ui.branch.CherryPick"), null);
        this.enableRevisionPanel();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CherryPick.this.mergedIntoTask.cancel();
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    boolean v = Boolean.TRUE.equals(evt.getNewValue());
                    CherryPick.this.setValid(v);
                    if (v) {
                        CherryPick.this.revision = CherryPick.this.getRevision();
                        CherryPick.this.mergedIntoTask.schedule(500);
                    }
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void enableRevisionPanel() {
        this.setValid(this.valid);
    }

    private void setValid(boolean flag) {
        this.valid = flag;
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
        this.panel.lblError.setVisible(false);
    }

    private class MergedIntoTask
    implements Runnable,
    Cancellable {
        private ProgressMonitor.DefaultProgressMonitor pm;

        private MergedIntoTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.pm = new ProgressMonitor.DefaultProgressMonitor();
            final GitBranch activeBranch = RepositoryInfo.getInstance(CherryPick.this.repository).getActiveBranch();
            boolean mergedInto = false;
            final String rev = CherryPick.this.revision;
            if (activeBranch.getId().equals(rev)) {
                mergedInto = true;
            } else {
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(CherryPick.this.repository);
                    GitRevisionInfo ancestor = client.getCommonAncestor(new String[]{CherryPick.this.revision, "HEAD"}, (ProgressMonitor)this.pm);
                    if (ancestor != null && ancestor.getRevision().equals(rev)) {
                        mergedInto = true;
                    }
                }
                catch (GitException ex) {
                    Logger.getLogger(CherryPick.class.getName()).log(Level.FINE, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }
            final boolean merged = mergedInto;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (rev.equals(CherryPick.this.revision) && merged) {
                        ((CherryPick)CherryPick.this).panel.lblError.setText(Bundle.CherryPickPanel_info_merged(activeBranch.getName()));
                        ((CherryPick)CherryPick.this).panel.lblError.setVisible(true);
                    }
                }
            });
        }

        public boolean cancel() {
            return this.pm != null && this.pm.cancel();
        }
    }
}

