/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.openide.util.NbBundle;

public abstract class WizardStepProgressSupport
extends GitProgressSupport {
    private OutputLogger logger;
    private JPanel progressComponent;
    private JLabel progressLabel;
    private JPanel panel;
    private JButton stopButton;
    private boolean noOutputLogging;

    public WizardStepProgressSupport(JPanel panel, boolean noOutputLogging) {
        this(panel);
        this.noOutputLogging = noOutputLogging;
    }

    public WizardStepProgressSupport(JPanel panel) {
        this.panel = panel;
    }

    public abstract void setEnabled(boolean var1);

    @Override
    public void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressHandle progress = WizardStepProgressSupport.this.getProgressHandle();
                JComponent bar = ProgressHandleFactory.createProgressComponent((ProgressHandle)progress);
                WizardStepProgressSupport.this.stopButton = new JButton(NbBundle.getMessage(WizardStepProgressSupport.class, (String)"BK2022"));
                WizardStepProgressSupport.this.stopButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WizardStepProgressSupport.this.cancel();
                    }
                });
                WizardStepProgressSupport.this.panel.setLayout(new BorderLayout());
                WizardStepProgressSupport.this.progressComponent = new JPanel();
                WizardStepProgressSupport.this.progressComponent.setLayout(new BorderLayout(6, 0));
                WizardStepProgressSupport.this.progressLabel = new JLabel();
                WizardStepProgressSupport.this.progressLabel.setText(WizardStepProgressSupport.super.getDisplayName());
                WizardStepProgressSupport.this.progressComponent.add((Component)WizardStepProgressSupport.this.progressLabel, "North");
                WizardStepProgressSupport.this.progressComponent.add((Component)bar, "Center");
                WizardStepProgressSupport.this.progressComponent.add((Component)WizardStepProgressSupport.this.stopButton, "After");
                WizardStepProgressSupport.super.startProgress();
                WizardStepProgressSupport.this.panel.setVisible(true);
                WizardStepProgressSupport.this.panel.add(WizardStepProgressSupport.this.progressComponent);
                WizardStepProgressSupport.this.panel.revalidate();
            }
        });
    }

    @Override
    protected void finishProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardStepProgressSupport.super.finishProgress();
                WizardStepProgressSupport.this.panel.remove(WizardStepProgressSupport.this.progressComponent);
                WizardStepProgressSupport.this.panel.revalidate();
                WizardStepProgressSupport.this.panel.repaint();
                WizardStepProgressSupport.this.panel.setVisible(false);
                WizardStepProgressSupport.this.setEnabled(true);
            }
        });
    }

    @Override
    public void setDisplayName(String displayName) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(displayName);
        }
        super.setDisplayName(displayName);
    }

    @Override
    public synchronized boolean cancel() {
        if (this.stopButton != null) {
            this.stopButton.setEnabled(false);
        }
        this.setDisplayName(NbBundle.getMessage(WizardStepProgressSupport.class, (String)"MSG_Progress_Terminating"));
        return super.cancel();
    }

    @Override
    public final OutputLogger getLogger() {
        if (this.noOutputLogging) {
            if (this.logger == null) {
                this.logger = OutputLogger.getLogger(null);
            }
            return this.logger;
        }
        return super.getLogger();
    }
}

