/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search;

import java.awt.Image;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class IconsCache {
    private static final IconsCache cache = new IconsCache();
    private static final int cacheLifetime = 60000;
    private final RequestProcessor.Task cleanUpTask;
    private final HashMap<String, Image> map = new HashMap();
    private final FileObject root = FileUtil.createMemoryFileSystem().getRoot();

    private IconsCache() {
        this.cleanUpTask = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cache.map.clear();
                    }
                });
            }
        }, 60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getIcon(String name, int type) {
        Image icon;
        IconsCache.cache.cleanUpTask.schedule(60000);
        if (name.indexOf(46) < 0) {
            name = "noext";
        }
        if ((icon = IconsCache.cache.map.get(name + type)) == null) {
            FileObject fo = IconsCache.createMemoryFile(name);
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                icon = dob.getNodeDelegate().getIcon(type);
                IconsCache.cache.map.put(name + type, icon);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fo != null) {
                    try {
                        fo.delete();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return icon;
    }

    private static FileObject createMemoryFile(String name) {
        FileObject fo = null;
        try {
            fo = FileUtil.createData((FileObject)IconsCache.cache.root, (String)name);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return fo;
    }
}

