/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.ui.ComponentUtils;
import org.netbeans.api.search.ui.FileNameController;
import org.netbeans.api.search.ui.ScopeController;
import org.netbeans.api.search.ui.SearchPatternController;
import org.netbeans.modules.cnd.search.impl.SearchBrowseHostScope;
import org.netbeans.modules.cnd.search.util.SearchScopeValidator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class CNDSearchPanel
extends JPanel {
    private final ScopeController scopeController;
    private FileNameController fileNameController;
    private SearchPatternController searchPatternController;
    private volatile ValidationStatus validationStatus;
    private final ChangesListener listener;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final SearchScopeValidator validator = new SearchScopeValidator();
    private JCheckBox cbCaseSensitive;
    private JComboBox cbFilename;
    private JComboBox cbScope;
    private JComboBox cbSearchPattern;
    private JCheckBox cbWholeWords;
    private JLabel lblFilename;
    private JLabel lblScope;
    private JLabel lblText;

    public CNDSearchPanel() {
        this.initComponents();
        this.listener = new ChangesListener();
        this.scopeController = ComponentUtils.adjustComboForScope((JComboBox)this.cbScope, null, (SearchScopeDefinition[])this.getAdditionalSearchScopes());
        this.cbScope.addActionListener(this.listener);
        this.fileNameController = ComponentUtils.adjustComboForFileName((JComboBox)this.cbFilename);
        this.fileNameController.addChangeListener((ChangeListener)this.listener);
        this.searchPatternController = ComponentUtils.adjustComboForSearchPattern((JComboBox)this.cbSearchPattern);
        this.searchPatternController.bind(SearchPatternController.Option.MATCH_CASE, (AbstractButton)this.cbCaseSensitive);
        this.searchPatternController.bind(SearchPatternController.Option.WHOLE_WORDS, (AbstractButton)this.cbWholeWords);
        this.searchPatternController.addChangeListener((ChangeListener)this.listener);
        this.validationStatus = null;
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.cbSearchPattern = new JComboBox();
        this.cbCaseSensitive = new JCheckBox();
        this.cbWholeWords = new JCheckBox();
        this.lblScope = new JLabel();
        this.cbScope = new JComboBox();
        this.lblFilename = new JLabel();
        this.cbFilename = new JComboBox();
        this.setPreferredSize(new Dimension(470, 270));
        this.lblText.setLabelFor(this.cbSearchPattern);
        Mnemonics.setLocalizedText((JLabel)this.lblText, (String)NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.lblText.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCaseSensitive, (String)NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.cbCaseSensitive.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWholeWords, (String)NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.cbWholeWords.text"));
        this.lblScope.setLabelFor(this.cbScope);
        Mnemonics.setLocalizedText((JLabel)this.lblScope, (String)NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.lblScope.text"));
        this.lblFilename.setLabelFor(this.cbFilename);
        Mnemonics.setLocalizedText((JLabel)this.lblFilename, (String)NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.lblFilename.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbScope, 0, -1, Short.MAX_VALUE).addComponent(this.cbFilename, 0, -1, Short.MAX_VALUE).addComponent(this.cbSearchPattern, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbCaseSensitive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbWholeWords)).addComponent(this.lblText).addComponent(this.lblScope).addComponent(this.lblFilename)).addGap(0, 181, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSearchPattern, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbCaseSensitive).addComponent(this.cbWholeWords)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblScope).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScope, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbFilename, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    public String getFileName() {
        return this.fileNameController.getFileNamePattern();
    }

    public SearchInfo getSearchInfo() {
        return this.scopeController.getSearchInfo();
    }

    public ValidationStatus getValidationStatus() {
        if (this.validationStatus == null) {
            this.updateValidationStatus();
        }
        return this.validationStatus;
    }

    private void updateValidationStatus() {
        SearchPattern searchPattern = this.searchPatternController.getSearchPattern();
        String pattern = searchPattern.getSearchExpression();
        if (!this.validator.isSearchAllowed(this.scopeController.getSearchInfo())) {
            this.validationStatus = ValidationStatus.NOT_SUPPORTED;
        } else if (pattern.isEmpty() && this.getFileName().isEmpty()) {
            this.validationStatus = ValidationStatus.NO_PARAMS;
        } else {
            this.validationStatus = ValidationStatus.OK;
            try {
                Pattern.compile(pattern);
            }
            catch (Exception ex) {
                this.validationStatus = ValidationStatus.WRONG_REGEXPR;
            }
        }
        this.cs.fireChange();
    }

    private SearchScopeDefinition[] getAdditionalSearchScopes() {
        ArrayList<SearchScopeDefinition> result = new ArrayList<SearchScopeDefinition>();
        List recentConnections = ConnectionManager.getInstance().getRecentConnections();
        for (ExecutionEnvironment env : recentConnections) {
            SearchBrowseHostScope scope = new SearchBrowseHostScope(env);
            result.add(scope.getBrowseScope());
            result.add(scope.getLastScope());
        }
        return result.toArray(new SearchScopeDefinition[result.size()]);
    }

    public SearchPattern getSearchPattern() {
        return this.searchPatternController.getSearchPattern();
    }

    public void storeSettings() {
        SearchHistory.getDefault().add(this.getSearchPattern());
    }

    public static class ValidationStatus {
        public static final ValidationStatus OK = new ValidationStatus(null);
        private static final ValidationStatus NO_PARAMS = new ValidationStatus(NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.ValidationStatus.no_params"));
        private static final ValidationStatus WRONG_REGEXPR = new ValidationStatus(NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.ValidationStatus.wrong_regexpr"));
        private static ValidationStatus NOT_SUPPORTED = new ValidationStatus(NbBundle.getMessage(CNDSearchPanel.class, (String)"CNDSearchPanel.ValidationStatus.not_suppotred"));
        public final String error;

        public ValidationStatus(String error) {
            this.error = error;
        }
    }

    private class ChangesListener
    implements ChangeListener,
    DocumentListener,
    ActionListener {
        private ChangesListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            CNDSearchPanel.this.updateValidationStatus();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CNDSearchPanel.this.updateValidationStatus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CNDSearchPanel.this.updateValidationStatus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CNDSearchPanel.this.updateValidationStatus();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CNDSearchPanel.this.updateValidationStatus();
        }
    }
}

